<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------
?>

<div class="plugin_forum_item">
	<?php
	if(isset($_SESSION['connection_permission']) && checkPermission('forum', 'add_forum_subject', $_SESSION['connection_permission']) || isset($_SESSION['connection_permission']) && checkPermission('forum', 'forum_maintain', $_SESSION['connection_permission'])) {
	?>
	<div class="plugin_forum_metadata_top">
		<?php
		if(isset($_SESSION['connection_permission']) && checkPermission('forum', 'add_forum_subject', $_SESSION['connection_permission'])) {
		?>
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=edit_subject&amp;c=forum"><?php echo $lang['href_add_subject'];?></a>
		<?php }?>

		<?php
		if(isset($_SESSION['connection_permission']) && checkPermission('forum', 'forum_maintain', $_SESSION['connection_permission'])) {
		?>
		&nbsp;&#124;&nbsp;
		
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=maintain_forum&amp;c=forum"><?php echo $lang['href_maintain_forum'];?></a>
		<?php }?>
	</div>
	<?php }?>

	<?php
	if (isset($subject)) {
	?>
	<h1><?php echo ucfirst($subject['subject_title']);?></h1>
		
	<p>
		<?php echo $subject['subject_body'];?><br />
	</p>
	
	<form action="components/forum/relay/update_subject.php" method="post">
	<input type="hidden" name="subject_locked" value="<?php echo $subject['subject_locked'];?>" />
	<input type="hidden" name="subject_sticky" value="<?php echo $subject['subject_sticky'];?>" />
	<input type="hidden" name="subject_id" value="<?php echo $subject['subject_id'];?>" />
	
	<div class="plugin_forum_metadata_bottom">
		<?php
		if(isset($_SESSION['connection_permission']) && checkPermission('forum', 'forum_maintain', $_SESSION['connection_permission'])) {
	
		if (!empty($subject['subject_locked'])) {
			$lang['sub_lock'] = $lang['sub_unlock'];
		}
		
		if (!empty($subject['subject_sticky'])) {
			$lang['sub_stick'] = $lang['sub_unstick'];
		}
		?>
		<input type="submit" name="update_subject_locked" value="<?php echo $lang['sub_lock'];?>" class="input_submit" />
		<input type="submit" name="update_subject_sticky" value="<?php echo $lang['sub_stick'];?>" class="input_submit" />
		&nbsp;
		<?php }?>

		<a href="#tag_box_content" onclick="javascript:getTags('forum', <?php echo $subject['subject_id'];?>, <?php echo $webspace['webpage_id'];?>);"><?php echo $lang['txt_tags']; ?></a>

		&nbsp;&#124;&nbsp;

		<?php
		$plugin_name = "forum";
		$rate_item_id = $subject['subject_id'];
		include($template_path_core . "inc/rate.inc.php");
		?>

		&nbsp;&#124;&nbsp;

		<?php echo am_strftime($subject['subject_create_datetime']);?>

		&nbsp;&#124;&nbsp;

		<?php
		if (!empty($subject['subject_edit_datetime'])) {
		?>
		(<?php echo $lang['txt_last_edit_datetime'];?>: <?php echo am_strftime($subject['subject_edit_datetime'],1);?>)&nbsp;&#124;&nbsp;
		<?php }?>

		<?php
		if (isset($_SESSION['connection_id']) && $_SESSION['connection_id'] == $subject['connection_id']) {
		?>
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=edit_subject&amp;c=forum&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;subject_id=<?php echo $subject['subject_id'];?>"><?php echo $lang['href_edit'];?></a>

		&nbsp;&#124;&nbsp;
		<?php }?>

		<a href="<?php echo $subject['connection_openid'];?>"><?php echo $subject['connection_nickname']?></a><br />
	</div>
	</form>
	<?php
	}
	else {
	?>
	<p>
		<?php echo $lang['err_no_subject'];?>
	</p>
	<?php }?>

	<?php
	if (isset($subject['subject_id'])) {
		$plugin_name = "forum";
		$tag_item_id = $subject['subject_id'];
		include($template_path_core . "inc/tags.inc.php");
	}
	?>
</div>
