<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";

if (!isset($_SESSION['md5'])) {
	header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . strip_tags(SID));
	exit;
}


// FILE -----------------------------------
require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);

if (isset($core_config['module'])) {
	$file->core_config_module = $core_config['module'];
}

$file->module_id = 0; // core

$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
$user->file = $file;


// GET RELATION IDENTITIY ----------------------------------------------
$output_identity_relation = $user->selUserIdentity(null, $_REQUEST['identity_id_relation'], 1);

if (empty($output_identity_relation)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


// GET IDENTITIY ----------------------------------------------
$output_identity = $user->selUserIdentity(null, $_REQUEST['identity_id'], 1);

if (empty($output_identity)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];


// Create network
include_once ('class/Network.class.php');
$network = new Network($db, $core_config, $_REQUEST['identity_id'], $_REQUEST['identity_id_relation']);
$network->file = $file;

if ($output_identity['user_id'] == $output_identity_relation['user_id']) {
	header('location: index.php?amn=core_me_ties');
	exit;
}
elseif ($output_identity_relation['user_id'] == $_SESSION['user_id']) {
	header('location: index.php?amn=core_tie_matrix&identity_id=' . $_REQUEST['identity_id_relation'] . "&identity_id_relation=" . $_REQUEST['identity_id']);
	exit;
}
elseif ($output_identity['user_id'] == $_SESSION['user_id']) {
	$network->user_id = $_SESSION['user_id'];
	$output_relation_user = $network->selMatrix();
	unset($network->user_id);
	$body->set('relation_user', $output_relation_user);
}

$body->set('identity', $output_identity);
$body->set('identity_relation', $output_identity_relation);

// get invitees
if (isset($output_identity['invitee'])) {
	$invitee['identity']['matrix'] = $network->selMatrix($_REQUEST['identity_id'], $output_identity['invitee']['identity_id']);
}
if (isset($output_identity_relation['invitee'])) {
	$invitee['identity_relation']['matrix'] = $network->selMatrix($_REQUEST['identity_id_relation'], $output_identity_relation['invitee']['identity_id']);
}

if (!empty($invitee)) {
	$body->set('invitee', $invitee);
}

// we include all module files which have a function to obtain a single item
// module_id 1 will include a function called -selItemModule1
if (!empty($core_config['module'])) {
	foreach($core_config['module'] as $key => $i):
		$suffix = $core_config['module'][$key]['prefix'];

		if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
			include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
		}
	endforeach;
}

	
// format summary
$respected_summary = $network->selMatrix();

if (!empty($respected_summary[0]['relation']['respected'])) {
	$lang['txt_relation_summary1'] = str_replace('SYS_KEYWORD_IDENITITY_NIC_RELATION', $respected_summary[0]['identity_relation']['identity_nic'], $lang['txt_relation_summary1']);
	$lang['txt_relation_summary1'] = str_replace('SYS_KEYWORD_IDENITITY_NIC', $respected_summary[0]['identity']['identity_nic'], $lang['txt_relation_summary1']);
	$lang['txt_relation_summary1'] = str_replace('SYS_KEYWORD_DATE', $date->formatDate($respected_summary[0]['relation']['respected']['relation_create_datetime']), $lang['txt_relation_summary1']);

	$lang['txt_respect_intro'] = str_replace('SYS_KEYWORD_IDENITITY_NIC_RELATION', $respected_summary[0]['identity_relation']['identity_nic'], $lang['txt_respect_intro']);
	$lang['txt_respect_intro'] = str_replace('SYS_KEYWORD_IDENITITY_NIC', $respected_summary[0]['identity']['identity_nic'], $lang['txt_respect_intro']);
	
	if ($respected_summary[0]['relation']['respected']['module_id'] != 0) {
		$suffix = $core_config['module'][$respected_summary[0]['relation']['respected']['module_id']]['prefix'];
		$function_name = "selItemModule_" . $suffix;

		if (function_exists($function_name)) {
			$output_respected_item = $function_name($respected_summary[0]['relation']['respected']['item_id']);
			$body->set('respected_item', $output_respected_item);
		}
	}
	else { // Core
		$output_respected_item['item_url'] = "index.php?amn=core_profile&identity_id=" . $respected_summary[0]['identity_relation']['identity_id'];
		$output_respected_item['item_title'] = $lang['txt_core_relation'];
		$body->set('respected_item', $output_respected_item); 
	}
}
else {
	unset($lang['txt_relation_summary1']);
}

if (!empty($respected_summary[0]['relation']['mutual'])) {
	$lang['txt_relation_summary2'] = str_replace('SYS_KEYWORD_IDENITITY_NIC_RELATION', $respected_summary[0]['identity_relation']['identity_nic'], $lang['txt_relation_summary2']);
	$lang['txt_relation_summary2'] = str_replace('SYS_KEYWORD_IDENITITY_NIC', $respected_summary[0]['identity']['identity_nic'], $lang['txt_relation_summary2']);
	$lang['txt_relation_summary2'] = str_replace('SYS_KEYWORD_DATE', $date->formatDate($respected_summary[0]['relation']['mutual']['relation_create_datetime']), $lang['txt_relation_summary2']);
	
	if ($respected_summary[0]['relation']['mutual']['module_id'] != 0) {
		$suffix = $core_config['module'][$respected_summary[0]['relation']['mutual']['module_id']]['prefix'];
		$function_name = "selItemModule_" . $suffix;

		if (function_exists($function_name)) {
			$output_respected_item_relation = $function_name($respected_summary[0]['relation']['mutual']['item_id']);
			$body->set('respected_item_relation', $output_respected_item_relation);
		}
	}
	else { // Core
		$output_respected_item_relation['item_url'] = "index.php?amn=core_profile&identity_id=" . $respected_summary[0]['identity']['identity_id'];
		$output_respected_item_relation['item_title'] = $lang['txt_core_relation'];
		$body->set('respected_item_relation', $output_respected_item_relation); 
	}
}
else {
 	unset($lang['txt_relation_summary2']);
}


// get shared participation
$shared_participation = $network->sharedParticipation();

if (isset($core_config['module']) && !empty($shared_participation)) {
	
	foreach($shared_participation as $key => $i) {
		$suffix = $core_config['module'][$i['module_id']]['prefix'];
		$function_name = "selItemModule_" . $suffix;

		if (function_exists($function_name)) {
			$shared_participation[$key]['item'] = $function_name($i['item_id']);
		}
	}
}

if (!empty($shared_participation)) {
	$body->set('shared_participation', $shared_participation);

	$lang['txt_shared_participation_intro'] = str_replace('SYS_KEYWORD_PARTICIPATION_COUNT', count($shared_participation), $lang['txt_shared_participation_intro']);
}


// get mutually respected networks
$mutual_respected['identity_id'] = $network->selMutualRespected();
$mutual_respected['identity_id_relation'] = $network->selMutualRespected($_REQUEST['identity_id_relation']);


foreach($mutual_respected['identity_id'] as $key => $m):
	$network->setIdentities($_REQUEST['identity_id'], $m['identity_id']);
	$mutual_respected['identity_id'][$key]['matrix'] = $network->selMatrix();
endforeach;

foreach($mutual_respected['identity_id_relation'] as $key => $m):
	$network->setIdentities($_REQUEST['identity_id_relation'], $m['identity_id']);
	$mutual_respected['identity_id_relation'][$key]['matrix'] = $network->selMatrix();
endforeach;

$mutual_respected_statistics['identity_id'] = $network->IdentityStatistics($_REQUEST['identity_id']);
$mutual_respected_statistics['identity_id_relation'] = $network->IdentityStatistics($_REQUEST['identity_id_relation']);


$body->set('mutual_respected', $mutual_respected);
$body->set('statistics', $mutual_respected_statistics);


$query = "
	SELECT t.testifier_identity_id, t.identity_id, t.testimonial_body, 
	t.testimonial_create_datetime, t.testimonial_id, i.identity_nic
	FROM " . $db->prefix . "_user_testimonial t
	INNER JOIN " . $db->prefix . "_user_identity i
	ON t.testifier_identity_id=i.identity_id
	WHERE t.identity_id=" . $_REQUEST['identity_id'] . "
	AND t.testifier_identity_id=" . $_REQUEST['identity_id_relation'] . ""
;

$result = $db->Execute($query);

if (isset($result->fields)) {
	$output_testimonial['identity'] = array();
	while(!$result->EOF) {
		array_push($output_testimonial['identity'], $result->fields);
		$result->moveNext();
	}
	$result->Close();
}
else {
	$error_info = "script=tie_matrix.php -- " . $query . " -- " . $db->ErrorMsg();
	$GLOBALS['am_error_log'][] = array('db_error', $error_info);
}

$query = "
	SELECT t.testifier_identity_id, t.identity_id, t.testimonial_body, 
	t.testimonial_create_datetime, t.testimonial_id, i.identity_nic
	FROM " . $db->prefix . "_user_testimonial t
	INNER JOIN " . $db->prefix . "_user_identity i
	ON t.testifier_identity_id=i.identity_id
	WHERE t.identity_id=" . $_REQUEST['identity_id_relation'] . "
	AND t.testifier_identity_id=" . $_REQUEST['identity_id'] . ""
;

$result = $db->Execute($query);

if (isset($result->fields)) {
	$output_testimonial['identity_relation'] = array();
	while(!$result->EOF) {
		array_push($output_testimonial['identity_relation'], $result->fields);
		$result->moveNext();
	}
	$result->Close();
}
else {
	$error_info = "script=tie_matrix.php -- " . $query . " -- " . $db->ErrorMsg();
	$GLOBALS['am_error_log'][] = array('db_error', $error_info);
}

if (!empty($output_testimonial)) {
	$body->set('testimonials', $output_testimonial);
}

?>