<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// we select people
// foreach person we calculate their social network
// for each degree we update the social network statistics
// we remove the calculate social network flag from their _sn table entry

$path = dirname(__FILE__) . "/";

include $path . "../components/core/config/aroundme_core.config.php";
include $path . "../batch/batch.config.php";


// SETUP DATABASE --------------------------------------------------------
require_once('../components/core/class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$ADODB_COUNTRECS = false;
$db = NewADOConnection($core_config['db']['driver']);
if ($db->Connect($core_config['db']['host'], $core_config['db']['user'] , $core_config['db']['pass'] , $core_config['db']['db'])) {
	$db->prefix = $core_config['db']['prefix'];

	// select pending users who registered over 24 hours ago
	$yesterday = date("Y-m-d h:i:s", time() - (24*60*60));
	$yesterday = $db->DBDate($yesterday);
	
	//write to log file
	if (isset($GLOBALS['am_log']) && $GLOBALS['am_log'] == true) {
		$query = "
			SELECT user_email FROM " . $db->prefix . "_user 
			WHERE
			status_id=" . $core_config['user']['status']['pending'] . " AND
			user_create_datetime<=" . $yesterday
		;
		
		$result = $db->Execute($query);
		
		$log = "";
		
		while (!$result->EOF) {
			$log .= $result->fields['user_email'] . "\n";
			
			$result->MoveNext();
		}
		
		if (!empty($log)) {
			
			$log = "The following pending users where deleted from the database at " . date("Y-m-d h:i:s") . "\n" . $log;
		}
		writeLogFile($log, "../");
	}
	
	// delete pending users
	$query = "
		DELETE FROM " . $db->prefix . "_user 
		WHERE
		status_id=" . $core_config['user']['status']['pending'] . " AND
		user_create_datetime<=" . $yesterday
	;
	
	$result = $db->Execute($query);
	
	$db->Close();
}

?>