<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// if we receive a module_id and an item_id we display the stylesheet based upon that item

if (!isset($_SESSION['md5'])) {
	header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . strip_tags(SID));
	exit;
}

$menu_section= "me";


// MODULE HEADER INCLUSION -----------------------------------------------
// We include any header files for the modules
if (empty($suffix)) {
	$suffix = "core";
}

if (is_file("components/" . $suffix . "/inc/" . $suffix . "_stylesheet_editor.inc.php")) {
	include_once("components/" . $suffix . "/inc/" . $suffix . "_stylesheet_editor.inc.php");
}



// we get the stylesheet -----------------------------------------------------------
$function_name = "selItem_" . $suffix;

if (function_exists($function_name)) {
	$output_item = $function_name($_REQUEST['item_id']);
}


// we validate and save the stylesheet ---------------------------------------------
if (isset($_POST['update']) || isset($_POST['remove'])) {
	// check the element name
	if(!@preg_match('/^[A-Za-z0-9_]{2,}$/', $_POST['element_name'])) {
		// bad name
		$GLOBALS['am_error_log'][] = array('error_element_name', $_POST['element_name']);
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		if ($_POST['element_type'] == "custom") {
			// we check that the name has the prefix
			//if (substr($_POST['element_name'],0,9) == "am_custom") {
			if (substr($_POST['element_name'],0,9) != "am_custom") {
				$_POST['element_name'] = "am_custom_" . $_POST['element_name'];
				$_REQUEST['element_name'] = $_POST['element_name'];
			}
		}
			
	
		// we check if the css element name is in the css (hence we update)
		$output_element = parseElement($output_item['item_css'], $_POST['element_name']);

		$new_css = $output_item['item_css'];
		
		if (!empty($output_element)) {
			// we remove the items from the css
			$new_css = removeElement($output_item['item_css'], $_POST['element_name']);
		}
		
		if (isset($_POST['update'])) {
			// we create the new element
			$new_element = renderElement($_POST);
			
			// we append it to the css
			if (!empty($new_element)) {
				$new_css = $new_css . "\n" . $new_element;
			}
		}
		
		// we save the css
		$function_name = "setStyleSheet_" . $suffix;
		
		if (function_exists($function_name)) {
			$function_name($_REQUEST['item_id'], $new_css);
		}

		$output_item['item_css'] = $new_css;
		
	}
}


if (!empty($output_item)) {
	$body->set('item', $output_item);
}



// include a language file that describes elements
include_once($language_path_core . 'inc/stylesheet_edit.lang.inc.php');


// we parse the stylesheet into an elements array -----------------------------------
if (!empty($output_item['item_css'])) {
	// we assemble an array combining standard elements with custom elements
	

	// we get each allowable element and 
	if (!empty($allowable_styles)) {

		$output_elements = array();
		
		foreach ($allowable_styles as $key => $i):
			$output_elements[$i['name']] = $i;
			$output_elements[$i['name']]['description'] = $lang['element_description'][$key];
			$output_elements[$i['name']]['title'] = $lang['element_title'][$key];
			unset($output_elements[$i['name']]['styles']);
		endforeach;
	}

	
	// add custom elements
	if (!empty($allowable_custom_styles)) {
		// parseCustomElements found in core functions include
		$output_custom_elements = parseCustomElements($output_item['item_css']);
	}
	
	// merge them into a single array
	if (!empty($output_elements) && !empty($output_custom_elements)) {
		$output_elements = array_merge($output_elements, $output_custom_elements);
	}
	elseif (empty($output_elements) && !empty($output_custom_elements)) {
		$output_elements = $output_custom_elements;
	}
	
	if (!empty($output_elements)) {
		$body->set("elements", $output_elements);
	}
}

// if we get a css element name we pull it out --------------------------------------
if (!empty($GLOBALS['am_error_log'])) {
	$style_options['styles'] = $allowable_custom_styles;
	$output_element = $_POST;
	$output_element['type'] = "custom";
	$output_element['title'] = $_POST['element_name'];
	$output_element['name'] = $_POST['element_name'];

	$body->set("edit_name", 1);
}
elseif (isset($_REQUEST['element_name'])) {
	
	$output_element = parseElement($output_item['item_css'], $_REQUEST['element_name']);

	if (!empty($output_element)) {

		// is it a custom element?
		if ($output_element['type'] == "custom") {
			$style_options['styles'] = $allowable_custom_styles;
		}
		else { // it's an html tag or id element
			if (!empty($allowable_styles)) {
				foreach ($allowable_styles as $key => $i):
					if ($output_element['name'] == $i['name']) {
						$style_options = $i;
						$output_element['title'] = $lang['element_title'][$key];
						$output_element['description'] = $lang['element_description'][$key];
						break;
					}
				endforeach;
			}
		}
	}
	else {
		// we check that it is not in our allowable styles array
		if (!empty($allowable_styles)) {
			foreach ($allowable_styles as $key => $i):
				if ($_REQUEST['element_name'] == $i['name']) {
					$style_options = $i;
					$output_element = $i;
					$output_element['title'] = $lang['element_title'][$key];
					$output_element['description'] = $lang['element_description'][$key];
					break;
				}
			endforeach;
		}
	}
}
elseif (!empty($_REQUEST['add_custom_element']) && isset($allowable_custom_styles)) {
	$output_element['title'] = "";
	$output_element['name'] = "";
	$output_element['description'] = "";
	$output_element['type'] = "custom";
	
	$style_options['styles'] = $allowable_custom_styles;
}
	
if (!empty($output_element)) {
	$body->set("element", $output_element);
}

if (isset($style_options )) {
	$body->set("style_options", $style_options);
}

// get the images
require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->core_config_module = $core_config['module'];
$file->item_id = $_REQUEST['item_id'];
$file->module_id = $_REQUEST['module_id'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumbs = $core_config['file']['image']['thumb'];

$images = $file->selFiles("images", "t2");

if (!empty($images)) {
	$body->set("images", $images);
}


// FUNCTIONS -----------------------------------------------------------------------

// renderStyleSheet
// takes a set of form vars and parses them as a single css stylesheet
function renderElement ($properties) {
	
	if (!empty($properties['style'])) {

		$style = "";
		
		foreach ($properties['style'] as $keystyl => $s):

			if ($keystyl == "color" && !empty($s)) {
				if(preg_match('/^#+[A-Za-z0-9]{6}$/', $s)) {
					$style .= "color:" . $s . ";";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_color_incorrect', $s);
				}
			}

			if ($keystyl == "background-color" && !empty($s)) {

				if(preg_match('/^#+[A-Za-z0-9]{6}$/', $s)) {
					$style .= "background-color:" . $s . ";";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_color_incorrect', $s);
				}
			}

			if ($keystyl == "background-image" && !empty($s)) {

				$url = "get_file.php?file=" . $s;
				$style .= "background-image: url(" . $url . ");";
			}

			if ($keystyl == "border-color" && !empty($s)) {
				if(preg_match('/^#+[A-Za-z0-9]{6}$/', $s)) {
					$style .= "border-color:" . $s . ";";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_color_incorrect', $s);
				}
			}

			if ($keystyl == "border-size" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "border:solid " . $s . "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "text-size" && !empty($s)) {
				if(preg_match('/^[0-9]{1,3}$/', $s)) {
					$style .= "font-size:" . $s . "%;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "border-top" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "border-top:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "border-left" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "border-left:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "border-right" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "border-right:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "border-bottom" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "border-bottom:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "border-style" && !empty($s) && $s != "none") {
				$style .= "border-style:" . $s. ";";
			}

			if ($keystyl == "margin-top" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "margin-top:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "margin-left" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "margin-left:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "margin-right" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "margin-right:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "margin-bottom" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "margin-bottom:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "margin-style" && !empty($s) && $s != "none") {
				$style .= "margin-style:" . $s. ";";
			}

			if ($keystyl == "padding-top" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "padding-top:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "padding-left" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "padding-left:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "padding-right" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "padding-right:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "padding-bottom" && !empty($s)) {
				if(preg_match('/^[0-9]{1,2}$/', $s)) {
					$style .= "padding-bottom:" . $s. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $s);
				}
			}

			if ($keystyl == "padding-style" && !empty($s) && $s != "none") {
				$style .= "padding-style:" . $s. ";";
			}

			if ($keystyl == "width" && !empty($s)) {
				if(preg_match('/^[0-9]{2,3}$/', $s)) {
					$style .= "width:" . $s . "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_width_incorrect', $s);
				}
			}

			if ($keystyl == "float" && !empty($s) && $s != "none") {
				$style .= "float:" . $s . ";";
			}

		endforeach;
	}

	if (!empty($style)) {
		$element_type = $properties['element_type'];
	
		if ($element_type == "custom") {
			$element_type = ".";
		}
		
		$element = $element_type . $properties['element_name'] . " {" . $style . "}\n";
	}

	// apply description
	if (!empty($element) && $properties['element_type'] == "custom") {
		// remove any slashes or * from description
		$properties['description'] = strip_tags($properties['description']);
		$properties['description'] = stripslashes($properties['description']);
		$properties['description'] = str_replace("*", "", $properties['description']);
		$properties['description'] = str_replace("/", "", $properties['description']);
		
		$comment = "/* " . $properties['element_name'] . " " . $properties['description'] . "*/";

		$element = $comment . "\n" . $element;
		
	}

	if (!empty($element)) {
		return $element;
	}
}

// removeElement
// returns a single css minus element name and if applicable associated comments
function removeElement ($css, $element_name) {

	$css = trim($css);

	// split the stylesheet into an array of lines
	$elements = preg_split("/[\n]+/", $css);

	if (!empty($elements)) {
		foreach ($elements as $key => $i):
			// remove element
			$pattern = "/" . $element_name . " {/";

			if (preg_match($pattern, $i)) {
				unset ($elements[$key]);
			}

			// remove comment
			$pattern = "/\/\* " . $element_name . "(.*?)\*\//";

			if (preg_match($pattern, $i)) {
				unset ($elements[$key]);
			}
		endforeach;
	}

	$css = "";
	
	if (!empty($elements)) {
		foreach ($elements as $key => $i):
			if (!empty($i)) {
				$css .= $i . "\n";
			}
		endforeach;

		$css = trim($css);
	}

	return $css;
}


// parseElement
// returns a single element name, types and any associated comment
function parseElement ($css, $element_name) {

	$css = trim($css);

	$pattern = "/" . $element_name . " {(.*?)\}/";

	if (preg_match($pattern, $css, $element_string)) {
		
		$element['name'] = $element_name;
		$element['title'] = $element_name;
		
		// get the type
		if (substr($element_string[0],0,9) == "am_custom") {
			$element['type'] = "custom";

			$pattern = "/am_custom_(.*?)\ {/";
			
			if (preg_match($pattern, $element_string[0], $custom_element_name)) {
				$element['title'] = $custom_element_name[1];
			}
		}
		elseif ($element_string[0]{0} == ".") {
			$element['type'] = ".";
		}
		elseif ($element_string[0]{0} == "#") {
			$element['type'] = "#";
		}
		else {
			$element['type'] = "";
		}
		
		
		// we explode the styles for this element
		if (!empty($element_string[1])) {
			
			$styles = explode (";", $element_string[1]);
			
			foreach ($styles as $keystyl => $styl):
				$style = explode (":", $styl);

				// check the style is allowable
				if (!empty($style[1])) {

					$style_name = trim ($style[0]);
					$style_value = trim ($style[1]);

					if ($style_name == "background-image") {

						$pattern = '/file=(.*?)-(.*?)\)/'; // retrieves only md5

						if(preg_match($pattern, $style_value, $temp)) {

							$style_value = $temp[2];
						}
					}

					// remove any "px" information from end of value
					$pattern = '/(.*?)px/';

					if(preg_match($pattern, $style_value, $temp)) {

						$style_value = $temp[1];
					}

					
					$element['styles'][$style_name] = $style_value;
						
				}
			endforeach;
		}

		// we look for a comment to match the name
		if (!empty($element['name'])) {

			$pattern = "/\/\* " . $element['name'] . "(.*?)\*\//";
			//   /* body the body tag*/
			if (preg_match($pattern, $css, $element_comment)) {
				$element['description'] = trim($element_comment[1]);
			}
		}
		
		return $element;
	}
}
?>