<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



// MODULE HEADER INCLUSION -----------------------------------------------
// We include any header files for the modules
if (empty($suffix)) {
	$suffix = "core";
}

if (is_file("components/" . $suffix . "/inc/" . $suffix . "_participation.header.php")) {
	include_once("components/" . $suffix . "/inc/" . $suffix . "_participation.header.php");
}


if (isset($_SESSION['md5'])) {
	
	if (isset($_POST['accept_invite'])) { 
		$query = "
			SELECT user_id, identity_id, role_id, status_id, 
			participation_permission 
			FROM " . $db->prefix . "_participation 
			WHERE 
			item_id=" . $output_item['item_id'] . " AND
			module_id=" . $module_id . " AND
			user_id=" . $_SESSION['user_id']
		;
			
		$result = $db->Execute($query);
				
		if (isset($result->fields)) {
			$rec = array();
			$rec['identity_id'] = $_POST['identity_id'];
			$rec['status_id'] = $core_config['participation']['status']['active'];
			
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			header("Location: " . $item_url . "&" . strip_tags(SID));
			exit;
		}
	
	}
	elseif (isset($_POST['my_participation_insert'])) { // we are joining
		if (empty($_POST['identity_id'])) {
			$GLOBALS['am_error_log'][] = array('identity_empty');
		}
	
		if (empty($GLOBALS['am_error_log'])) {
			$participation->item_id = $_POST['item_id'];
			
			if ($output_item['item_type'] == $item_config['type']['approved']) {
				$_POST['status_id'] = $core_config['participation']['status']['pending'];
			}
			else {
				$_POST['status_id'] = $core_config['participation']['status']['active'];
			}
			
			$_POST['participation_permission'] = $output_item['default_user_permission'];
			
			$participation->user_id = $_SESSION['user_id'];
			
			$participation->insertParticipant($_POST);
			
			header("Location: " . $item_url . "&" . strip_tags(SID));
			exit;
		}
	}
	elseif (isset($_POST['my_participation_activate'])) {
		$participation->setUserStatus($output_participation['identity_id'], $core_config['participation']['status']['active']);
		
		header("Location: " . $item_url . "&" . strip_tags(SID));
		exit;
	
	}
	elseif (isset($_POST['my_participation_withdraw'])) {
		$participation->setUserStatus($output_participation['identity_id'], $core_config['participation']['status']['withdrawn']);
		
		header("Location: " . $item_url . "&" . strip_tags(SID));
		exit;
	
	}
	elseif (isset($_POST['remove_relations'])) {
		$participation->deleteRelations($_POST['identity_ids'], $output_participation['identity_id']);
	}
	
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
	
	
	// INVITATION
	if (isset($output_participation) && $output_participation['status_id'] == $core_config['participation']['status']['invite']) {
		
		if ($output_item['item_type'] == $item_config['type']['invitation'] && empty($output_participation['invitee_user_id'])) {
			header("Location: " . $item_url . "&" . strip_tags(SID));
			exit;
		}
		
		unset ($body->vars['participation']);
		
		$body->set('invite', 1);
	
		// get user identities for join dropdown
	
		$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
		$body->set('identities', $output_identities);
		
		if (!empty($output_participation['invitee_user_id'])) {
			$output_invitee = $user->selUserIdentity($output_participation['invitee_user_id']);
			$body->set('invitee_identity', $output_invitee);
		}
	
	}
	elseif (isset($output_participation)) { 
		// SELECT PARTICIPANTS --------------------------------------------------------
		$output_participants = $participation->selParticipants($core_config['participation']['status']['active']);
		
		// SELECT PARTICIPANTS IDENTITIES ---------------------------------------------
		if (!empty($output_participants)) {
			// get their ids
			if (!empty($output_participants)) {
				foreach ($output_participants as $key => $i):
					$user->identity_ids[] = $i['identity_id'];
				endforeach;
				
				$user->identity_ids = array_unique($user->identity_ids);
				
				if (!empty($user->identity_ids)) {
					$output_identities = $user->selUserIdentities();
					
					// we place the identities against the participants
					if (!empty($output_identities)) {
						foreach ($output_participants as $keyp => $p):
							foreach ($output_identities as $keyi => $i):
								if ($p['identity_id'] == $i['identity_id']) {
									$output_participants[$keyp]['identity'] = $i;
									break;
								}
							endforeach;
						endforeach;
					}

					unset($output_identities);
					
					$body->set('participants', $output_participants);
				}
			}
		}
	}
	else {
		// we display join screen
		$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
		$body->set('identities', $output_identities);
	}
}
else {
	header('location: index.php');
	exit;
}
?>
