<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


// FILE -----------------------------------
require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);

if (isset($core_config['module'])) {
	$file->core_config_module = $core_config['module'];
}

$file->module_id = 0; // core

$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
$user->file = $file;


// GET RELATION IDENTITIY ----------------------------------------------
$output_identity_relation = $user->selUserIdentity(null, $_REQUEST['identity_id_relation'], 1);

if (empty($output_identity_relation)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


// GET IDENTITIY ----------------------------------------------
$output_identity = $user->selUserIdentity(null, $_REQUEST['identity_id'], 1);

if (empty($output_identity)) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}


require_once ("components/core/class/Tie.class.php");
$tie = new Tie($db, $core_config);
	

require_once('components/core/class/Participation.class.php');
$participation = new Participation($db, $core_config);
$participation->limit = 6;
$participation->order_by = "r.relation_create_datetime desc";

$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];

if (!empty($output_identity_relation)) {
	$user->file = $file;
	// get their relations
	$participation->not_user_id = $_SESSION['user_id'];
	$output_identity_relation['ties'] = $participation->selRelations($output_identity_relation['identity_id']);


	if (!empty($output_identity_relation['ties'])) {
		// get their identities
		foreach ($output_identity_relation['ties'] as $key => $i):
			$user->identity_ids[] = $i['identity_id_relation'];
			
			// is the relationship mutual?
			$tie->module_id = $i['module_id'];
			$tie->item_id = $i['item_id'];
			
			$output_identity_relation['ties'][$key]['common_ties'] = $tie->selCommonTies($i['identity_id_relation'], $i['identity_id']);
			
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			// we place the identities against the ties
			if (!empty($output_identities)) {
				foreach ($output_identity_relation['ties'] as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						if ($p['identity_id_relation'] == $i['identity_id']) {
							$output_identity_relation['ties'][$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
		}
	}
	
	// were they invited by anyone
	if (!empty($output_identity_relation['invitee'])) {
		$output_identity_relation['invitee']['common_ties'] = $tie->selCommonTies($output_identity_relation['identity_id'], $output_identity_relation['invitee']['identity_id']);
		$output_identity_relation['invitee']['common_ties']['identity_id'] = $output_identity_relation['identity_id'];
		$output_identity_relation['invitee']['common_ties']['identity_id_relation'] = $output_identity_relation['invitee']['identity_id'];
	}
}



if (!empty($output_identity)) {
	$user->file = $file;
	// get their relations
	$participation->not_user_id = $_SESSION['user_id'];
	$output_identity['ties'] = $participation->selRelations($output_identity['identity_id']);


	if (!empty($output_identity['ties'])) {
		// get their identities
		foreach ($output_identity['ties'] as $key => $i):
			$user->identity_ids[] = $i['identity_id_relation'];
			
			// is the relationship mutual?
			$tie->module_id = $i['module_id'];
			$tie->item_id = $i['item_id'];
			
			$output_identity['ties'][$key]['common_ties'] = $tie->selCommonTies($i['identity_id_relation'], $i['identity_id']);
			
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			// we place the identities against the ties
			if (!empty($output_identities)) {
				foreach ($output_identity['ties'] as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						if ($p['identity_id_relation'] == $i['identity_id']) {
							$output_identity['ties'][$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
		}
	}
	
	// were they invited by anyone
	if (!empty($output_identity['invitee'])) {
		$output_identity['invitee']['common_ties'] = $tie->selCommonTies($output_identity['identity_id'], $output_identity['invitee']['identity_id']);
		$output_identity['invitee']['common_ties']['identity_id'] = $output_identity['identity_id'];
		$output_identity['invitee']['common_ties']['identity_id_relation'] = $output_identity['invitee']['identity_id'];
	}
}






// Setup Tie -------------------------------------------------------------
require_once ("class/Tie.class.php");
$tie = new Tie($db, $core_config);

	
$tie->count_weak = true;
$tie->count_strong = true;
$output_ties['strong'] = $tie->selStrongTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 'outbound', 3);
$output_ties['strong_weak'] = $tie->selStrongToWeakTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 3);
$output_ties['weak_strong'] = $tie->selWeakToStrongTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 3);

if (empty($output_ties['strong_weak']) && empty($output_ties['weak_strong'])) {
	$output_ties['weak_outbound'] = $tie->selWeakTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 'outbound', 3);
	$output_ties['weak_inbound'] = $tie->selWeakTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 'inbound', 3);
}

$output_ties_common = $tie->selCommonTies($_REQUEST['identity_id'], $_REQUEST['identity_id_relation']);

foreach($output_ties as $key => $i) {
	foreach($i as $rekey => $j) {
		$output_ties[$key][$rekey]['from_identity'] = $user->selUserIdentity(null, $j['from']);
		$output_ties[$key][$rekey]['to_identity'] = $user->selUserIdentity(null, $j['to']);
	}
}


if (!empty($output_ties)) {
	$body->set('ties', $output_ties);
}

if (!empty($output_ties_common)) {
	// we include all module files which have a function to obtain a single item
	// module_id 1 will include a function called -selItemModule1
	if (!empty($core_config['module'])) {
		foreach($core_config['module'] as $key => $i):
			$suffix = $core_config['module'][$key]['prefix'];
			
		    if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
		    	include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
		    }
		endforeach;
	}
	
	$t['strong'] = array();
	$t['weak'] = array();
	$t['count_weak'] = $output_ties_common['count_weak'];
	$t['count_strong'] = $output_ties_common['count_strong'];
	$t['from_identity'] = $user->selUserIdentity(null, $_REQUEST['identity_id']);
	$t['to_identity'] = $user->selUserIdentity(null, $_REQUEST['identity_id_relation']);
	
	if (isset($core_config['module'])) {
		foreach($output_ties_common['strong'] as $s) {
			$suffix = $core_config['module'][$s['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
			
			if (function_exists($function_name)) {
				array_push($t['strong'], $function_name($s['item_id']));
			}
		}
		
		foreach($output_ties_common['weak'] as $s) {
			$suffix = $core_config['module'][$s['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
			
			if (function_exists($function_name)) {
				array_push($t['weak'], $function_name($s['item_id']));
			}
		}
		
		foreach($output_identity['ties'] as $key => $s) {
			$suffix = $core_config['module'][$s['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
			if (function_exists($function_name)) {
				$output_identity['ties'][$key]['item'] = $function_name($s['item_id']);
			}
		}
		
		foreach($output_identity_relation['ties'] as $key => $s) {
			$suffix = $core_config['module'][$s['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
			if (function_exists($function_name)) {
				$output_identity_relation['ties'][$key]['item'] = $function_name($s['item_id']);
			}
		}
	}
	
	$body->set('ties_common', $t);
	$body->set('identity', $output_identity);
	$body->set('identity_relation', $output_identity_relation);
}



?>