<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

// Setup Tie -------------------------------------------------------------
require_once ("class/Tie.class.php");
$tie = new Tie($db, $core_config);
$tie->count_weak = true;
$tie->count_strong = true;
$output_ties['strong'] = $tie->selStrongTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 'outbound', 3);
$output_ties['strong_weak'] = $tie->selStrongToWeakTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 3);
$output_ties['weak_strong'] = $tie->selWeakToStrongTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 3);
$output_ties['weak_outbound'] = $tie->selWeakTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 'outbound', 3);
$output_ties['weak_inbound'] = $tie->selWeakTiePaths($_REQUEST['identity_id'], $_REQUEST['identity_id_relation'], 'inbound', 3);

$output_ties_common = $tie->selCommonTies($_REQUEST['identity_id'], $_REQUEST['identity_id_relation']);

foreach($output_ties as $key => $i) {
	foreach($i as $rekey => $j) {
		$output_ties[$key][$rekey]['from_identity'] = $user->selUserIdentity(null, $j['from']);
		$output_ties[$key][$rekey]['to_identity'] = $user->selUserIdentity(null, $j['to']);
	}
}


if (!empty($output_ties)) {
	$body->set('ties', $output_ties);
}

if (!empty($output_ties_common)) {

	$t['strong'] = array();
	$t['weak'] = array();
	$t['count_weak'] = $output_ties_common['count_weak'];
	$t['count_strong'] = $output_ties_common['count_strong'];
	$t['from_identity'] = $user->selUserIdentity(null, $_REQUEST['identity_id']);
	$t['to_identity'] = $user->selUserIdentity(null, $_REQUEST['identity_id_relation']);

	
	foreach($output_ties_common['strong'] as $s) { 
		array_push($t['strong'], $tie->selItem($s['module_id'], $s['item_id']));
	}
	
	foreach($output_ties_common['weak'] as $s) {
		array_push($t['weak'], $tie->selItem($s['module_id'], $s['item_id']));
	}

	$body->set('ties_common', $t);
}


// 
// we select all my ties and allow my to manage who is portable and who is not

?>