<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "structure";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['administration'], $c_acs['arr_acs']['privilege']['allow_membership'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');


//setup useradmin (extends user)
require_once('class/User.class.php');
require_once('class/UserAdmin.class.php');
$user = new UserAdmin($db, $date);
$user->language_dir = $c_node['node']['template_default_name'];


//form actions
if (isset($_POST['register'])) {
	
	//prepare data
	$frmdata['to'] = trim($frmdata['to']);
	
	if (empty($frmdata['to'])) {
		$GLOBALS['am_error_log'][] = array(2, null, null);
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$emails = preg_split("/[\s,]+/", $frmdata['to']);
		
		//check each email
		foreach($emails as $key => $i):
			// Check the email
			if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $i)) {
				$GLOBALS['am_error_log'][] = array(3, 1, $i);
			}
			
			if (empty($GLOBALS['am_error_log'])) {
				$query = "
					SELECT user_id FROM " . $db->prefix . "_user
					WHERE 
					user_email=" . $db->qstr($i, get_magic_quotes_gpc())
				;
				
				$result = $db->Execute($query);
				
				if(!empty($result->fields['user_id'])) {
					$GLOBALS['am_error_log'][] = array(4, 1, $i);
				}
			}
		endforeach;
	}

	if (empty($GLOBALS['am_error_log']) && !empty($emails)) {

		//setup email
		require_once('class//Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->Host = 		$c_node['mail']['host'];
		$mail->Port = 		$c_node['mail']['port'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		
		if (isset($c_node['mail']['smtp']['username'])) {
			$mail->SMTPAuth = true;
			$mail->Username = $c_node['mail']['smtp']['username'];
			$mail->Password = $c_node['mail']['smtp']['password'];
		}
		
		$mail->From = 		$c_node['mail']['default_address'];
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$frmdata['subject'];
		$mail->IsHTML(true);
		$mail->AddReplyTo($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
		$user->mail = $mail;
		
		$user->txt_message = $frmdata['message'];
		$user->user_image_allocation = $c_node['file']['default_max_user_space'];
		$user->template_id = $c_node['node']['template_default_id'];
		$user->txt_default_profile_name = $lang['txt_default_profile_name'];
		$user->txt_default_profile_hometown = $lang['txt_default_profile_hometown'];
		$user->status_id = $c_node['user']['status']['pending'];
		$user->template_id = $c_node['node']['template_default_id'];
		$user->page_default = $c_node['node']['page_default'];
		$user->role_default = $c_acs['arr_acs']['user_join_role_default'];
		
		$total_registerted_users = 0;
		
		foreach($emails as $key => $i):
			$data['user_email'] = $i;
			// get first name
			$pos = strpos($i, '@');
			$guessed_email_name = substr($i, 0, $pos);
			
			//names are often formatted as firstname.surname
			$pos1 = strpos($guessed_email_name, '.');
			
			if (is_numeric ($pos1) && $pos1>0) {
				$guessed_email_name = substr($guessed_email_name, 0, $pos1);
			}
			
			$data['user_firstname'] = $guessed_email_name;
			// we assume (nasty I know)
			$data['language_id'] = $me['language_id'];
			
			if (isset($frmdata['language_ids'])) {
				$data['language_ids'] = $_POST['language_ids'];
			}
			
			$user->registerUser($data);
			$total_registerted_users++;
			unset($frmdata['to']);
			
		endforeach;
	}

}
	
	
//TEMPLATE
if (isset($c_node['node']['language_available'])) {
    $body->set('language_available', $c_node['node']['language_available']);
}

$body->set('language_default', $c_node['node']['language']['default']);

if (isset($display)) {
    $body->set('display', $display);
}

if (isset($total_registerted_users)) {
    $body->set('total_registerted_users', $total_registerted_users);
}

if (empty($frmdata)) {
	$frmdata = array("language_id" => $me['language_id']);
	$frmdata['subject'] = $lang['txt_invite_message_txt'];
	$frmdata['message'] = $lang['txt_invite'];
}

include "inc/footer.inc.php";
?>
