<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//ACS check
if (isset($_REQUEST['group_id'])) {
	$group_id = $_REQUEST['group_id'];
	include_once ('inc/header_group.inc.php');
	
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: grp_view.php?group_id=" . $_REQUEST['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	
	require_once($languagePath . 'grp_common.lang.php');
}
elseif (!isset($rss_access_granted) && (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['schedule'], $c_acs['arr_acs']['privilege']['allow_access']))) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP SCHEDULE ------------------------------------------------------------
require_once('class/Schedule.class.php');
$schedule = new Schedule($db, null, $date, $file);
$schedule->schedule_config = $c_node['schedule'];
$schedule->rsp_level_id = $rsp_level_id;


// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_schedule.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
	
	
// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['schedule'], $date);

if (isset($me['user_id'])) {
	$comment->user_id = $me['user_id'];
}

$comment->wiki = $wiki;


// SETUP TAGS ------------------------------------------------------------
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['schedule']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}


// SETUP BOOKMARKS -------------------------------------------------------
if (isset($me['user_id'])) {
	require_once('class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['schedule'], $me['user_id']);
}


// SETUP FILTER ----------------------------------------------------------
if(!empty($frmdata['start_date'])) { // default is today
	$schedule->start_date = $date->formatFormDateTime($frmdata['start_date']);
}
else {
	$frmdata['start_date'] = date("Y-m-d"); //now
}


if(!empty($frmdata['schedule_show'])) { //default is 5
	$schedule->no_of_days_shown = $frmdata['schedule_show'];
}

$schedule->status_ids = array($c_node['schedule']['status']['confirmed']);

if(!empty($frmdata['schedule_status'])) {
	array_push($schedule->status_ids, $c_node['schedule']['status']['tentative']);
}
	

// PROCESS FORM ----------------------------------------------------------
if (isset($_REQUEST['view']) && $_REQUEST['view'] == "node") {
	unset($_REQUEST['view']);
}

if (isset($_POST['update_tag'])) {
	$frmdata['item_id'] = $frmdata['schedule_id'];
	$tag->deleteItemTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: sch_view.php?schedule_id=". $frmdata['schedule_id'] . "&" . strip_tags(SID));
	exit;
}	
elseif (isset($_POST['preview'])) {
	unset($schedule->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
	
	$schedule->schedule_id = $_REQUEST['schedule_id'];
	
	$output_schedule_item = $schedule->selScheduleItem();
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $frmdata['schedule_id'];
	$comment->item_user_id = $frmdata['item_user_id'];
	$comment->insertComment($frmdata);

	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db);
		
		if (isset($frmdata['group_id'])) {
			$comment->group_id = $frmdata['group_id'];
		}
		
		//update user stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());
		
		if (isset($frmdata['group_id'])) {
			$statistic->group_id = $frmdata['group_id'];
			
			//update group stats
			unset($comment->user_id, $statistic->user_id, $comment->rsp_item_type_id, $comment->item_id);
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
			$statistic->setStatistic($comment->getCommentCount());
			
			//group member comments
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_comments'];
			$statistic->user_id = $me['user_id'];
			$comment->user_id = $me['user_id'];
			$statistic->setStatistic($comment->getCommentCount());
		}
		
		// update bookmarks to trigger notification
		if (isset($me['user_id'])) {
			$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
			$bookmark->updateBookmarkNotification($frmdata['schedule_id'], 1);
		}

		return header("Location: sch_view.php?schedule_id=". $frmdata['schedule_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
	$schedule->schedule_id = $_REQUEST['schedule_id'];
	
	$output_schedule_item = $schedule->selScheduleItem();
}
elseif (isset($_REQUEST['withdraw_confirmation'])) {
	$schedule->updateScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['withdrawn']);
	header("Location: sch_view.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['schedule_apply_update'])) {
	$schedule->updateScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['pending']);
	header("Location: sch_view.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['schedule_apply'])) {
	$schedule->insertScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['pending']);
	header("Location: sch_view.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['bookmark']) && isset($me['user_id'])) { // bookmark options for this item
	$bookmark->item_id = $_REQUEST['schedule_id'];
	
	if ($_REQUEST['bookmark'] == "ins_mark") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		
		if (!empty($_REQUEST['notify'])) {
			$bookmark->insertBookmark(1);
		}
		else {
			$bookmark->insertBookmark();
		}
	}
	elseif ($_REQUEST['bookmark'] == "del_mark") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->deleteBookmark();
	}
	elseif ($_REQUEST['bookmark'] == "ins_tip") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
	}
	elseif ($_REQUEST['bookmark'] == "del_tip") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->deleteBookmark();
	}
	
	header("Location: sch_view.php?schedule_id=". $_REQUEST['schedule_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['view'])) {
	if ($_REQUEST['view'] == "my_groups" && isset($me['user_id'])) {
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		require_once('class/Group.class.php');
		$group = new Group($db, $file);
		$group->registration_types = $c_node['group']['registration_type'];
		$group->user_id = $me['user_id'];
		
		$mygroups = $group->getMyGroups();
		
		if (!empty($mygroups)) {
			foreach ($mygroups as $key => $i):
				$schedule->group_ids[] = $i['group_id'];
			endforeach;
		}
		else {
			$schedule->group_ids[] = 0;
		}
		
		$schedule->limit = $c_node['display']['max_list_rows'];
		$group_schedule_items = $schedule->selScheduleItems();
		
		//sort schedule_items into groups
		if (!empty($mygroups)) {
			foreach ($mygroups as $item_key => $i):
				foreach($group_schedule_items as $content_key => $c):
					if ($i['group_id'] == $c['group_id']) {
						$mygroups[$item_key]['schedule_items'][] = $c;
						unset ($group_schedule_items[$content_key]);
					}
				endforeach;
			endforeach;
		}
		
		$lang['txt_intro_group'] = str_replace('MAXLISTNUMBER', $c_node['display']['max_list_rows'], $lang['txt_intro_group']);
		$lang['txt_outro_group'] = str_replace('MAXLISTNUMBER', $c_node['display']['max_list_rows'], $lang['txt_outro_group']);
		
		$output_my_group_schedule_items = $mygroups;
		
	}
	elseif ($_REQUEST['view'] == "my_network" && isset($me['user_id'])) {
		//get the latest relations schedule_items
		unset($schedule->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		$my_network = $_SESSION['relations'];
		
		if (!empty($my_network)) {
			foreach($my_network as $key => $i):
				$schedule->user_ids[] = $i['user_id_relation'];
				$user->user_ids[] = $i['user_id_relation'];
			endforeach;
		}
		else {
			$schedule->user_ids[] = 0;
			$user->user_ids[] = 0;
		}
		
		$user->file = $file;
		$output_users = $user->selUsers();
		
		$schedule->limit = $c_node['display']['max_list_rows'];
		$network_schedule_items = $schedule->selScheduleItems();
		
		//sort schedule_items under people
		if (!empty($output_users)) {
			foreach ($output_users as $item_key => $i):
				foreach($network_schedule_items as $content_key => $c):
					if ($i['user_id'] == $c['user_id']) {
						$output_users[$item_key]['schedule_items'][] = $c;
						unset ($network_schedule_items[$content_key]);
					}
				endforeach;
			endforeach;
		}
		
		$output_my_network_schedule_items = $output_users;
		
		$lang['txt_intro_network'] = str_replace('MAXLISTNUMBER', $c_node['display']['max_list_rows'], $lang['txt_intro_network']);
		$lang['txt_outro_network'] = str_replace('MAXLISTNUMBER', $c_node['display']['max_list_rows'], $lang['txt_outro_network']);
		
		$menu_section = "network";
	}
	elseif ($_REQUEST['view'] == "my_schedule" && isset($me['user_id'])) {
		//get my schedule_items
		unset($schedule->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		// get schedule items that i've created
		unset($schedule->start_date);
		$schedule->user_id = $me['user_id'];
		
		$output_schedule_items = $schedule->selScheduleItems();
		
		$menu_section = "my";
	}
	elseif ($_REQUEST['view'] == "allocation" && isset($me['user_id'])) {
		// get schedule items I am allocated to
		unset($schedule->start_date);
		$output_schedule_items = $schedule->selScheduleItems(null, 1);
	}
	elseif ($_REQUEST['view'] == "marked_schedule_items" && isset($me['user_id'])) {
		//get my marked schedule_items
		unset($schedule->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		$watched_schedule_ids = $bookmark->getBookmarks();
		
		$schedule->user_id = $me['user_id'];
		
		if (!empty($watched_schedule_ids)) {
			$schedule->schedule_ids = $watched_schedule_ids;
			$output_schedule_items = $schedule->selScheduleItems();
		}
	}
}
elseif (isset($_REQUEST['user_id'])) {
	//get schedule_items for this user (if relation)
	unset($schedule->rsp_level_id);
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$schedule->file = $file;
	
	$schedule->user_id = $_REQUEST['user_id'];
	
	$output_schedule_items = $schedule->selScheduleItems();
	
	// get the user
	$output_profile = $user->selProfile(null, $_REQUEST['user_id']);
	
	
	$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	//setup file
	if (isset($output_profile['file_id'])) {
		$file->file_id = $output_profile['file_id'];
		$output_profile['image'] = $file->getFileRecord();
	}
	if (isset($output_profile) && empty($output_profile['image'])) {
		$output_profile['image']['file_title'] = "";
		$output_profile['image']['file'] = $file->noimage;
	}
}
elseif (isset($_REQUEST['schedule_id'])) {
	unset($schedule->rsp_level_id);
	$schedule->schedule_id = $_REQUEST['schedule_id'];
	
	$output_schedule_item = $schedule->selScheduleItem();
}
elseif (isset($_REQUEST['group_id'])) {
	$schedule->group_id = $_REQUEST['group_id'];
	
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$schedule->file = $file;
	
	unset($menu_section);
	
	$output_schedule_items = $schedule->selScheduleItems();
	
}
else { // get the latest item published to node
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$schedule->file = $file;
	
	$schedule->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
	$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
	
	$output_schedule_items = $schedule->selScheduleItems();
	
	$lang['txt_intro_node'] = str_replace('MAXLISTNUMBER', $c_node['display']['max_list_rows'], $lang['txt_intro_node']);
	
	$menu_section = "magazine";
	
	$_REQUEST['view'] = "node";
}


// CHECK PERMISSION TO VIEW SCHEDULE ----------------------------------------
if (!empty($output_schedule_item)) {
	// Are we allowed to see this schedule?
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	require_once('class/Rsp.class.php');
	$rsp = new Rsp($db, $c_node['rsp']['item_type']['schedule']);
	$output_schedule_item['rsp'] = $rsp->selRspItem($schedule->schedule_id);
	
	
	if (isset($me['user_id']) && $me['user_id'] == $output_schedule_item['user_id']) {
		// is the author me?
		$allow_view = 1;
	}
	elseif (isset($rss_access_granted)) { // RSS Feed link
		$allow_view = 1;
	}
	elseif (!empty($output_schedule_item['rsp'])) { // is the item set to public?
		foreach ($output_schedule_item['rsp'] as $key => $i):
			if ($i['level_id'] == $c_node['rsp']['rsp_level']['public']) {
				$allow_view = 1;
				break;
			}
			elseif (!empty($_SESSION['s_md5']) && empty($i['degree_id']) && $i['level_id'] == $c_node['rsp']['rsp_level']['node']) { // is the item set to node and the user logged in?
				$allow_view = 1;
				break;
			}
			elseif (!empty($i['degree_id'])) { // is it set to network and are they in my network?
				foreach($_SESSION['relations'] as $key => $r):
					if ($output_blog['user_id'] == $r['user_id_relation']) {
						$allow_view = 1;
						break;
					}
					
					if (isset($allow_view)) {
						break;
					}
				endforeach;
			}
		endforeach;
	}
	
	if (!empty($output_schedule_item['group_id'])) {
		require_once('class/Group.class.php');
		require_once($languagePath . 'grp_common.lang.php');
		require_once($languageArrayPath . 'arr_group.lang.php');
		$group = new Group($db, null);
		$group->registration_types = $c_node['group']['registration_type'];
		$group->group_id = $output_schedule_item['group_id'];
		$output_group = $group->getGroup();
		
		//setup acs
		$group_acs = new Acs(null, $db, $c_node['arr_acs']['role_type']['group']);
		$group_acs->group_id = $output_schedule_item['group_id'];
		
		// if access not allowed so far, check that I have view permissions within group
		if (isset($me['user_id'])) {
			$group->user_id = $me['user_id'];
			$output_group['member'] = $group->getGroupMembership();
		}
		
		if (empty($output_group['member']['role_id'])) {
			// treat as a visitor to the group
			$output_group['member'] = $group_acs->getGroupRole(null, 1);
		}
		
		$group_acs->role_id = $output_group['member']['role_id'];
		
		
		if (!isset($allow_view) && $group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
			$allow_view = 1;
		}
		
		$schedule->group_id = $output_schedule_item['group_id'];
		
		unset($menu_section);
		
	}
	
	
	if (!isset($allow_view)) {
		unset($output_schedule_item);
	}
}

// FORMAT SCHEDULE ITEM -------------------------------------------------------
if (isset($output_schedule_item['schedule_id'])) {
	//wikify body
	$wiki_path = "lib_view.php?page=";
	$wiki_new_path = "lib_edit.php?page=";
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . $wiki_image_base);
	$output_schedule_item['schedule_body'] = $wiki->transform($output_schedule_item['schedule_body'], 'Xhtml');
	
	
	// GET AUTHOR
	if (!empty($output_schedule_item['group_id'])) {
		$output_group['author'] = $group->getGroupMembership($output_schedule_item['user_id']);
		
		if (!empty($output_group['author']['profile_id'])) {
			$output_author = $user->selProfile($output_group['author']['profile_id'], null);
		}
	}
	else {
		$output_author = $user->selProfile(null, $output_schedule_item['user_id']);
	}
	
	// GET BOOKMARK --------------------------------------------------
	if (isset($bookmark)) {
		$bookmark->item_id = $schedule->schedule_id;
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_schedule_item['bookmark']['watch'] = 1;
		}
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_schedule_item['bookmark']['recommend'] = 1;
		}
	}
	
	if ($output_schedule_item['schedule_p_complete']<1) {
		$output_schedule_item['schedule_p_complete'] = "0";
	}
	
	//get comments
	unset($comment->user_id);
	if (!empty($output_blog['group_id'])) {
		$comment->group_id = $output_blog['group_id'];
	}
	$output_comments = $comment->selComments($schedule->schedule_id);
	
	
	//get schedule item image
	if (isset($output_schedule_item['file_id'])) {
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		$file->file_id = $output_schedule_item['file_id'];
		$output_schedule_item['image'] = $file->getFileRecord();
	}
	
	
	//get tags
	$tag->item_id = $schedule->schedule_id;
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_item_tags = $tag->selTags(1);
}



if (!isset($output_schedule_item)) {
	//get the total future items --------------------------------------------
	unset($schedule->user_id);
	$schedule->schedule_type_id = $c_node['schedule']['type']['event'];
	$total_schedule_items = $schedule->countScheduleItems();
	$lang['txt_event_summary'] = str_replace('SCHEDTOTAL', $total_schedule_items, $lang['txt_event_summary']);
	$schedule->schedule_type_id = $c_node['schedule']['type']['task'];
	$total_schedule_items = $schedule->countScheduleItems();
	$lang['txt_task_summary'] = str_replace('SCHEDTOTAL', $total_schedule_items, $lang['txt_task_summary']);
}
else {
	unset($lang['txt_event_summary'], $lang['txt_task_summary']);
}


// SETUP TEMPLATE ---------------------------------------------------------
if (!empty($_REQUEST['tag'])) {
	$body->set('tag', $_REQUEST['tag']);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($_REQUEST['view'])) {
	$body->set('view', $_REQUEST['view']);
}

if (!empty($output_schedule_items)) {
   $body->set('schedule_items', $output_schedule_items);
}

if (!empty($output_schedule_item)) {
	$body->set('schedule', $output_schedule_item);
	$body->set('rsp_config', $c_node['rsp']); 
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
}

$body->set('schedule_config', $c_node['schedule']);
$body->set('languagePath', $languagePath); //for calendar lang config
$body->set('batch_enabled', $c_node['batch']['enabled']);
$body->set('rspconfig', $c_node['rsp']);

$template_pageLink = $lang['txt_schedule'];

include "inc/footer.inc.php";

?>
