<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<div class="col_main">
	<?php
	if (isset($poll)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_poll'];?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<div class="metadata_top">
					<b><?php echo $lang['txt_item_options'];?></b> -&#62; 
					<?php
					if (isset($me['user_id']) && $me['user_id'] > 0) { // we need to be logged in
					?>
					
					<?php
					if ($me['user_id'] == $poll['user_id']) {
					?>
					<a href="pol_edit.php?poll_id=<?php echo $poll['poll_id'];?>"><?php echo $lang['href_edit'];?></a>
					,&nbsp;
					<?php }?>
					
					<?php
					if (isset($poll['bookmark']['watch'])) {
					?>
					<a href="pol_view.php?poll_id=<?php echo $poll['poll_id'];?>&amp;bookmark=del_mark"><?php echo $lang['href_unwatch_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="pol_view.php?poll_id=<?php echo $poll['poll_id'];?>&amp;bookmark=ins_mark"><?php echo $lang['href_watch_this'];?></a>
					<?php }?>
					,&nbsp;
					
					<?php
					if (isset($poll['bookmark']['recommend'])) {
					?>
					<a href="pol_view.php?poll_id=<?php echo $poll['poll_id'];?>&amp;bookmark=del_tip"><?php echo $lang['href_unrecommend_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="pol_view.php?poll_id=<?php echo $poll['poll_id'];?>&amp;bookmark=ins_tip"><?php echo $lang['href_recommend_this'];?></a>
					<?php }?>
					
					<?php
					if (!isset($poll['bookmark']['watch']) && $batch_enabled == true) {
					?>
					,&nbsp;
					<a href="pol_view.php?poll_id=<?php echo $poll['poll_id'];?>&amp;bookmark=ins_mark&amp;notify=1"><?php echo $lang['href_watch_this_notify'];?></a>
					<?php }?>
					<?php }?>
					<br />
				</div>
				
				<table border="0" cellspacing="2" cellpadding="0" width="100%">
					<tr>
						<td valign="top">
							<?php
							include $templatePath . "poll_detail.inc.tpl.php";
							?>
						</td>
					</tr>
					<?php
					if (isset($poll_history)) {
					?>
					<tr>
						<td class="vote_results_box" valign="top">
							<b><?php echo $lang['hdr_my_vote_history'];?></b><br />
							<?php
							$separator = ", ";
							foreach($poll_history as $key => $r):
								if ($key == (count($poll_history)-1)) {
									$separator=".";
								}
								
								echo $r['option_body'] . " (" . $this->date->formatDate($r['answer_create_datetime'], 1) . ")" . $separator;
							endforeach;
							?>
						</td>
					</tr>
					<?php }?>
				</table>
				
				<div class="metadata">
					<?php
					if (isset($author)) {
						if (isset($group)) {
							$profile_url = "grp_membership.php?group_id=" . $group['group_id'] . "&amp;user_id=" . $author['user_id'];
						}
						else {
							$profile_url = "sn_profile.php?user_id=" . $author['user_id'];
						}
					?>
						<p>
							<b><?php echo $lang['txt_author'];?></b> -&#62; 
							<?php echo $lang['txt_profile_nic'];?>: 
							<a href="<?php echo $profile_url;?>"><?php echo $author['profile_nic'];?></a>, 
							<?php echo $lang['txt_profile_session_status'];?>: 
							<?php
							if ($author['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
							}
							else {
									echo $lang['arr_user_online_status'][$author['online_status']];
							}
							?>, 
							<?php echo $lang['txt_hometown'];?>: 
							<?php echo $author['profile_hometown'];?>, 
							<?php echo $lang['txt_joined'];?>: 
							<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
							<?php
							if (isset($group)) {
							?>
							&nbsp;<?php echo $lang['txt_group_link'];?>: <a href="grp_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $group['group_title'];?></a>
							<?php }?>
							<br />
						</p>
						
						<p>
							<b><?php echo $lang['hdr_poll'];?></b> -&#62; 
							<?php
							if (!empty($poll['bookmark'])) {
								echo $lang['txt_bookmarks'] . ": ";
								
								if (!empty($poll['bookmark']['watch'])) {
									echo $lang['txt_marked'];
								}
				
								if (!empty($poll['bookmark']['recommend'])) {
									echo $lang['txt_tipped'];
								}
								echo ", ";
							}
							?>
							<?php
							if ($poll['poll_create_datetime'] != $poll['poll_edit_datetime'] && !empty($poll['poll_edit_datetime'])) {
								echo $lang['txt_last_edited'] . ": ";
								echo $this->date->formatDate($poll['poll_edit_datetime'], 1) . ", ";
							}
							?>
							<?php echo $lang['txt_published_to'];?>: 
							<?php
							if (isset($poll['rsp'])) {
								foreach($poll['rsp'] as $key => $i):
									if (!empty($i['degree_id']) && $i['level_id'] == $rspconfig['rsp_level']['node']) {
									echo $lang['rsp']['rsp_level_degree'][$i['degree_id']];
								}
								else {
									echo trim($lang['rsp']['rsp_level'][$i['level_id']]);
								}
								echo " (" .$lang['rsp']['status'][$i['status_id']];
								
								if (!empty($i['rsp_featured'])) {
									echo " &amp; " .  $lang['txt_featured'];
								}
								
								echo ")";
								if ($key+1 < count($poll['rsp'])) {
									echo ", ";
								}
								endforeach;
							}
							?>
							<br />
						</p>
					<?php }?>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				//comments
				if (!empty($poll['poll_allow_comments'])) {
					$unlocked = 1;
				}
				
				$hidden_form = array(
					"poll_id" => $poll['poll_id']
				);
				
				if (isset($_REQUEST['user_id'])) {
					$hidden_form['user_id'] = $_REQUEST['user_id'];
				}
				
				if (isset($group['group_id'])) {
					$hidden_form['group_id'] = $group['group_id'];
				}
				
				if (isset($poll['user_id'])) {
					$hidden_form['item_user_id'] = $poll['user_id'];
				}
				
				include $templatePath . "comment.inc.tpl.php";
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($polls)) { //list view
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_polls'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['txt_intro'])) {
				?>
				<p>
					<?php echo $lang['txt_intro'];?><br />
				</p>
				<?php }?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					if (isset($polls)) {
					foreach($polls as $key => $i):
						$poll_url = "pol_view.php?poll_id=" . $i['poll_id'];
					?>
					<tr>
						<td>
							<b><?php echo $i['poll_question'];?></b><br />
						</td>
					</tr>
					<tr>
						<td valign="top" colspan="2">
							<table width="360" cellpadding="0" cellspacing="20" border="0">
								<tr>
									<td class="picture">
									<?php
									$poll = $i;
									
									include $templatePath . "poll.inc.tpl.php";
									unset($poll);
									?>
									</td>
								</tr>
							</table>
						</td>
				    </tr>
					<?php
					endforeach;
					}
					else {
					?>
					<tr>
						<td>
							<?php echo $lang['err_no_polls'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	elseif (isset($my_group_polls)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_group_polls'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['txt_intro_group'];?><br />
				
				<?php
				if (!empty($my_group_polls)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($my_group_polls as $key => $g):
					if (!empty($g['polls'])) {
					?>
					<tr>
						<td colspan="2">
							<b><?php echo $g['group_title'];?></b><br />
						</td>
						<td align="right" nowrap="nowrap">
							<a href="pol_view.php?group_id=<?php echo $g['group_id'];?>"><?php echo $lang['href_group_poll'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['polls'] as $key => $i):
					$poll_url = "pol_view.php?poll_id=" . $i['poll_id'];
					?>
					<tr>
						<td>
							<b><?php echo $i['poll_question'];?></b><br />
						</td>
					</tr>
					<tr>
						<td valign="top" colspan="2">
							<table width="360" cellpadding="0" cellspacing="20" border="0">
								<tr>
									<td class="picture">
									<?php
									$poll = $i;
									
									include $templatePath . "poll.inc.tpl.php";
									unset($poll);
									?>
									</td>
								</tr>
							</table>
						</td>
				    </tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="3">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					else {
						$group_no_poll_list[] = $g;
					}
					endforeach;
					?>
					
				</table>
				<?php }?>
				
				<?php
				if (!empty($group_no_poll_list)) {
				?>
				
				<p>
					<?php echo $lang['txt_outro_group'];?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($group_no_poll_list as $key => $g):
					?>
					<tr>
						<td>
							<b><?php echo $g['group_title'];?></b><br />
						</td>
						<td align="right">
							<a href="pol_view.php?group_id=<?php echo $g['group_id'];?>"><?php echo $lang['href_group_poll'];?></a><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($my_network_polls)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_network_polls'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_intro_network'];?><br />
				</p>
				
				<?php
				if (!empty($my_network_polls)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($my_network_polls as $key => $g):
					if (!empty($g['polls'])) {
					?>
					<tr>
						<td valign="top" width="32">
							<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><img src="get_file.php?file=<?php echo $g['image']['file'];?>" border="0" class="picture" alt="<?php echo $g['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right">
							<a href="pol_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_poll'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['polls'] as $key => $i):
					$poll_url = "pol_view.php?poll_id=" . $i['poll_id'];
					?>
					<tr>
						<td>
							<b><?php echo $i['poll_question'];?></b><br />
						</td>
					</tr>
					<tr>
						<td valign="top" colspan="2">
							<table width="360" cellpadding="0" cellspacing="20" border="0">
								<tr>
									<td class="picture">
									<?php
									$poll = $i;
									
									include $templatePath . "poll.inc.tpl.php";
									unset($poll);
									?>
									</td>
								</tr>
							</table>
						</td>
				    </tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="4">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					else {
						$network_no_poll_list[] = $g;
					}
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (!empty($network_no_poll_list)) {
				?>
				
				<p>
					<?php echo $lang['txt_outro_network'];?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($network_no_poll_list as $key => $g):
					?>
					<tr>
						<td colspan="2">
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $g['user_create_datetime'];?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $g['user_create_datetime'];?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right" colspan="2">
							<a href="pol_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_poll'];?></a><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	else  { //error - no polls
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_polls'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_no_polls'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<?php
	if (isset($polls) && isset ($profile)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_poll_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $profile['profile_nic'];?></b><br />
				</p>
				
				<img src="get_file.php?file=<?php echo $profile['image']['file'];?>" border="0" alt="<?php echo $profile['image']['file_title'];?>" /><br />
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_profile_session_status'];?><br />
						</td>
						<td>
							<?php
							if ($profile['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$profile['online_status']] . "<br />";
							}
							?>
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_hometown'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_hometown'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_joined'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($profile['profile_create_datetime']);?><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if (isset($polls) && isset ($group)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_poll_group_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $group['group_title'];?></b><br />
				</p>
				
				<?php
				if (isset($group['image']['file_id'])) {
				?>
				<img src="get_file.php?file=<?php echo $group['image']['file'];?>" border="0" alt="<?php echo $group['image']['file_title'];?>" /><br />
				<?php }?>
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_membership_status'];?><br />
						</td>
						<td>
							<?php echo $group['member']['role_name'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_language'];?><br />
						</td>
						<td>
							<?php
							if (isset($lang['arr_lang_name'][$group['language_id']])) {
								echo $lang['arr_lang_name'][$group['language_id']];
							}
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_type'];?><br />
						</td>
						<td>
							<?php 
							if (isset($group['group_registration_type'])) {
								echo $lang['arr_registration_type'][$group['group_registration_type']];
							}
							else {
								echo $lang['txt_hidden'];
							}
							
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_rec_age'];?><br />
						</td>
						<td>
							<?
							if ($group['group_from_age'] && $group['group_to_age']) {
								echo $group['group_from_age'] . "/" . $group['group_to_age'];
							}
							else if ($group['group_from_age'] && !$group['group_to_age']) {
								echo $lang['txt_age_from'] . " " . $group['group_from_age'];
							}
							else if (!$group['group_from_age'] && $group['group_to_age']) {
								echo $lang['txt_age_upto'] . " " . $group['group_to_age'];
							}
							else {
								echo $lang['txt_age_all'];
							}
							?>
							<br />
						</td>
					</tr>
				</table>
				
				<?php
				if (!empty($group['member']['role_visitor'])) {
				?>
				<p align="right">
					<b><a href="grp_membership.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_join'];?></a></b><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<div class="box">
		<div class="box_top">
				<?php echo $lang['hdr_options'];?><br />
			</div>
			
			<div class="box_mid">
				<div class="content">
					<p>
					<b><?php echo $lang['txt_view'];?></b><br />
				</p>
				
				<?php
				if (isset($view) && $view == "node") {
				?>
				<?php echo $lang['href_view_node'];?><br />
				<?php
				}
				else {
				?>
				<a href="pol_view.php?view=node"><?php echo $lang['href_view_node'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($me['user_id'])) {
				?>
				
				<?php
				if (isset($view) && $view == "my_network") {
				?>
				<?php echo $lang['href_view_network'];?><br />
				<?php
				}
				else {
				?>
				<a href="pol_view.php?view=my_network"><?php echo $lang['href_view_network'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "my_groups") {
				?>
				<?php echo $lang['href_view_my_groups'];?><br />
				<?php
				}
				else {
				?>
				<a href="pol_view.php?view=my_groups"><?php echo $lang['href_view_my_groups'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "voted") {
				?>
				<?php echo $lang['href_voted'];?><br />
				<?php
				}
				else {
				?>
				<a href="pol_view.php?view=voted"><?php echo $lang['href_voted'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "my_polls") {
				?>
				<?php echo $lang['href_my_polls'];?><br />
				<?php
				}
				else {
				?>
				<a href="pol_view.php?view=my_polls"><?php echo $lang['href_my_polls'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "marked_polls") {
				?>
				<?php echo $lang['href_marked'];?><br />
				<?php
				}
				else {
				?>
				<a href="pol_view.php?view=marked_polls"><?php echo $lang['href_marked'];?></a><br />
				<?php }?>
				
				<?php }?>
				<?php
				if (isset($poll)) {
				if (isset($group)) {
				?>
				<a href="pol_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_list_group_polls'];?></a><br />
				<?php
				}
				else {
				?>
				<a href="pol_view.php?user_id=<?php echo $poll['user_id'];?>"><?php echo $lang['href_list_polls'];?></a><br />
				<?php }}?>
				
				<?php
				if (isset($group) || isset($view) && $view == "my_polls") {
				?>
				<p>
					<b><?php echo $lang['txt_options'];?></b><br />
				</p>
				
					<?php
					if (isset($view) && $view == "my_polls" && $this->user_acs->checkPermission($resource_ids['node']['poll'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					?>
					<a href="pol_edit.php"><?php echo $lang['href_add_poll'];?></a><br />
					<?php }?>
					
					<?php
					if (isset($group)) {
					if ($this->group_acs->checkPermission($resource_ids['group']['poll'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					?>
					<a href="pol_edit.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_group_add_poll'];?></a><br />
					<?php }}?>
				<?php }?>
				
				
				<?php
				if (isset($poll)) {
				?>
				<p>
					<b><?php echo $lang['hdr_tag'];?></b><br />
				</p>
				
				<p>
					<?php
					$tags = "";
					if (isset($item_tags)) {
						foreach ($item_tags as $key => $i):
							$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							
							if ($i['user_id'] == $me['user_id']) {
								$tags .= "*";
							}
							
							if (count($item_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
						echo $tags;
					}
					?>
				</p>
					
				<?php
				if ($this->user_acs->checkPermission($resource_ids['node']['poll'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
				$tags = "";
				if (isset($my_tags)) {
					foreach ($my_tags as $key => $i):
						$tags .= $i['tag_body'];
						if (count($my_tags) > $key+1) {
							$tags .= ", ";
						}
					endforeach;
				}
				?>
				
				
				<form action="pol_view.php" method="post" name="frm_view" id="id_frm_view">
				<input type="hidden" name="poll_id" value="<?php if(isset($poll['poll_id'])) { echo $poll['poll_id'];}?>" />
				<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];}?>" />
				
				
				<p>
					<input width="30" class="input" name="tags" value="<?php echo $tags;?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
				</p>
				
				</form>
				<?php }?>
				<?php }?>
				
				<p>
					<b><?php echo $lang['hdr_search'];?></b><br />
				</p>
				
				<form action="search.php" method="post" name="search" id="id_search">
				<input type="hidden" name="search_type" value="poll" />
				
				<p>
					<input type="text" class="input" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
				
				</form>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
