<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

//ACS check
if (!empty($_REQUEST['group_id'])) { // page under group section
	
	$group_id = $_REQUEST['group_id'];
	include_once ('inc/header_group.inc.php');
	
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['forum'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
		header("Location: grp_view.php?group_id=" . $_REQUEST['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	
	//get the roles for the group
	$output_group_roles = $group_acs->getGroupRoles();
	
}
else {
	if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['forum'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
		header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
		exit;
	}
	unset ($group_id);
}

require_once($languageArrayPath . 'arr_acs.lang.php');


// SETUP FORUM ---------------------------------------------------------
require_once('class/Forum.class.php');
$forum = new Forum($db, null, $file);

if (isset($_REQUEST['topic_id'])) {
	$forum->topic_id = $_REQUEST['topic_id'];
}

if (isset($_REQUEST['subject_id'])) {
	$forum->subject_id = $_REQUEST['subject_id'];
}

if (isset($group_id)) {
    $forum->group_id = $group_id;
}


//SETUP RSP ---------------------------------------------------------
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['forum']);
$rsp->user_id = $me['user_id'];

if($c_node['rsp']['node']['auto_publish'] == 1) {
	$rsp->status_id = $c_node['rsp']['status']['live'];
}
else {
	$rsp->status_id = $c_node['rsp']['status']['pending'];
}

if (isset($group_id)) {
    $rsp->group_id = $group_id;
}


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {
	if (isset($frmdata['save_subject']) || isset($frmdata['save_go_subject'])) {
		
		if (empty($frmdata['subject_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			//
			$forum->user_id = $me['user_id'];
			
			if (isset($frmdata['subject_id']) && $frmdata['subject_id'] > 0) {
		         //we update the event
		 		$forum->updateSubject($frmdata);
			}
		 	else { //we insert record
		 		$forum->user_id = $me['user_id'];
		 		$forum->insertSubject($frmdata);
		 	}
			
			if (empty($GLOBALS['am_error_log'])) {
				//insert into setup rsp
				if (!empty($frmdata['group_id'])) {
				    $temp['language_id'] = $output_group['language_id'];
				}
				else {
					$temp['language_id'] = $me['language_id'];
				}
				
				$temp['item_id'] = $forum->subject_id;
				//delete all
				$rsp->deleteRspItem($forum->subject_id);
				
				if (!empty($frmdata['rsp_degree'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['degree'];
					if ($frmdata['rsp_degree'] == "all") {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_degree'];
					}
					$rsp->insertRspItem($temp);
				}
					
				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					$rsp->insertRspItem($temp);
				}
				
				if (isset($frmdata['rsp_group'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['group']['home'];

					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					$rsp->status_id = $c_node['rsp']['status']['pending'];
					$rsp->insertRspItem($temp);
				}
				
				//setup statistics
				require_once('class/Statistic.class.php');
				$statistic = new Statistic($db, null, $date);
				
				//update stats
				if (!empty($frmdata['group_id'])) { // page under group section
					unset($forum->user_id);
					$statistic->group_id = $frmdata['group_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group']['total_forum_subjects'];
				}
				else {
					$forum->user_id = $me['user_id'];
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['user']['total_forum_subjects'];
				}
				
				$statistic->setStatistic($forum->getSubjectCount());
				
				//get member subject stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_forum_subjects'];
					$statistic->setStatistic($forum->getSubjectCount($me['user_id']));
				}
				
				if (isset($frmdata['save_go_subject'])) {
					header("Location: frm_view.php?subject_id=" . $forum->subject_id . "&". strip_tags(SID));
					exit;
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: frm_edit.php?group_id=" . $frmdata['group_id'] . "&subject_id=" . $forum->subject_id . "&". strip_tags(SID));
						exit;
					}
					else {
						header("Location: frm_edit.php?subject_id=" . $forum->subject_id . "&". strip_tags(SID));
						exit;
					}
				}
			}
			else { // something errored
				$output_subject = $frmdata;
			}
			
			$display = "edit_subject";
		}
	}
	elseif (isset($frmdata['save_topic']) || isset($frmdata['save_go_topic'])) {
		
		if (empty($frmdata['topic_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			//
			if (isset($frmdata['topic_id']) && $frmdata['topic_id'] > 0) {
		         //we update the event
		 		$forum->updateTopic($frmdata);
			}
		 	else { //we insert record
		 		$forum->user_id = $me['user_id'];
		 		$forum->insertTopic($frmdata);
		 	}
			
			if (empty($GLOBALS['am_error_log'])) {
				
				if (empty($frmdata['role_ids'])) {
					$frmdata['role_ids'] = array();
				}
				
				$forum->insertTopicRoles($frmdata['role_ids']);
				
				if (isset($frmdata['save_go_topic'])) {
					header("Location: frm_view.php?topic_id=" . $forum->topic_id . "&". strip_tags(SID));
					exit;
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: frm_edit.php?group_id=" . $frmdata['group_id'] . "&topic_id=" . $forum->topic_id . "&". strip_tags(SID));
						exit;
					}
					else {
						header("Location: frm_edit.php?topic_id=" . $forum->topic_id . "&". strip_tags(SID));
						exit;
					}
				}
			}
			else { // somehing errored
				$output_topic = $frmdata;
			}
			
			$display = "edit_topic";
		}
	}
	elseif (isset($frmdata['delete_topic']) && isset($frmdata['topic_id'])) {
		//we can only delete a topic if no subjects are under it
		$forum->deleteTopic($frmdata['topic_id']);
	
	$display = "edit_topic";
	}
}
elseif (isset($_REQUEST['add_subject'])) {
	
	if (isset($_REQUEST['topic_id'])) {//we edit topic
		$output_topic['topic_id'] = $_REQUEST['topic_id'];
	}
	
	$display = "edit_subject";
}
elseif (isset($_REQUEST['topic_id'])) {//we edit topic
	$output_topic = $forum->selTopic();
	
	if (!empty($output_topic['group_id'])) {
		// we check that I am in the group and that I have permissions to view
		$group_id = $output_topic['group_id'];
		include_once ('inc/header_group.inc.php');
		
		if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['forum'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
			$display = "edit_topic";
		}
		else {
			unset($output_blog, $display);
		}
	}
	else {
		$display = "edit_topic";
	}
	
	if (!empty($output_topic)) {
	    $output_topic['total_subjects'] = $forum->getSubjectCount();
	}
	
	//$output_roles = $group_acs->getGroupRoles();
	$output_topic_roles = $forum->SelTopicRoles();	
	
	
}
elseif (isset($_REQUEST['add_topic'])) {//we add topic
	
	$display = "edit_topic";
}
elseif (isset($_REQUEST['subject_id'])) {
	$output_subject = $forum->selSubject();
	
	if (!empty($output_subject['group_id'])) {
		// we check that I am in the group and that I have permissions to view
		$group_id = $output_subject['group_id'];
		include_once ('inc/header_group.inc.php');
		
		if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['forum'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
			$display = "edit_subject";
		}
		else {
			unset($output_subject, $display);
		}
	}
	else {
		$display = "edit_subject";
	}
	
}
else { // add a subject
	$display = "edit_subject";
}

$file->user_id = $me['user_id'];
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

if (!empty($output_subject['group_id'])) {
	$file->group_id = $output_subject['group_id'];
	unset($file->user_id);
}

$output_images = $file->getFiles();


// if we have edit permissions we list all topics, else we check for 
// the topics I can add to
if (isset($group_id) && $group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['forum'], $c_acs['arr_acs']['privilege']['add_item'])) {
	$output_topics = $forum->selTopics();
}
elseif ($user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['forum'], $c_acs['arr_acs']['privilege']['add_item'])) { //resource_id, Priv_id
	$output_topics = $forum->selTopics();
}
else {
	//$output_topic_roles = $forum->SelTopicRoles($group_acs->role_id);
	
	if (!empty($output_topic_roles)) {
		$output_topic_role_ids = array();
		foreach($output_topic_roles as $key => $i):
			array_push($output_topic_role_ids, $i['topic_id']);
		endforeach;
		
		$forum->topic_ids = $output_topic_role_ids;
		$output_topics = $forum->getTopics();
	}
	else {
		header("Location: frm_view.php?". strip_tags(SID));
		exit;
	}
}


//RSP items
if (!empty($forum->subject_id)) {
	$output_subject['rsp'] = $rsp->selRspItem($forum->subject_id);
}


//move to template
if (!empty($output_group_roles)) {
	$body->set('group_roles', $output_group_roles);
}

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}

if (!empty($output_topic)) {
	$body->set('topic', $output_topic);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
}

if (!empty($output_roles)) {
    $body->set('roles', $output_roles);
}

if (!empty($output_topic_roles)) {
    $body->set('topic_roles', $output_topic_roles);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
