<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "magazine";
include "inc/header.inc.php";


//ACS check
if (!isset($rss_access_granted) && (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['schedule'], $c_acs['arr_acs']['privilege']['allow_access']))) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_schedule.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');


// SETUP SCHEDULE ------------------------------------------------------------
require_once('class/Schedule.class.php');
$schedule = new Schedule($db, null, $date, $file);
$schedule->schedule_config = $c_node['schedule'];
$schedule->rsp_level_id = $rsp_level_id;


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');
	
	
// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['schedule'], $date);

if (isset($me['user_id'])) {
	$comment->user_id = $me['user_id'];
}

$comment->wiki = $wiki;
	
	
// SETUP TAGS ------------------------------------------------------------
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['schedule']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}


// SETUP BOOKMARKS -------------------------------------------------------
if (isset($me['user_id'])) {
	require_once('class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['schedule'], $me['user_id']);
}


// SETUP FILTER ----------------------------------------------------------
if(!empty($frmdata['start_date'])) { // default is today
	$schedule->start_date = $date->formatFormDateTime($frmdata['start_date']);
}
else {
	$frmdata['start_date'] = date("Y-m-d"); //now
}


if(!empty($frmdata['schedule_show'])) { //default is 5
	$schedule->no_of_days_shown = $frmdata['schedule_show'];
}

$schedule->status_ids = array($c_node['schedule']['status']['confirmed']);

if(!empty($frmdata['schedule_status'])) {
	array_push($schedule->status_ids, $c_node['schedule']['status']['tentative']);
}
	

// PROCESS FORM ----------------------------------------------------------
if (isset($_POST['update_tag'])) {
	$frmdata['item_id'] = $frmdata['schedule_id'];
	$tag->deleteItemTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: sch_view.php?schedule_id=". $frmdata['schedule_id'] . "&" . strip_tags(SID));
	exit;
}	
elseif (isset($_POST['preview'])) {
	unset($schedule->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
	
	$schedule->schedule_id = $_REQUEST['schedule_id'];
	
	$output_schedule_item = $schedule->selScheduleItem();
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $frmdata['schedule_id'];
	$comment->insertComment($frmdata);

	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db, $date);
		
		if (isset($frmdata['group_id'])) {
			$comment->group_id = $frmdata['group_id'];
		}
		
		//update user stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());
		
		if (isset($frmdata['group_id'])) {
			$comment->group_id = $frmdata['group_id'];
			$statistic->group_id = $frmdata['group_id'];
			
			//update group stats
			unset($comment->user_id, $statistic->user_id, $comment->rsp_item_type_id, $comment->item_id);
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
			$statistic->setStatistic($comment->getCommentCount());
			
			//group member comments
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_comments'];
			$statistic->user_id = $me['user_id'];
			$comment->user_id = $me['user_id'];
			$statistic->setStatistic($comment->getCommentCount());
		}

		return header("Location: sch_view.php?schedule_id=". $frmdata['schedule_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	unset($schedule->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
	$schedule->schedule_id = $_REQUEST['schedule_id'];
	
	$output_schedule_item = $schedule->selScheduleItem();
}
elseif (isset($_REQUEST['withdraw_confirmation'])) {
	$schedule->updateScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['withdrawn']);
	header("Location: sch_view.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['schedule_apply_update'])) {
	$schedule->updateScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['pending']);
	header("Location: sch_view.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['schedule_apply'])) {
	$schedule->insertScheduleAllocation($_REQUEST['schedule_id'], $me['user_id'], $c_node['schedule']['allocation_status']['pending']);
	header("Location: sch_view.php?schedule_id=" . $_REQUEST['schedule_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($frmdata['group_options'])) {
	if ($frmdata['group_options'] == "grp_view") {
		header("Location: grp_view.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "grp_structure") {
		header("Location: grp_structure.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "grp_membership") {
		header("Location: grp_membership.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "list_group") {
		header("Location: sch_view.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "add_group") {
		header("Location: sch_edit.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($frmdata['options']) && $frmdata['options'] != "list_node") {
	if ($frmdata['options'] == "list_relation") {
		//get the latest relations schedules
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		foreach($_SESSION['relations'] as $key => $i):
			$schedule->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		if (!empty($schedule->user_ids)) {
			$output_schedule_items = $schedule->selScheduleItems();
		}
	}
	elseif ($frmdata['options'] == "list_initiated") {
		//get the latest relations schedules
		unset($schedule->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		// get schedule items that i've created
		unset($schedule->start_date);
		$schedule->user_id = $me['user_id'];
		$output_schedule_items = $schedule->selScheduleItems();
	}
	elseif ($frmdata['options'] == "list_allocation") {
		// get schedule items I am allocated to
		unset($schedule->start_date);
		$output_schedule_items = $schedule->selScheduleItems(null, 1);
	}
	elseif ($frmdata['options'] == "list_marked") {
		//get my marked schedules
		unset($schedule->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		$watched_schedule_ids = $bookmark->getBookmarks();
		$schedule->user_id = $me['user_id'];
		
		if (!empty($watched_schedule_ids)) {
			$schedule->schedule_ids = $watched_schedule_ids;
			$output_schedule_items = $schedule->selScheduleItems();
		}
	}
	elseif ($frmdata['options'] == "list_relation_tips") {
		//get my relations tipped schedules
		unset($schedule->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		unset($bookmark->user_id);
		foreach($_SESSION['relations'] as $key => $i):
			$bookmark->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		$recommended_schedule_ids = $bookmark->getBookmarks();
		
		if (!empty($recommended_schedule_ids)) {
			$schedule->schedule_ids = $recommended_schedule_ids;
			
			$output_schedule_items = $schedule->selScheduleItems();
		}
		
	}
	elseif ($frmdata['options'] == "list_initiated") {
		//get schedules for this user (if relation)
		unset($schedule->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$schedule->file = $file;
		
		if (!empty($_SESSION['relations'])) {
			foreach($_SESSION['relations'] as $key => $i):
				if (!empty($frmdata['user_id']) && $frmdata['user_id'] == $i['user_id_relation']) {
					$schedule->user_id = $frmdata['user_id'];
					
					$output_schedule_items = $schedule->selScheduleItems();
					
					break;
				}
			endforeach;
		}
		
	}
	elseif ($frmdata['options'] == "item_mark") {
		//mark this item
		$bookmark->item_id = $frmdata['schedule_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->insertBookmark();
		
		$schedule->schedule_id = $frmdata['schedule_id'];
		$output_schedule_item = $schedule->selScheduleItem();
	}
	elseif ($frmdata['options'] == "item_tip") {
		//tip this item
		$bookmark->item_id = $frmdata['schedule_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
		
		$schedule->schedule_id = $frmdata['schedule_id'];
		$output_schedule_item = $schedule->selScheduleItem();
	}
	elseif ($frmdata['options'] == "item_edit") {
		//edit this item
		header("Location: sch_edit.php?schedule_id=" . $frmdata['schedule_id'] . "&". strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "item_edit_allocation") {
		//edit this item
		header("Location: sch_edit.php?allocation=1&schedule_id=" . $frmdata['schedule_id'] . "&". strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "item_add_event") {
		//add an item
		header("Location: sch_edit.php?schedule_type_id=" . $c_node['schedule']['type']['event'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "item_add_task") {
		//add an item
		header("Location: sch_edit.php?schedule_type_id=" . $c_node['schedule']['type']['task'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (!empty($_REQUEST['schedule_id']) && !isset($frmdata['options'])) { //display item
	unset($schedule->rsp_level_id);
	
	if (isset($me['user_id'])) {
		$schedule->user_id = $me['user_id'];
	}
	
	$schedule->schedule_id = $_REQUEST['schedule_id'];
	$output_schedule_item = $schedule->selScheduleItem();
}
elseif (isset($_REQUEST['group_id'])) {
	include_once ('inc/header_group.inc.php');
	require_once($languagePath . 'grp_common.lang.php');
	$schedule->group_id = $_REQUEST['group_id'];
	
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$schedule->file = $file;
	
	$output_schedule_items = $schedule->selScheduleItems();
}
else {
	//get the latest node schedules
	unset($schedule->user_id, $schedule->start_date);
	// setup images
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$schedule->file = $file;
	
	$schedule->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
	$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
	
	$output_schedule_items = $schedule->selScheduleItems();
}


// CHECK PERMISSION TO VIEW SCHEDULE ----------------------------------------
if (!empty($output_schedule_item)) {
	// Are we allowed to see this schedule?
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	require_once('class/Rsp.class.php');
	$rsp = new Rsp($db, $c_node['rsp']['item_type']['schedule']);
	$output_schedule_item['rsp'] = $rsp->selRspItem($schedule->schedule_id);
	
	if (!empty($output_schedule_item['group_id'])) {
		// we check that I am in the group and that I have permissions to view
		$group_id = $output_schedule_item['group_id'];
		include_once ('inc/header_group.inc.php');
		require_once($languagePath . 'grp_common.lang.php');
		
		if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
			header("Location: grp_membership.php?group_id=" . $output_schedule_item['group_id'] . "&". strip_tags(SID));
			exit;
		}
		
		$schedule->group_id = $output_schedule_item['group_id'];
		
		$allow_view = 1;
	}
	elseif (isset($me['user_id']) && $me['user_id'] == $output_schedule_item['user_id']) {
		// is the author me?
		$allow_view = 1;
	}
	elseif (!empty($output_schedule_item['rsp'])) {
		// is the item published to node or public and can I see it?
		foreach ($output_schedule_item['rsp'] as $key => $i):
			if ($i['level_id'] == $rsp_level_id) {
				$allow_view = 1;
				break;
			}
			
			// is it set to network and ar they in my network?
			if (!empty($i['degree_id'])) {
				foreach($_SESSION['relations'] as $key => $r):
					if ($output_schedule_item['user_id'] == $r['user_id_relation']) {
						$allow_view = 1;
						break;
					}
					
					if (isset($allow_view)) {
						break;
					}
				endforeach;
			}
		endforeach;
	}
	
	if (!isset($allow_view)) {
		unset($output_schedule_item);
	}
}

if (isset($output_schedule_item['schedule_id'])) {
	//wikify body
	$wiki_path = "lib_view.php?page=";
	$wiki_new_path = "lib_edit.php?page=";
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . $wiki_image_base);
	$output_schedule_item['schedule_body'] = $wiki->transform($output_schedule_item['schedule_body'], 'Xhtml');
	
	
	//get the group and/or the author
	$output_author = $user->selProfile(null, $output_schedule_item['user_id']);
	
	
	// GET BOOKMARK --------------------------------------------------
	if (isset($bookmark)) {
		$bookmark->item_id = $schedule->schedule_id;
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_schedule_item['bookmark']['watch'] = 1;
		}
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_schedule_item['bookmark']['recommend'] = 1;
		}
	}
	
	if ($output_schedule_item['schedule_p_complete']<1) {
		$output_schedule_item['schedule_p_complete'] = "0";
	}
	
	//get comments
	unset($comment->user_id);
	$output_comments = $comment->selComments($schedule->schedule_id);
	
	
	//get tags
	$tag->item_id = $schedule->schedule_id;
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_item_tags = $tag->selTags(1);
}



if (!isset($output_schedule_item)) {
	//get the total future items --------------------------------------------
	unset($schedule->user_id);
	$schedule->schedule_type_id = $c_node['schedule']['type']['event'];
	$total_schedule_items = $schedule->countScheduleItems();
	$lang['txt_event_summary'] = str_replace('SCHEDTOTAL', $total_schedule_items, $lang['txt_event_summary']);
	$schedule->schedule_type_id = $c_node['schedule']['type']['task'];
	$total_schedule_items = $schedule->countScheduleItems();
	$lang['txt_task_summary'] = str_replace('SCHEDTOTAL', $total_schedule_items, $lang['txt_task_summary']);
}
else {
	unset($lang['txt_event_summary'], $lang['txt_task_summary']);
}


//move to template
if (!empty($output_schedule_items)) {
   $body->set('schedule_items', $output_schedule_items);
}

if (!empty($output_schedule_item)) {
	$body->set('schedule', $output_schedule_item);
	$body->set('rsp_config', $c_node['rsp']); 
}

if (isset($display)) {
   $body->set('display', $display);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($frmdata)) {
    $body->set('search', $frmdata);
}

$body->set('schedule_config', $c_node['schedule']);
$body->set('languagePath', $languagePath); //for calendar lang config


$template_pageLink = $lang['txt_schedule'];

include "inc/footer.inc.php";

?>
