<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_group_summary'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $group['group_home_synopsis'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	if ($this->group_acs->checkPermission($resource_ids['group']['blog'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_recommended_b'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					if (isset($blogs)) {
					foreach($blogs as $key => $i):
					?>
					<tr>
						<td valign="top" width="1%">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
						</td>
						<td valign="top">
							<a href="blg_view.php?blog_id=<?php echo $i['blog_id'];?>"><?php echo $this->date->formatDate($i['blog_create_datetime'],1);?></a><br />
							<b><?php echo $i['blog_title'];?></b><br />
							<?php echo $i['blog_synopsis'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					} else {
					?>
					<tr>
						<td>
							<?php echo $lang['err_no_blogs'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if ($this->group_acs->checkPermission($resource_ids['group']['forum'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_recommended_s'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					if (isset($subjects)) {
					foreach($subjects as $key => $i):
					?>
					<tr valign="top">
						<td valign="top" width="1%">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
						</td>
						<td valign="top">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><?php echo $this->date->formatDate($i['subject_create_datetime'],1);?></a><br />
							<b><?php echo $i['subject_title'];?></b><br />
							<?php echo $i['subject_synopsis'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					} else {
					?>
					<tr>
						<td colspan="2">
							<?php echo $lang['err_no_subjects'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if ($this->group_acs->checkPermission($resource_ids['group']['library'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_library'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					if (isset($library)) {
					foreach($library as $key => $i):
					?>
					<tr>
						<td valign="top" width="1%">
							<a href="lib_view.php?page=<?php echo $i['library_page_name'];?>"><img align="right" src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
						</td>
						<td valign="top">
							<a href="lib_view.php?page=<?php echo $i['library_page_name'];?>"><?php echo $i['library_create_datetime'];?></a><br />
							<b><?php echo $i['library_title'];?></b><br />
							<?php echo $i['library_synopsis'];?><br />
						</td>
					</tr>
					<?php
					endforeach;
					} else {
					?>
					<tr>
						<td colspan="2">
							<?php echo $lang['err_no_library'];?><br />
						</td>
					</tr>
				<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	
	<?php
	if ($this->group_acs->checkPermission($resource_ids['group']['poll'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
	if (isset($polls)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_polls'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="4" cellpadding="0" width="100%">
					<?php
					foreach($polls as $key => $i):
					?>
					<tr>
						<td valign="top">
							<?php
							$poll = $i;
							$poll_url = "pol_view.php?poll_id=" . $i['poll_id'];
							include $templatePath . "poll.inc.tpl.php";
							?>
						</td>
					</tr>
					<tr>
						<td>
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="2" alt="" /><br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }}?>
	
	<?php
	if ($this->group_acs->checkPermission($resource_ids['group']['schedule'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_schedule'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($schedule_items)) {
				?>
					<p>
						<b><?php echo $lang['hdr_tasks'];?></b><br />
					</p>
					
					<table width="100%" cellpadding="4" cellspacing="0" border="0">
						<?php
						$display_items = trimArray($schedule_items);
						foreach($display_items as $key => $i):
						if (isset($i['schedule_type_id']) && $i['schedule_type_id'] == 2) { //task
						?>
						<tr>
							<td valign="top">
								<a href="sch_view.php?schedule_id=<?php echo $i['schedule_id']?>"><?php echo $i['schedule_title'];?></a><br />
								<?php echo $i['schedule_synopsis'];?><br />
							</td>
							<td align="right" valign="top" nowrap>
								<?php
								if (!empty($i['schedule_occurence'])) {
									if ($i['schedule_occurence'] == $schedule_config['occurrence']['daily']) {
										echo $lang['schedule']['occurrence'][1] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 3);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['weekly']) {
										echo $lang['schedule']['occurrence'][3] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 4);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['monthly']) {
										echo $lang['schedule']['occurrence'][9] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 5);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['yearly']) {
										echo $lang['schedule']['occurrence'][12] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 5);
									}
								}
								else { //no repeat
									echo $i['display_schedule_start_datetime'];
								}
								?>
								<br />
								<?php
								if (isset($i['schedule_allocation'])) {
									echo $lang['txt_allocation'] . ": " . $i['schedule_allocation'] . "<br />";
								}
								?>
							</td>
						</tr>
						<?php
						}
						endforeach;
						?>
					</table>
					
					<p>
						<b><?php echo $lang['hdr_events'];?></b><br />
					</p>
					
					<table width="100%" cellpadding="4" cellspacing="0" border="0">
						<?php
						foreach($display_items as $key => $i):
						if (isset($i['schedule_type_id']) && $i['schedule_type_id'] == 1) { //event
						?>
						<tr>
							<td valign="top">
								<a href="sch_view.php?schedule_id=<?php echo $i['schedule_id']?>"><?php echo $i['schedule_title'];?></a><br />
								<?php echo $i['schedule_synopsis'];?><br />
							</td>
							<td align="right" valign="top" nowrap>
								<?php
								if (!empty($i['schedule_occurence'])) {
									if ($i['schedule_occurence'] == $schedule_config['occurrence']['daily']) {
										echo $lang['schedule']['occurrence'][1] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 3);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['weekly']) {
										echo $lang['schedule']['occurrence'][3] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 4);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['monthly']) {
										echo $lang['schedule']['occurrence'][9] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 5);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['yearly']) {
										echo $lang['schedule']['occurrence'][12] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 5);
									}
								}
								else { //no repeat
									echo $i['display_schedule_start_datetime'];
								}
								?>
								<br />
								<?php
								if (isset($i['schedule_allocation'])) {
									echo $lang['txt_allocation'] . ": " . $i['schedule_allocation'] . "<br />";
								}
								?>
								<br />
								<?php
								if (isset($i['allocation_status_id'])) {
									echo $lang['schedule']['allocation_status'][$i['allocation_status_id']] . "<br />";
								}
								?>
							</td>
						</tr>
						<?php
						}
						endforeach;
						?>
					</table>
					<?php
					echo createArrayList($schedule_items);
					?>
				<?php 
				}
				if (!isset($schedule) && !isset($schedule_items	)) {
					echo $lang['err_no_schedule_items'] . "<br />";
				}
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					if (isset($comments)) {
					foreach($comments as $key => $i):
					?>
					
					<tr>
						<td width="3" valign="top">
							<img src="<?php echo $templatePath;?>img/green_dot.png" width="3" height="9" alt="" /><br />
						</td>
						<td>
							<table width="100%" cellpadding="4" cellspacing="0" border="0">
								<tr>
									<td valign="top" colspan="2">
										<b>
										<?php
										if ($rsp_item_type_ids['blog'] == $i['rsp_item_type_id']) {
										?>
										<a href="blg_view.php?blog_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
										<?php
										}
										elseif ($rsp_item_type_ids['library'] == $i['rsp_item_type_id']) {
										?>
										<a href="lib_view.php?library_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
										<?php
										}
										elseif ($rsp_item_type_ids['forum'] == $i['rsp_item_type_id']) {
										?>
										<a href="frm_view.php?subject_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
										<?php
										}
										elseif ($rsp_item_type_ids['poll'] == $i['rsp_item_type_id']) {
										?>
										<a href="pol_view.php?poll_id=<?php echo $i['item_id'];?>"><?php echo $lang['rsp']['item_type'][$i['rsp_item_type_id']];?></a>
										<? }?>
										</b><br />
										
										<p>
										<?php echo dots(160, $i['comment_body']);?><br />
										</p>
										
										<p class="txt_footer">
										<?php echo $lang['txt_from'];?>: <a href="grp_membership.php?group_id=<?php echo $group['group_id'];?>&amp;user_id=<?php echo $i['user_id'];?>" class="txt_footer_link"><?php echo $i['profile_nic'];?></a>&nbsp;(<?php echo $lang['txt_joined'];?>: <?php echo $i['profile_create_datetime'];?>, <?php echo $lang['txt_hometown'];?>: <?php echo $i['profile_hometown'];?>)<br />
										<?php echo $lang['txt_comment_datetime'];?>: <?php echo $i['comment_create_datetime'];?><br />
										</p>
									</td>
								</tr>
	
							</table>
						</td>
					</tr>
					<?php
					endforeach;
					} else {
					?>
					<tr>
						<td colspan="2">
							<?php echo $lang['err_no_comments'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $group['group_title'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($group['image']['file_id'])) {
				?>
				<img src="get_file.php?file=<?php echo $group['image']['file'];?>" border="0" alt="<?php echo $group['image']['file_title'];?>" /><br />
				<?php }?>
				
				<form action="grp_view.php" method="post" name="frm_view" id="id_frm_view">
				<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];}?>" />
				
				<p>
					<select name="options" class="options_select">
					<option value="grp_view" selected="selected"><?php echo $lang['txt_option_group'];?></option>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['blog'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<option value="grp_blog"><?php echo $lang['txt_option_blog'];?></option>
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['forum'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<option value="grp_forum"><?php echo $lang['txt_option_forum'];?></option>
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['poll'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<option value="grp_poll"><?php echo $lang['txt_option_poll'];?></option>
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['files'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<option value="grp_file"><?php echo $lang['txt_option_file'];?></option>
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['library'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<option value="grp_library"><?php echo $lang['txt_option_library'];?></option>
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['schedule'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<option value="grp_schedule"><?php echo $lang['txt_option_schedule'];?></option>
					<?php }?>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['channels'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
					?>
					<option value="grp_channel"><?php echo $lang['txt_option_channel'];?></option>
					<?php }?>
					
					<option value="grp_structure"><?php echo $lang['txt_option_structure'];?></option>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['allow_membership'])) { //resourece_id, Priv_id
					?>
					<option value="grp_directory"><?php echo $lang['txt_option_directory'];?></option>
					<?php }?>
					
					<option value="grp_membership"><?php echo $lang['txt_option_membership'];?></option>
					
					<?php
					if ($this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['allow_newsletter'])) { //resourece_id, Priv_id
					?>
					<option value="grp_newsletter"><?php echo $lang['txt_option_newsletter'];?></option>
					<?php }?>
					
					</select>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="option_action" class="go" /><br />
				</p>
				
				<p>
					<h3><?php echo $lang['hdr_search'];?></h3>
				</p>
				
				<p>
					<input type="text" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_membership'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_membership_status'];?><br />
						</td>
						<td>
							<?php echo $group['member']['role_name'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_language'];?><br />
						</td>
						<td>
							<?php
							if (isset($lang['arr_lang_name'][$group['language_id']])) {
								echo $lang['arr_lang_name'][$group['language_id']];
							}
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_type'];?><br />
						</td>
						<td>
							<?php 
							if (isset($group['group_registration_type'])) {
								echo $lang['arr_registration_type'][$group['group_registration_type']];
							}
							else {
								echo $lang['txt_hidden'];
							}
							
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_rec_age'];?><br />
						</td>
						<td>
							<?
							if ($group['group_from_age'] && $group['group_to_age']) {
								echo $group['group_from_age'] . "/" . $group['group_to_age'];
							}
							else if ($group['group_from_age'] && !$group['group_to_age']) {
								echo $group['group_from_age'] . " and up";
							}
							else if (!$group['group_from_age'] && $group['group_to_age']) {
								echo "up to " . $group['group_to_age'];
							}
							else {
								echo "all";
							}
							?>
							<br />
						</td>
					</tr>
				</table>
				
				<?php
				if (!empty($group['member']['role_visitor'])) {
				?>
				<p align="right">
					<b><a href="grp_membership.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_join'];?></a></b><br />
				</p>
				<?php }?>
				
				<br />
				
				<?php
				if (isset($group_statistic)) {
				?>
				<hr />
				<table width="100%" cellpadding="2" cellspacing="0" border="0">
					<?php
					foreach($group_statistic as $key => $i):
					if (isset($lang['arr_group_statistic_type_id'][$i['statistic_type_id']])) {
					?>
					<tr>
						<td>
							<?php echo $lang['arr_group_statistic_type_id'][$i['statistic_type_id']];?><br />
						</td>
						<td align="right">
							<?php echo $i['total'];?><br />
						</td>
					</tr>
					<?php
					}
					endforeach;
					?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_tag'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
				<?php
					$tags = "";
					if (isset($item_tags)) {
						foreach ($item_tags as $key => $i):
							$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							
							//mark my tags
							if (isset($my_tags)) {
								foreach ($my_tags as $key => $mt):
									if ($i['tag_body'] == $mt['tag_body']) {
										$tags .= "*";
										break;
									}
								endforeach;
							}
							
							if (count($item_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
						echo $tags;
					}
					?>
				</p>
				
				<?php
				if ($this->user_acs->checkPermission($resource_ids['node']['group'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
				$tags = "";
				if (isset($my_tags)) {
					foreach ($my_tags as $key => $i):
						$tags .= $i['tag_body'];
						if (count($my_tags) > $key+1) {
							$tags .= ", ";
						}
					endforeach;
				}
				?>
			
				<p>
					<input width="30" name="tags" value="<?php echo $tags;?>" />
					<input type="image" name="update_tag" src="<?php echo $templatePath;?>img/go.png" value="1" class="go" /><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
