<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "magazine";
include "inc/header.inc.php";


//ACS check
if (!isset($rss_access_granted) && (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['forum'], $c_acs['arr_acs']['privilege']['allow_access']))) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_acs.lang.php');


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['forum']);
$comment->wiki = $wiki;


// SETUP FORUM -----------------------------------------------------------
require_once('class/Forum.class.php');
$forum = new Forum($db, null, null);
$forum->comment = $comment;
$forum->rsp_level_id = $rsp_level_id;

if (!empty($_REQUEST['topic_id'])) {
	$forum->topic_id = $_REQUEST['topic_id'];
}

if (isset($_REQUEST['subject_id'])) {
	$forum->subject_id = $_REQUEST['subject_id'];
}


// SETUP TAGS -----------------------------------------------------------
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['forum']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}


// SETUP BOOKMARKS -------------------------------------------------------
if (isset($me['user_id'])) {
	require_once('class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['forum'], $me['user_id']);
}

// PROCESS FORM ----------------------------------------------------------
if (isset($_POST['update_tag'])) {
	$frmdata['item_id'] = $frmdata['subject_id'];
	$tag->deleteItemTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: frm_view.php?subject_id=". $frmdata['subject_id'] . "&" . strip_tags(SID));
	exit;
}	
elseif (isset($_POST['preview'])) {
	unset($forum->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
	
	$forum->subject_id = $_REQUEST['subject_id'];
	
	$output_subject = $forum->selSubject();
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->user_id = $me['user_id'];
	$comment->item_id = $frmdata['subject_id'];
	$comment->insertComment($frmdata);
		
	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db, $date);
		
		//update user stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());
		
		if (isset($frmdata['group_id'])) {
			$comment->group_id = $frmdata['group_id'];
			$statistic->group_id = $frmdata['group_id'];
			
			//update group stats
			unset($comment->user_id, $statistic->user_id, $comment->rsp_item_type_id, $comment->item_id);
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
			$statistic->setStatistic($comment->getCommentCount());
			
			//group member comments
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_comments'];
			$statistic->user_id = $me['user_id'];
			$comment->user_id = $me['user_id'];
			$statistic->setStatistic($comment->getCommentCount());
		}
		
		return header("Location: frm_view.php?subject_id=". $frmdata['subject_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	unset($forum->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
	$forum->subject_id = $_REQUEST['subject_id'];
	
	$output_subject = $forum->selSubject();
	
}
elseif (isset($_POST['delete_subject'])) {
	$forum->deleteSubject($forum->subject_id);
	
	return header("Location: frm_view.php?" . strip_tags(SID));
	exit;
}
elseif (isset($frmdata['group_options'])) {
	if ($frmdata['group_options'] == "grp_view") {
		header("Location: grp_view.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "grp_structure") {
		header("Location: grp_structure.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "grp_membership") {
		header("Location: grp_membership.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "list_group") {
		header("Location: frm_view.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "add_group_subject") {
		header("Location: frm_edit.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "add_group_topic") {
		header("Location: frm_edit.php?add_topic=1&group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($frmdata['options'])&& $frmdata['options'] != "list_node") {
	if ($frmdata['options'] == "list_my") {
		//get my blogs
		unset($forum->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$forum->file = $file;
		$forum->include_hidden=1;
		$forum->user_id = $me['user_id'];
		unset($forum->topic_id);
		
		$output_subjects = $forum->selSubjects();
	}
	elseif ($frmdata['options'] == "list_marked") {
		//get my marked blogs
		unset($forum->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$forum->file = $file;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
		$watched_subject_ids = $bookmark->getBookmarks();
		
		$forum->user_id = $me['user_id'];
		
		if (!empty($watched_subject_ids)) {
			$forum->subject_ids = $watched_subject_ids;
			$output_subjects = $forum->selSubjects();
		}
	}
	elseif ($frmdata['options'] == "list_relation_tips") {
		//get my relations tipped subjects
		unset($forum->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$forum->file = $file;
		
		unset($bookmark->user_id);
		foreach($_SESSION['relations'] as $key => $i):
			$bookmark->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
		$recommended_subject_ids = $bookmark->getBookmarks();
		
		if (!empty($recommended_subject_ids)) {
			$forum->subject_ids = $recommended_subject_ids;
			$output_subjects = $forum->selSubjects();
		}
		
	}
	elseif ($frmdata['options'] == "subject_edit") {
		//edit this item
		header("Location: frm_edit.php?subject_id=" . $frmdata['subject_id'] . "&". strip_tags(SID));
	}
	elseif ($frmdata['options'] == "subject_add") {
		//add an item
		if (isset($_REQUEST['topic_id'])) {
			header("Location: frm_edit.php?topic_id=" . $_REQUEST['topic_id'] . "&add_subject=1&". strip_tags(SID));
			exit;
		}
		else {
			header("Location: frm_edit.php?add_subject=1&". strip_tags(SID));
			exit;
		}
	}
	elseif ($frmdata['options'] == "topic_edit") {
		//edit this item
		header("Location: frm_edit.php?topic_id=" . $frmdata['topic_id'] . "&". strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "topic_add") {
		//add an item
		header("Location: frm_edit.php?add_topic=1&". strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "item_mark") {
		//mark this item
		$bookmark->item_id = $frmdata['subject_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->insertBookmark();
		
		header("Location: frm_view.php?subject_id=" . $frmdata['subject_id'] . "&". strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "item_tip") {
		//tip this item
		$bookmark->item_id = $frmdata['subject_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
		
		header("Location: frm_view.php?subject_id=" . $frmdata['subject_id'] . "&". strip_tags(SID));
		exit;
	}
	
}
elseif (isset($_REQUEST['topic_id']) && $_REQUEST['topic_id'] > 0 && (!isset($frmdata['options']) || $frmdata['options'] != "list_node")) {
    unset($forum->rsp_level_id);
	$forum->topic = $_REQUEST['topic_id'];
	$output_topic = $forum->selTopic();
	
	if (!empty($output_topic['group_id'])) {
		$group_id = $output_topic['group_id'];
		include_once ('inc/header_group.inc.php');
		require_once($languagePath . 'grp_common.lang.php');
		$forum->group_id = $output_topic['group_id'];
	}
	
	$output_topic_roles = $forum->selTopicRoles();
	$output_subjects = $forum->selSubjects();
	$output_sidebar_topics = $forum->selTopics();
	
	//check to see if we can add a subject
	if (!empty($output_topic_roles)) {
		foreach($output_topic_roles as $key => $tr):
			if ($tr['role_id'] == $me['role_id']) {
				$output_topic['add_subject'] = 1;
				break;
			}
		endforeach;
	}
}
elseif (isset($_REQUEST['subject_id']) && $_REQUEST['subject_id'] > 0 && (!isset($frmdata['options']) || $frmdata['options'] != "list_node")) {
	//get subject
	unset($forum->rsp_level_id);
	$output_subject = $forum->selSubject();
	
	$forum->topic_id = $output_subject['topic_id'];
	$output_topic = $forum->selTopic();
	
	$output_sidebar_topics = $forum->selTopics();
	
}
elseif (isset($_REQUEST['group_id'])) {
	include_once ('inc/header_group.inc.php');
	require_once($languagePath . 'grp_common.lang.php');
	$forum->group_id = $_REQUEST['group_id'];
	
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$forum->file = $file;
	
	unset($forum->topic_id);
	$forum->limit=10;
	$forum->order_by = "s.subject_create_datetime desc";
	$output_subjects = $forum->selSubjects();
	
	// get comments --------------------------------------------------------
	unset($comment->user_id);
	$comment->group_id = $_REQUEST['group_id'];
	$comment->limit = 10;
	$comment->orderby = "c.comment_create_datetime desc";
	$output_comments = $comment->selComments();
	
	
	$output_sidebar_topics = $forum->selTopics();
	
	$display = "latest";
	
}
else { //overview
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$forum->file = $file;
	unset($forum->topic_id);
	$forum->limit=10;
	$forum->order_by = "s.subject_create_datetime desc";
	$output_subjects = $forum->selSubjects();
	
	
	// get comments --------------------------------------------------------
	unset($comment->user_id);
	$comment->limit = 10;
	$comment->orderby = "c.comment_create_datetime desc";
	$output_comments = $comment->selComments();
	
	
	$output_sidebar_topics = $forum->selTopics();
	
	$display = "latest";
}


	
// CHECK PERMISSION TO VIEW SUBJECT ------------------------------------------
if (!empty($output_subject)) {
	// Are we allowed to see this blog?
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	require_once('class/Rsp.class.php');
	$rsp = new Rsp($db, $c_node['rsp']['item_type']['forum']);
	$output_subject['rsp'] = $rsp->selRspItem($output_subject['subject_id']);
	
	if (!empty($output_subject['group_id'])) {
		// we check that I am in the group and that I have permissions to view
		$group_id = $output_subject['group_id'];
		include_once ('inc/header_group.inc.php');
		require_once($languagePath . 'grp_common.lang.php');
		
		if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['forum'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
			header("Location: grp_membership.php?group_id=" . $output_blog['group_id'] . "&". strip_tags(SID));
			exit;
		}
		
		$forum->group_id = $output_subject['group_id'];
		
		$allow_view = 1;
	}
	elseif (isset($me['user_id']) && $me['user_id'] == $output_subject['user_id']) {
		// is the author me?
		$allow_view = 1;
	}
	
	if (!isset($allow_view) && !empty($output_subject['rsp'])) {
		// is the item published to node or public and can I see it?
		foreach ($output_subject['rsp'] as $key => $i):
			if ($i['level_id'] == $rsp_level_id) {
				$allow_view = 1;
				break;
			}
			
			// is it set to network and ar they in my network?
			if (!empty($i['degree_id'])) {
				foreach($_SESSION['relations'] as $key => $r):
					if ($output_subject['user_id'] == $r['user_id_relation']) {
						$allow_view = 1;
						break;
					}
					
					if (isset($allow_view)) {
						break;
					}
				endforeach;
			}
		endforeach;
	}
	
	if (!isset($allow_view)) {
		unset($output_subject);
	}
}


if (isset($output_subject)) {
	//get the group and/or the author
	$user->user_id = $output_subject['user_id'];
	$output_author = $user->selProfile();
	
	$output_subject['display_subject_body'] = $wiki->transform($output_subject['subject_body'], 'Xhtml');
	
	// GET BOOKMARK --------------------------------------------------
	if (isset($bookmark)) {
		$bookmark->item_id = $output_subject['subject_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_subject['bookmark']['watch'] = 1;
		}
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_subject['bookmark']['recommend'] = 1;
		}
	}
	
	//get comments
	unset($comment->user_id);
	if (!empty($output_subject['group_id'])) {
		$comment->group_id = $output_subject['group_id'];
	}
	$output_comments = $comment->selComments($forum->subject_id);
	
	
	//get subject image
	if (isset($output_subject['file_id'])) {
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		$file->file_id = $output_subject['file_id'];
		$output_subject['image'] = $file->getFileRecord();
	}
	
	
	//get tags
	$tag->item_id = $forum->subject_id;
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_item_tags = $tag->selTags(1);
}



//move to template
if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
	$body->set('rsp_config', $c_node['rsp']);
}                                 

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);  
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);  
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_topic)) {
    $body->set('topic', $output_topic);
}

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}

if (!empty($output_sidebar_topics)) {
	$body->set('sidebar_topics', $output_sidebar_topics);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_topic_roles)) {
    $body->set('topic_roles', $output_topic_roles);
}

if (isset($output_subject['subject_id'])) {
	$template_pageLinkNote = $output_subject['subject_title'];

	//setup print options
	$tpl->set('toolbar_print', 'print_item.php?subject_id=' . $output_subject['subject_id']);
	$tpl->set('toolbar_printc', 'print_item.php?subject_id=' . $output_subject['subject_id'] . '&amp;inc_comment=1');
	$tpl->set('toolbar_bookmark_url', 'frm_item.php?subject_id=' . $output_subject['subject_id']);
}

$template_pageLink = $lang['txt_forum'];

include "inc/footer.inc.php";

?>
