<?php
// -----------------------------------------------------------------------
// This file is part of beacon
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

session_start();
include "config/config_aroundme.inc.php";
include "inc/functions.inc.php";

// SETUP LOGGING ---------------------------------------------------
$GLOBALS['am_log'] = $c_node['log'];


// SETUP DATABASE ----------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


// SETUP NEWSLETTER -------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Newsletter.class.php');
$nl = new Newsletter($db, $c_node['newsletter']);
$nl->user_status_ids = $c_node['user']['status'];


// SETUP MAIL -------------------------------------------------------------
require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
$mail = new PHPMailer();
$mail->Host = 		$c_node['mail']['host'];
$mail->Mailer = 	$c_node['mail']['mailer'];

if (isset($c_node['mail']['smtp']['username'])) {
	$mail->SMTPAuth = true;
	$mail->Username = $c_node['mail']['smtp']['username'];
	$mail->Password = $c_node['mail']['smtp']['password'];
}

$mail->language = 	$c_node['mail']['language'];
$mail->From = 		$c_node['mail']['no_reply_address'];
$mail->FromName = 	$c_node['mail']['from_name'];
$mail->WordWrap = 	$c_node['mail']['wordwrap'];
$mail->Priority = 			3;
$mail->Encoding = 			"8bit";
$mail->CharSet = 			"iso-8859-1";
$mail->SMTPKeepAlive =      true;
$mail->IsHTML(true);

$nl->mail = $mail;

$nl->bulk = $c_node['cron']['bulk_email'];

if (isset($_SESSION['s_newsletter_id'])) {
	echo "HH";
	exit;
	$nl->sendNewsletter($_SESSION['s_newsletter_id']);
}
else {
	$nl->sendNewsletter();
}

?>