<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}

//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');


if (isset($_POST['send_newsletter'])) {

	$data = $_POST["data"];  // get the data from the from

	//to, language_id, message, subject
	$query = "INSERT INTO ".$db->prefix."_newsletter SET 
		from_user_id=".$me["user_id"].", 
		to_type_id=".$data["to"].", 
		message_subject='".$data["subject"]."', 
		message_body='".$data["message"]."',
		message_create_datetime=".$db->DBTimeStamp(mktime()).", 
		language_id='".$data["language_id"]."', 
		item_type='".$c_node['newsletter']['type']['node']."',
		item_type_id='0',
		start_id='0'";
	
	$result = $db->Execute($query);
	
	if(!isset($result)){
		$GLOBALS['am_error_log'][] = array(1, 1, $db->ErrorMsg()); // insertion problem into the table
	}
	else{
		//send newsletter
		if(empty($c_node["cron"]["bulk_mail"])){
			//move to send email directly 
			$query = "SELECT message_id FROM ".$db->prefix."_newsletter WHERE
				from_user_id=".$me["user_id"]." AND 
				to_type_id=".$data["to"]." AND 
				message_subject='".$data["subject"]."' AND 
				message_body='".$data["message"]."' AND 
				message_create_datetime=".$db->DBTimeStamp(mktime())." AND  
				language_id='".$data["language_id"]."' AND  
				item_type='".$c_node['newsletter']['type']['node']."' AND 
				item_type_id='0' AND 
				start_id='0'";
	
			$result = $db->Execute($query);
			unset($_SESSION["s_newsletter_id"]);
			$_SESSION["s_newsletter_id"] = $result->fields["message_id"];           // Very tricky as it is not fullproof. We must warn non-cron users
			header("Location: send_newsletter.php");                   // move to send mode
			exit;
		}
		
	}
}



//move to template
if (isset($total_emails_sent)) {
    $body->set('total_emails_sent', $total_emails_sent);
}

$body->set('language_id', $me['language_id']);

$body->set('total_members', getCountUsers(2));
$body->set('total_pending_members', getCountUsers(1));
$body->set('total_invited', getCountUsers());

include "inc/footer.inc.php";




/*
* sendInvite
* Tom Calthrop 7th April 2004
*/
function sendNewsletter($data) {

	global $db, $mail;

	$total_emails_sent = 0;
	
	//get the email addresses and firstnames
	if (isset($data['to']) && $data['to'] > 0) {
		//"to" level - 1=pending, 2=member - 
		$query = "
			SELECT u.user_firstname, u.user_email 
			FROM  " . $db->prefix . "_user u 
			WHERE 
			u.language_id=". $data['language_id'] . " and 
			u.status_id=". $data['to']
		;
	}
	else {
		//if not 1 or 2 we go to the invite table
		$query = "
			SELECT u.invited_email 
			FROM " . $db->prefix . "_user_invited u "
		;
	}
	
	//echo $query;
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		while (!$result->EOF) {
			//format message
			if (isset($data['to']) && $data['to'] > 0) {
				$message = str_replace("FIRSTNAME", $result->fields['user_firstname'], $data['message']);
			}
			else {
				$message = $data['message'];
			}
			
			$mail->Body = $message;
			$mail->ClearAddresses();
			$mail->AddAddress($result->fields['user_email'], '');

			if(!$mail->Send()) {
				$GLOBALS['am_error_log'][] = array(18, null, $mail->ErrorInfo); //Mailer Error
			}
			else {
				$total_emails_sent++;
			}
			
			$result->MoveNext();
		}

		$result->Close();
	}
	else {
		$error_info = "node_newsletter.php -- " . $query . " -- " . $db->ErrorMsg();
		$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
	}

}//EO sendNewsletter();


/*
* sendInvite
* Tom Calthrop 7th April 2004
*/
function getCountUsers($lock_id = null) {

	global $db;
	
	//get the email addresses and firstnames
	if (isset($lock_id) && $lock_id > 0) {
		//"to" level - 1=pending, 2=member - 
		$query = "
			SELECT count(user_id) as total  
			FROM " . $db->prefix . "_user 
			WHERE 
			status_id=". $lock_id
		;
	}
	else {
		//if not 1 or 2 we go to the invite table
		$query = "
			SELECT count(invited_email) as total 
			FROM " . $db->prefix . "_user_invited"
		;
	}
	//echo $query;
	$result = $db->Execute($query);
	
	$total = 0;
	
	if (isset($result)) {
		$total = $result->fields['total'];
	}
	
	return $total;
}

?>
