<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";

require_once($c_node['dir']['class_path'] . 'Blog.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');

//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


if (isset($_REQUEST['blog_id'])) {
	$blog_id = $_REQUEST['blog_id'];
}


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif


//setup blog
$blog = new Blog($db, $c_acs['arr_section']['user'], $date, $file);
$blog->user_id = $user_id;


//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');



if (isset($_POST['edit_blog']) || isset($_REQUEST['add_blog'])) {
	//get images
	$output_images = $file->getFiles();
}


if (isset($data)) {//post data received


	$data['blog_body'] = stripslashes($data['blog_body']);
	$data['blog_body_display'] = $wiki->transform($data['blog_body'], 'Xhtml');

	$data['blog_synopsis'] = stripslashes(htmlspecialchars($data['blog_synopsis']));

	$data['blog_title'] = stripslashes(htmlspecialchars($data['blog_title']));
	
	if (isset($_POST['preview_blog'])) {
		$data['blog_body'] = htmlspecialchars($data['blog_body']);

		$output_blog = $data;

		$display = "preview_blog";
	}
	elseif (isset($_POST['edit_blog_again'])) {
		$output_blog = $data;

		$display = "add_blog";

	}
	elseif (isset($_POST['insert_blog'])) {
		$blog->section_item_id = $me['user_id'];
		
		if (isset($data['degree_id']) && $data['degree_id'] == "level") {
		    $data['degree_id'] = null;
		}
		
		if (!empty($data['level_id_public'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['public'];
		}
		elseif (!empty($data['level_id_node'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['node'];
		}
		else {
			$data['level_id'] = null;
		}
		
		$blog->insertBlog($data);

		if (empty($GLOBALS['am_error_log'])) {
			if (!empty($data['level_id'])) {
				//setup cms
				require_once($c_node['dir']['class_path'] . 'Cms.class.php');
				$cms = new Cms($db, $c_acs['arr_section']['user']);
				$cms->section_item_id = $me['user_id'];
				$cms->cms_item_type_id = $c_node['cms']['item_type']['user_blog'];
				$cms->user_id = $me['user_id'];
				$temp['language_id'] = $me['language_id'];
				$temp['item_id'] = $blog->blog_id;
				$temp['genre_id'] = $data['genre_id'];
				
				//insert node cms entry
			
			   	if($c_node['cms']['node']['auto_publish'] == 1) {
					$temp['status_id'] = $c_node['cms']['status']['live'];
				}
				else {
					$temp['status_id'] = $c_node['cms']['status']['pending'];
				}
				
				if (!empty($data['level_id_node'])) {
				    $temp['level_id'] = $c_node['cms']['cms_level']['node'];
					$cms->insertCmsItem($temp);
				}
				
				if (!empty($data['level_id_public'])) {
				    $temp['level_id'] = $c_node['cms']['cms_level']['public'];
					$cms->insertCmsItem($temp);
				}
			}
		
			//setup statistics
			require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
			$statistic = new Statistic($db, $c_acs['arr_section']['user'], $date);
			
			//update stats
			$statistic->section_item_id = $user_id;
			$statistic->statistic_type_id = $c_node['statistic']['user']['total_blogs'];
			$blog->section_item_id = $user_id;
			$statistic->setStatistic($blog->getBlogCount());
		
			header("Location: my_blog.php?blog_id=" . $blog->blog_id . "&" . SID);
			exit;
		}
		else {
		    $output_blog = $data;

			$display = "add_blog";
		}
	}
	elseif (isset($_POST['update_blog'])) {
		
		if (isset($data['degree_id']) && $data['degree_id'] == "level") {
		    $data['degree_id'] = null;
		}
		
		if (!empty($data['level_id_public'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['public'];
		}
		elseif (!empty($data['level_id_node'])) {
			$data['level_id'] = $c_node['cms']['cms_level']['node'];
		}
		else {
			$data['level_id'] = null;
		}
		
		$blog->updateBlog($data);

		if (empty($GLOBALS['am_error_log'])) {
			header("Location: my_blog.php?blog_id=" . $data['blog_id'] . "&" . SID);
			exit;
		}
		else {
			$output_blog = $data;

			$display = "add_blog";
		}
	}

}
elseif (isset($_POST['edit_blog'])) {
		$blog->blog_id = $blog_id;
		$output_blog = $blog->getBlog();

		$display = "add_blog";

}
elseif (isset($_REQUEST['add_blog'])) {

		$display = "add_blog";

}
elseif (isset($_REQUEST['delete_blog'])) {
		
		$blog->deleteBlogs(array($blog_id));

		header("Location: my_blog.php?" . SID);
		exit;

}
elseif (isset($blog_id)) {//if we have a blog id we retrieve it
    $blog->blog_id = $blog_id;
	$output_blog = $blog->getBlog();
	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');

	
	//setup comment
	require_once($c_node['dir']['class_path'] . 'Comment.class.php');
	$comment = new Comment($db, $c_node['cms']['item_type']['user_blog'], $date);
	$comment->item_id = $blog_id;
	
	$output_comments = $comment->getComments();
	
	$display = "view_blog";
}
else {
	$blog->file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$blog->file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	unset($blog->user_id);
	$blog->section_item_id = $me['user_id'];
	$output_blogs = $blog->getBlogs();

	$display = "list_blogs";
}

$output_user['language_ids'] = $me['language_ids'];


//move vars to template
if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('level_node', $c_node['cms']['cms_level']['node']);
$body->set('level_public', $c_node['cms']['cms_level']['public']);

include "inc/footer.inc.php";

?>
