<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";
require_once($c_node['dir']['class_path'] . 'Statistic.class.php');




if (isset($_POST['user_pending'])) {
	$group->node_id = $c_node['node']['node_id'];
	$role_default = $group_acs->getGroupRole(1);
	$group->member_status_id = $c_node['group']['member_status']['pending'];
	$group->insertMembership($data['profile_id'], $role_default['role_id']);
	
	//get members with a priviledge of "edit" set against the resource "group memebership"
	$group_roles = $group_acs->getGroupRoles();
	if (!empty($group_roles)) {
	    foreach($group_roles as $i):
			if($group_acs->getPermission($i['role_id'], $c_acs['arr_acs']['resource']['group_membership'], $c_acs['arr_acs']['privilege']['allow_edit'])) {
				$group_roles_membership_edit[] = $i['role_id'];
			}
		endforeach;
	}
	$group->role_ids = $group_roles_membership_edit;
	$members_with_edit = $group->getMembers();
	
	//send IM to admin about application
	$body_txt = readTxtFile($languageTextPath . "im_group_membership_apply.txt.php");
	$body_txt = str_replace("ID_OF_GROUP", $group_id, $body_txt);
	
	if (!empty($members_with_edit)) {
	    foreach($members_with_edit as $i):
			$im->sendMessage($i['user_id'], $lang['txt_apply_im_subject'], $body_txt);
		endforeach;
	}
	
	header("Location: g_apply.php?group_id=" . $group_id . "&" . SID);
	exit;
}
elseif (isset($_POST['user_member'])) {
	$group->node_id = $c_node['node']['node_id'];
	$role_default = $group_acs->getGroupRole(1);
	$group->member_status_id = $c_node['group']['member_status']['active'];
	$group->insertMembership($data['profile_id'], $role_default['role_id']);
	
	//setup statistics
	$statistic = new Statistic($db, $c_acs['arr_section']['group'], $date);
	$statistic->section_item_id = $group_id;
	$statistic->statistic_type_id = $c_node['statistic']['group']['total_members'];
	//reset the statistics
	$total_active_members = $group->getCountMembers();
	$statistic->setStatistic($total_active_members);
	
	header("Location: g_group.php?group_id=" . $group_id . "&" . SID);
	exit;
}


//check the group status is active
if ($output_group['status_id'] == $c_node['group']['status']['active']) {
	
	//append language setup
	require_once($languageTextPath . 'node_rules.lang.php');
	require_once($languageArrayPath . 'arr_group.lang.php');


	//check the group members status
  	if (isset($output_group['member']['status_id']) && $output_group['member']['status_id'] == $c_node['group']['member_status']['pending']) {
		$display = "group_application_in_progress";
	}
	elseif (isset($output_group['member']['status_id']) && $output_group['member']['status_id'] == $c_node['group']['member_status']['active']) {
		header("Location: g_group.php?group_id=" . $group_id . "&" . SID);
		exit;
	}
	elseif (empty($output_group['member']['status_id'])) {
		
		if ($output_group['group_visibility'] == 1) { //check if the group is not hidden
			//check the registration type
			if ($output_group['group_registration_type'] == $c_node['group']['registration_type']['automatic']) {
				$display = "group_apply_automatic";
			}
			elseif ($output_group['group_registration_type'] == $c_node['group']['registration_type']['approved']) {
				$display = "group_apply_approved";
			}
		}
	}
} // if we end up with no $display set we will display a polite "group unavailable" message

	  
if (isset($display)) { //get the profile dropdown
	unset($user->file);
	$user->user_id = $me['user_id'];
    $user_profiles = $user->getProfiles();
}


$lang['txt_node_rules'] = nl2br($lang['txt_node_rules']);


//move to template
if (!empty($user_profiles)) {
	$body->set('profiles', $user_profiles);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($display)) {
	$body->set('display', $display);
}

include "inc/footer.inc.php";

?>
