<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_activity.lang.php');


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_activity'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $group_id."&".SID);
	exit;
}

if (isset($_REQUEST['activity_id'])) {
    $activity_id = $_REQUEST['activity_id'];
}
else {
	header("Location: g_calendar.php?group_id=" . $group_id . "&amp;".SID);
	exit;
}

if (isset($_REQUEST['task_id'])) {
    $task_id = $_REQUEST['task_id'];
}

//append language setup
require_once($languageArrayPath . 'arr_activity.lang.php');
require_once($languageArrayPath . 'arr_task_user_status.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');


//setup activity
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->section_item_id = $group_id;
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];
$activity->activity_id = $activity_id;


if (isset($_POST['insert_task'])) {
	$activity->user_id = $user_id;
	$activity->insertTask($data);
	
	if (empty($GLOBALS['am_error_log'])) {
		//setup cms
		require_once($c_node['dir']['class_path'] . 'Cms.class.php');
		$cms = new Cms($db, $c_acs['arr_section']['group']);
		$cms->section_item_id = $group_id;
		$cms->cms_item_type_id = $c_node['cms']['item_type']['group_task'];
		$cms->user_id = $user_id;
		$temp['language_id'] = $output_group['language_id'];
		$temp['genre_id'] = $output_group['genre_id'];
		$temp['item_id'] = $activity->task_id;
		
		//insert node cms entry
		if (isset($data['cms_node'])) {
			$temp['level_id'] = $c_node['cms']['cms_level']['group']['home'];
		
		   	if($c_node['cms']['node']['auto_publish'] == 1) {
				$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
			
			$cms->insertCmsItem($temp);
		}
		
		//insert group cms entry
		if (isset($data['cms_group'])) {
		    $temp['level_id'] = $c_node['cms']['cms_level']['node'];
			
			if ($group['group_cms_auto_publish'] == 1) {
		    	$temp['status_id'] = $c_node['cms']['status']['live'];
			}
			else {
				$temp['status_id'] = $c_node['cms']['status']['pending'];
			}
			
			$cms->insertCmsItem($temp);
		}
		header("Location: g_activity.php?group_id=" . $group_id . "&activity_id=" . $activity_id . "&amp;".SID);
		exit;
	}
	else {
		$output_task = $data;
	}
}
elseif (isset($_POST['update_task'])) {
	$data['task_id'] = $task_id;
	
	$activity->updateTask($data);

	if (empty($GLOBALS['am_error_log'])) {
		header("Location: g_activity.php?group_id=" . $group_id . "&activity_id=" . $activity_id . "&amp;".SID);
		exit;
	}
}
elseif (isset($_POST['delete_task'])) {
	$activity->deleteTask($task_id);

	if (empty($GLOBALS['am_error_log'])) {
		header("Location: g_activity.php?group_id=" . $group_id . "&activity_id=" . $activity_id . "&amp;".SID);
		exit;
	}
}
elseif (isset($_POST['update_user_tasks']) && isset($data['user_id'])) {
	$activity->updateTaskApplicants($task_id, $data['user_id'], $data['status_id']);
	
	if (empty($GLOBALS['am_error_log'])) {
		header("Location: g_activity_task_edit.php?group_id=" . $group_id . "&activity_id=" . $activity_id . "&task_id=" . $task_id . "&".SID);
		exit;
	}
}
elseif (isset($_REQUEST['edit_task'])) {
	$output_task = $activity->getTask($task_id);
	$output_task['activity_id'] = $activity_id;
	
	$display = "edit_task"; //edit the task
}
elseif (isset($task_id)) {
	$output_task = $activity->getTask($task_id);
	$output_task_applicants = $activity->getTaskApplicants($task_id);
	//check if we can edit
	$allow_task_edit = true;
	if (isset($output_task_applicants)) {
		foreach($output_task_applicants as $key => $i):
			if ($i['status_id'] == $c_node['activity']['task_user_status']['confirmed'] || $i['status_id'] == $c_node['activity']['task_user_status']['pending']) {
				$allow_task_edit = false;
				break;
			}
		endforeach;
	}
						
}
else {
	$output_task['activity_id'] = $activity_id;
	
	$display = "edit_task"; //adds a task
}




//move to template
if (!empty($output_activity)) {
   $body->set('activity', $output_activity);
}

if (!empty($output_task_applicants)) {
   $body->set('task_applicants', $output_task_applicants);
}

if (!empty($output_task)) {
   $body->set('task', $output_task);
}

if (isset($display)) {
   $body->set('display', $display);
}

if (!empty($output_task['task_start_datetime'])) {
   $body->set('start_datedropdown', $date->dateDropdown($output_task['task_start_datetime'], 1, 'start', 10, 20));
}
else {
   $body->set('start_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'start', 10, 20));
}

if (!empty($output_task['task_end_datetime'])) {
   $body->set('end_datedropdown', $date->dateDropdown($output_task['task_end_datetime'], 1, 'end', 10, 20));
}
else {
   $body->set('end_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'end', 10, 20));
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($allow_task_edit)) {
	$body->set('allow_task_edit', $allow_task_edit);
}

$body->set('cms_node_auto_publish', $c_node['cms']['node']['auto_publish']);

$body->set('task_user_status_ids', $c_node['activity']['task_user_status']);

include "inc/footer.inc.php";

?>
