<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

//Note setlocale(); is set in the User.class.php at login this will affect date output.

class Date {
	// CLASS FUNCTIONS
	// Date
	// formatDate
	// dateDropdown
	// getMonthString
	// getMonthTime
	// getDayString
	// getDayTime
	// getToday


	// Date --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 19th April 2004
	//
	function Date() {
		//no setup required
	}
	
	
	
	// formatDate --------------------------------------------------------------------
	// Set the format of the date based on the style requested.
	// tom calthrop - 19th April 2004
	//
	function formatDate($datetime, $style = null)  {
		if (isset($datetime) && $datetime != "0000-00-00 00:00:00") {

			$y = substr($datetime,0,4);
			$m = substr($datetime,5,2);
			$d = substr($datetime,8,2);
			$h = substr($datetime,11,2);
			$i = substr($datetime,14,2);

			if (isset($style)) {
			    if ($style == 1) {
			        $datetime = date("M-d-Y H:i", mktime($h,$i,0, $m, $d, $y));
			    }
				elseif ($style == 2) {
			        $datetime = date("M-d", mktime(0,0,0, $m, $d, $y));
			    }

			}
			else {
				//default datetime format
				$datetime = date("M-d-Y", mktime(0,0,0, $m, $d, $y));
			}

			return $datetime;
		}
	}//EO formatDate

	
	
	// dateDropdown --------------------------------------------------------------------
	// if $showtime is set we show time as well
	// tom calthrop - 19th April 2004
	//
	function dateDropdown ($current = null, $showtime = null, $prefix = null, $minus_year = null, $years = null, $special = null) {

		if (isset($prefix)) {
		    $prefix = $prefix . "_";
		}
		else {
		    $prefix = "";
		}

		$date  = date('Y-m-d h:i:s');
		$year  = substr($date, 0,4);
		$month = substr($date, 5,2);
		$day   = substr($date, 8,2);

		$current_year = substr($current, 0,4);
		$current_month = substr($current, 5,2);
		$current_day = substr($current, 8,2);

		if (isset($showtime)) {
		    $hr   = substr($date, 11,2);
			$min   = substr($date, 14,2);

			$current_hr = substr($current, 11,2);
			$current_min = substr($current, 14,2);
		}

		//get the start year
		if (isset($minus_year)) {
		    $value = $year - $minus_year;
		}
		else {
			$value = 1900;
		}

		//get the number of years shown
		if (isset($years)) {
		    $year = $value + $years;
		}


		if(empty($special)) {
			$output = "<select name='" . $prefix . "year' class='formInput'>";
			//while($value<=$year)
			for($i = $value; $i<=$year; $i++)
			{
				$selected = "";

				if ($current_year == $i) {
					$selected = " selected";
				}


				$output .= "<option value=" . $i . $selected . ">" . $i;
				unset ($selected);
				//$value++;
			}
			$output .= "</select>&nbsp;";

			$output .= "<select name='" . $prefix . "month' class='formInput'>";
		}
		else
			$output = "<select name='" . $prefix . "month' class='formInput'>";

		for($i=1; $i<=12; $i++)
		{
			$selected = "";

			if ($current_month == $i) {
			    $selected = " selected";
			}

			if($i<10)
				$value = "0".$i;
			else
				$value = $i;

			$output .= "<option value=" . $value . $selected . ">" . $value;
			unset ($selected);
		}
		$output .= "</select>&nbsp;";

		if(!empty($special) & $special==9)
			$output = "<select name='" . $prefix . "day' class='formInput'>";
		else
			$output .= "<select name='" . $prefix . "day' class='formInput'>";

		for($i=1; $i<=31; $i++)
		{
			$selected = "";

			if ($current_day == $i) {
			    $selected = " selected";
			}

			if($i<10)
				$value = "0".$i;
			else
				$value = $i;
			$output .= "<option value=" . $value . $selected . ">" . $value;
			unset ($selected);

		}
		$output .= "</select>&nbsp;";

		if (isset($showtime) & empty($special)) {
			$output .= "<select name='" . $prefix . "hour' class='formInput'>";
			for($i=0; $i<=23; $i++)
			{
				$selected = "";

				if ($current_hr == $i) {
				    $selected = " selected";
				}

				if($i<10)
					$value = "0".$i;
				else
					$value = $i;

				$output .= "<option value=" . $value . $selected . ">" . $value;
				unset ($selected);
			}
			$output .= "</select>&nbsp;";

			$output .= "<select name='" . $prefix . "minute' class='formInput'>";
			for($i=0; $i<=59; $i++)
			{
				$selected = "";

				if ($current_min == $i) {
				    $selected = " selected";
				}

				if($i<10)
					$value = "0".$i;
				else
					$value = $i;

				$output .= "<option value=" . $value . $selected . ">" . $value;
				unset ($selected);
			}
			$output .= "</select>&nbsp;";

		}


		return $output;
	}//EO dateDropdown
	
	
	
	// getMonthString --------------------------------------------------------------------
	// tom calthrop - 19th April 2004
	//
	function getMonthString($time) {
		return date("F Y", $time);
	}// getMonthString
	
	
	
	// getMonthTime --------------------------------------------------------------------
	// tom calthrop - 19th April 2004
	//
	function getMonthTime($time, $shift) {
		$d = date("d", $time);
		$m = date("m", $time)+$shift;
		$y = date("Y", $time);

		if(date("m", $time)+$shift<1)
		{
			$m = 12;
			$y = date("Y", $time)-1;
		}


		$time = mktime(0, 0, 0, $m, $d,  $y);

		return $time;
	}//EO getMonthTime
	
	
	
	// getDayString --------------------------------------------------------------------
	// tom calthrop - 19th April 2004
	//
	function getDayString($time, $shift="") {
		if(!empty($shift))
			$time = strtotime("$shift day", $time);
		return date("l F d", $time);
	}//EO getDayString
	
	
	
	// getDayTime --------------------------------------------------------------------
	// tom calthrop - 19th April 2004
	//
	function getDayTime($time, $shift) {
		$da = date("d", $time);
		$mo = date("m", $time);
		$yr = date("Y", $time);
		$hr = date("G", $time);
		$mi = date("i", $time);
		$se = date("s", $time);

		$time = strtotime("$shift day", mktime($hr, $mi, $se, $mo, $da,  $yr));

		return $time;
	}//EO getDayTime
	
	
	
	// getToday --------------------------------------------------------------------
	// used in the top of the template to display todays date
	// tom calthrop - 19th April 2004
	//
	function getToday() {
		$today  = date('Y-m-d');

		return $today;
	}//EO getToday
}
