<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}

//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');


//setup group admin class
require_once($c_node['dir']['class_path'] . 'GroupAdmin.class.php');
$groupadm = new GroupAdmin($db, $me);
$groupadm->date = $date;
$groupadm->member_status_id = $c_node['group']['member_status']['active'];


//setup group class
require_once($c_node['dir']['class_path'] . 'Group.class.php');
$group = new Group($db, $date);
$group->user_id = $me['user_id'];
$group->registration_types = $c_node['group']['registration_type'];


//process requests
if (isset($_POST['update_group'])) {
	$data['group_file_allocation'] = $data['group_file_allocation']*1000;
	$groupadm->group_id = $data['group_id'];
	$groupadm->updateAdminGroup($data);
	
	if (empty($groupadm->log)) {
		return header("Location: node_group.php?group_id=" . $data['group_id'] . "&amp;" . SID);
		exit;
	}
	
	
}
elseif (isset($_REQUEST['edit_group'])) {
	$group->group_id = $_REQUEST['group_id'];
	$output_group = $group->getGroup();
	
	$display = "edit_group";
}
elseif (isset($_REQUEST['group_id'])) {
	$group->group_id = $_REQUEST['group_id'];
	$output_group = $group->getGroup();
	
	$display = "view_group";
}
else {
	$output_groups = $groupadm->getAllGroups();
}


//move to template
if (!empty($output_groups)) {
	$body->set('groups', $output_groups);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$body->set('datedropdown', $date->dateDropdown($output_group['group_election_date'], null,null, 10, 20));
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('today', date("Y-m-d"));

include "inc/footer.inc.php";

?>
