<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $output_group['group_id']."&amp;".SID);
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');


//wiki setup
$wiki =& new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', 'g_library.php?group_id=' . $group_id . '&page=');
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', 'g_library_edit.php?group_id=' . $group_id . '&page=');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'group/');


if (isset($_REQUEST['edit_group'])) {
	$display = "edit_group";
	
}
elseif (isset($_REQUEST['edit_group_rules'])) {
	$display = "edit_group_rules";

}
elseif (isset($_POST['update_group'])) {
	$data['group_title'] = htmlspecialchars($data['group_title']);
	$data['group_synopsis'] = htmlspecialchars($data['group_synopsis']);
	
	$group->updateGroup($data);
	
	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: g_group_edit.php?group_id=" . $group_id . "&amp;" . SID);
		exit;
	}
}
elseif (isset($_POST['delete_group'])) {
	$group->deleteGroup($group_id);
}
elseif (isset($_POST['update_group_rules'])) {

	$data['group_rules'] = htmlspecialchars($data['group_rules']);

	$group->updateGroupRules($data);

	if (empty($GLOBALS['am_error_log'])) {
		return header("Location: g_group_edit.php?group_id=" . $group_id . "&" . SID);
		exit;
	}
}
else {
	//display group
	$output_group['display_group_home_synopsis'] = $wiki->transform($output_group['group_home_synopsis'], 'Xhtml');
	

}


$output_user = $user->getUser($me['user_id']);

//move to template
if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('status_ids', $c_node['group']['status']);

$body->set('datedropdown', $date->dateDropdown($output_group['group_election_date'], null,null, 10, 20));

include "inc/footer.inc.php";

?>
