<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header.inc.php";
include $c_node['aroundme_dir'] . "inc/functions.inc.php";
include $c_node['aroundme_dir'] . "config/config_aroundme.inc.php";

//include error handling files from aroundme
$languagePath = $c_node['aroundme_dir'] . "language/" . $language_id . "/" . $c_node['template_default_name'];
$languageArrayPath = $languagePath . "/arrays/";
$languageTextPath = $languagePath . "/texts/";
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_error_success.lang.php');
require_once($languageTextPath . 'message.lang.php');


//database setup and connect
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection('mysql');
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//Date
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Date.class.php');
$date = new Date();


//set up user class and destroy any sessions
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'User/User.class.php');
$user = new User();
$user->date = $date;
$user->db= $db;


//form actions
if (isset($_POST['newpassword'])) {

	$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];

	$error = sendPassword($_POST['email'], $dob);

	if (isset($error) && !empty($error)) {
	    $display = "lost_pass";
	}
	else {
		$display = "sent_pass";
	}
}


//TEMPLATE
$body->set('language_available', $c_node['www_language_available']);

if (isset($error)) {
 	$tpl->set('error', $error);
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('datedropdown', $date->dateDropdown());

$pagename = "new password";
include "inc/footer.inc.php";



/*
* sendPassword
* Tom Calthrop 7th April 2004
*/
function sendPassword($email, $dob) {

	global $db, $c_node, $user, $language_id, $lang, $error, $languageTextPath;

	$query = "
		SELECT u.user_id, u.user_firstname, u.user_email
		FROM " . $db->prefix . "_user u
		where
		u.user_email='" . $email . "' and
		u.user_dob='" . $dob . "'"
	;

	//echo $query . "<br><br>";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = $result->fields;;

		$result->Close();
	}


	if (isset($temp['user_id'])) {

		//update the password and send email
		$password = $user->createPassword();
		$user->savePassword($password, $temp['user_email']);

		//get file to send
		$body_file = $languageTextPath . "send_new_password.txt.php";

		$handle = fopen($body_file, "rb");
		$body_file_txt = "";
		do {
		   $data = fread($handle, 8192);
		   if (strlen($data) == 0) {
		       break;
		   }
		   $body_file_txt .= $data;
		} while (true);
		fclose($handle);


		$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
		$body_file_txt = str_replace("FIRSTNAME", $temp['user_firstname'], $body_file_txt);
		$body_file_txt = str_replace("PASSWORD", $password, $body_file_txt);
		$url = "http://" . $_SERVER['HTTP_HOST'];
		
		if (dirname ($_SERVER['PHP_SELF']) != "/") {
		    $url .= dirname ($_SERVER['PHP_SELF']);
		}
		$body_file_txt = str_replace("URL", $url, $body_file_txt);


		//setup mail
		require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . '/Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->Host = 		$c_node['mail']['host'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		$mail->From = 		$c_node['mail']['no_reply_address'];
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$lang['txt_email_subject_new_pass'];
		$mail->AddReplyTo($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
		$mail->AddAddress($temp['user_email'], $temp['user_firstname']);
		$mail->Body = $body_file_txt;


		if(!$mail->Send()) {
			$error[] =  array('error', 23, "Mailer Error: " . $mail->ErrorInfo);
		}
		else {
			//Message has been sent

		}


	}
	else {
	    $error[] = array('error', 22);
	}


	if (isset($error)) {
	    return $error;
	}

} //EO sendPassword();

?>
