<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_user_statistics.lang.php');
require_once($languageArrayPath . 'arr_user_relation.lang.php');
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');


//block or unblock user
if (isset($_REQUEST['block'])) {
    $display = "block";
}
elseif (isset($_REQUEST['unblock'])) {
    $user_blocked = $sn->unblockUser($user_id, 'unblock');
}
elseif (isset($_POST['set_block'])) {
    $user_blocked = $sn->blockUser($user_id, $data['block_description']);

	//rebuild social network
	$user->total_login_stat_id = $c_node['user_statistic_type_id']['total_logins'];
	$user->stat_type_id_friends = $c_node['user_statistic_type_id']['total_friends'];
	$user->stat_type_id_aqaintances = $c_node['user_statistic_type_id']['total_aqaintances'];
	$_SESSION['s_social_network'] = $user->setSocialNetwork($me['user_id']);

	//refresh this page to show new status
	header("Location: sn_profile.php?user_id=" . $_POST['user_id']."&amp;".SID);
	exit;
}
else {
	if ($sn->getBlockStatus($user_id)) {
		$display = "blocked";
	}
}


//if in social network we show page else we show details
if ((isset($output_relationship) && $output_relationship['type'] > 0)) {
	//friend, aquaintance or me
	//user details
	if ($output_user['user_image_id']) {
		$output_user['image'] = $image->getImage($output_user['user_image_id'], 't1', 'user', $user_id);
	}
	else {
		$output_user['image']['image'] = "user/no_user_t1.gif";
		$output_user['image']['image_title'] = $lang['err_no_image'];
	}


	//setup social network
	$user->limit = 2;
	$user->orderby = "user_create_datetime desc";
	$output_friends = $user->getSocialNetwork($user_id);
	$output_statistic = $user->userStatistics($user_id);


	//setup guestbook
	$output_guestbooks = getGuestbooks($user_id);

	//setup published
	$output_publish_blog = getBlogs($user_id, $c_node['user_publish']['friends']);

}
else {
	//setup published
	$output_publish_blog = getBlogs($user_id, $c_node['user_publish']['all']);
}






//move to template
if (isset($output_guestbooks)) {
	$body->set('guestbooks', $output_guestbooks);
}

if (isset($output_user)) {
	$body->set('user', $output_user);
}

if (isset($output_relationship)) {
	$body->set('relationship', $output_relationship);
}

if (isset($output_publish_blog)) {
	$body->set('publish_blogs', $output_publish_blog);
}

if (isset($output_friends)) {
	$body->set('friends', $output_friends);
}

if (isset($output_statistic)) {
	$body->set('user_statistic', $output_statistic);
}

if (isset($user_blocked)) {
	$body->set('user_blocked', $user_blocked);
}

if (isset($display)) {
	$body->set('display', $display);
}

$template_pageLink =  $lang['txt_profile'];
$template_pageLinkNote = $lang['txt_profile'] . ": " . $output_user['user_nic'];

include "inc/footer.inc.php";



/*
* getGuestbooks
* Tom Calthrop 7th April 2004
*/
function getGuestbooks ($user_id) {

	global $db, $date, $log;

	$query = "
		SELECT g.*, u.user_nic
		FROM " . $db->prefix . "_guestbook g
		LEFT JOIN " . $db->prefix . "_user u on g.user_id=u.user_id
		WHERE g.user_id_guestbook=" . $user_id . "
		order by g.guestbook_create_datetime limit 2"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			//format date
			$temp1['guestbook_create_datetime'] = $date->formatDate($temp1['guestbook_create_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getGuestbooks();



/*
* getBlogs
* Tom Calthrop 7th April 2004
*/
function getBlogs ($user_id, $blog_publish) {

	global $db, $date, $log;

	$query = "
		SELECT b.blog_id, b.blog_title, b.blog_synopsis,
		b.blog_create_datetime, b.blog_total_views, b.genre_id
		FROM " . $db->prefix . "_blog b
		WHERE
		b.user_id=" . $user_id . " and
		b.blog_publish<=" . $blog_publish . "
		order by b.blog_create_datetime desc limit 2"
	;
	//echo $query . "<br><br>";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			//format date
			$temp1['blog_create_datetime'] = $date->formatDate($temp1['blog_create_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getBlogs();
?>
