<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "network";
include "inc/header.inc.php";


//setup language
require_once($languageTextPath . 'message.lang.php');


if (isset($_POST['send_invite'])) {
	//get my details
	$user_id = $me['user_id'];
	$user->user_id = $user_id;
	$output_user = $user->userDetails();

	//setup email
	require_once($c_node['class_dir'] . '/Mail/class.phpmailer.php');
	$mail = new PHPMailer();
	$mail->Host = 		$c_node['mail']['host'];
	$mail->Mailer = 	$c_node['mail']['mailer'];
	$mail->From = 		$output_user['user_email'];
	$mail->FromName = 	$output_user['user_firstname'] . " " . $output_user['user_surname'];
	$mail->WordWrap = 	$c_node['mail']['wordwrap'];
	$mail->AddReplyTo($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
	$mail->language = 	"en";


	//setup IM
	require_once($c_node['class_dir'] . 'User/IM.class.php');
	$im = new IM($me['user_id'], $db, $c_node['message_box_max_size']);
	$im->setStatus($c_node['message_status_unread'], $c_node['message_status_read']);
	$im->setBoxes($c_node['message_in_box'], $c_node['message_save_box'], $c_node['message_out_box']);


	//get text files
	$body_mail_file = readTxtFile($languageTextPath . "mail_invite.txt.php");
	$body_im_file = readTxtFile($languageTextPath . "im_invite.txt.php");



	//send invites
	$invited = sendInvite($body_mail_file, $body_im_file, $data);

	if ($invited[0][0] == "success") {
	    $success = $invited;

		if (isset($success[0][2])) {
		    $total_emails_sent = $success[0][2];
			unset($success[0][2]);
		}
	}
	else {
	    $error = $invited;
	}
}


//delete relations older than 3 months
deletePendingRelations($me['user_id'], $c_node['relation_type']['approval_pending']);

//delete pending mail requests
$pending_output = deletePendingInvitees ($me['user_id']);


//get pending IM relations
$pending_output = getPending ($me['user_id'], $c_node['relation_type']['approval_pending']);


//move to template
if (isset($total_emails_sent)) {
    $body->set('total_emails_sent', $total_emails_sent);
}

if (isset($pending_output)) {
    $body->set('pending', $pending_output);
}

include "inc/footer.inc.php";




/*
* sendInvite
* Tom Calthrop 7th April 2004
*/
function sendInvite($body_file_mail_txt, $body_file_im_txt, $data) {

	global $db, $mail, $im, $lang, $me, $user, $c_node;


	//prepare data
	if(empty($data['to'])) {
		$state[] = array('error', 2); //no emails
	}
	else {

		$emails = preg_split("/[\s,]+/", $data['to']);
		$total_emails_sent = 0;
		//print_r($emails);
		//check each email
		foreach($emails as $key => $i):

			if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $i)) {
				$state[]  = array('error', 3, $i); //email invalid
			}
			else {
				//check to see if user in User table
				$query1 = "SELECT user_id FROM " . $db->prefix . "_user WHERE user_email='" . $i . "'";
				$result1 = $db->Execute($query1);
				if(!empty($result1->fields['user_id']) && $result1->fields['user_id'] != $me['user_id']) {

					//send internal instant message to user
					$body_file_im_txt1 = "";
					$body_file_im_txt1 = str_replace("NAME", $me['firstname'], $body_file_im_txt);

					//we check that the user has not blovcked me
					if($im->checkUserBlocked($result1->fields['user_id'])) {

						//check we do not already have a relation record
						// add a br_relation record with a level of "approval_pending"
						$user->node_id = $c_node['node_id'];

						if ($relation = $user->insertRelation($result1->fields['user_id'], $c_node['relation_type']['approval_pending'])) {
						    //send IM

							$im->sendMessage($result1->fields['user_id'], $lang['subject_im_friendship_invite'], $body_file_im_txt1, 1);

							$total_emails_sent++;
						}
					}


				}
				else {
					//send email

					$body_file_mail_txt1 = "";
					$body_file_mail_txt1 = str_replace("USERMESSAGE", $data['message'], $body_file_mail_txt);
					$body_file_mail_txt1 = str_replace("NAME", $me['firstname'], $body_file_mail_txt1);
					
					$url = "http://" . $_SERVER['HTTP_HOST'];
		
					if (dirname ($_SERVER['PHP_SELF']) != "/") {
					    $url .= dirname ($_SERVER['PHP_SELF']) . "/..";
					}
					
					$url .= "/register.php?invitee=" . $me['user_id'] . "&email=" . htmlspecialchars($i) . "&language_id=" . $me['language_id'];
					
					$body_file_mail_txt1 = str_replace("URL", $url, $body_file_mail_txt1);
					$body_file_mail_txt1 = stripslashes($body_file_mail_txt1);

					//send email to email address
					$mail->Subject = $data['subject'];
					$mail->Body = $body_file_mail_txt1;
					$mail->ClearAddresses();
					$mail->AddAddress($i, '');

					if(!$mail->Send()) {
					 	$state[]  = array('error', 18, $mail->ErrorInfo); //Mailer Error
					}
					else {
						$total_emails_sent++;
					}

					//insert record into user invitee table.
					$datetime = date("Y-m-d H:i:s");
					$datetime = $db->DBDate($datetime);

					$query = "
						INSERT INTO " . $db->prefix . "_user_invited
						(invited_email, invitee_user_id, invite_create_datetime) VALUES (
						'" . $i ."',
						" . $me['user_id'] . ",
						" . $datetime . ")"
					;

					$result = $db->Execute($query);

				}
			}

		endforeach;
	}

	if (!isset($state)) {
		$state[]  = array('success', 7, $total_emails_sent);

	}

	return $state;

}//EO searchEventItems();


/*
* pendingRelations
* Tom Calthrop 7th April 2004
*/
function getPending ($user_id, $type) {

	global $date, $db;

	$temp = array();

	//get relations pending from users already registered.
	$query = "
		SELECT r.relation_create_datetime as datetime, u.user_email as email
		FROM " . $db->prefix . "_relation r
		LEFT JOIN " . $db->prefix . "_user u ON r.user_id_friend=u.user_id
		where
		r.user_id=" . $user_id . " and
		r.type=" . $type . "
		order by r.relation_create_datetime"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {


		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['datetime'] = $date->formatDate($temp1['datetime']);

			array_push($temp, $temp1);

			$result->MoveNext();
		}
		$result->Close();
	}

	//get the pending requests for emails for used not in DB
	$query = "
		SELECT DISTINCT invited_email as email, invite_create_datetime as datetime
		FROM " . $db->prefix . "_user_invited ui
		where
		ui.invitee_user_id=" . $user_id . "
		order by ui.invite_create_datetime"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['datetime'] = $date->formatDate($temp1['datetime']);

			array_push($temp, $temp1);

			$result->MoveNext();
		}
		$result->Close();
	}

	if (!empty($temp)) {
	    return $temp;
	}
}

/*
* deletePendingRelations
* Tom Calthrop 7th April 2004
*/
function deletePendingRelations ($user_id, $type) {

	global $date, $db;

	$datetime = date(mktime()-(86400*21));
	$datetime = $db->DBDate($datetime);

	$query = "
		DELETE FROM " . $db->prefix . "_relation
		where
		user_id=" . $user_id . " and
		type=" . $type . " and
		relation_create_datetime < " . $datetime
	;

	$result = $db->Execute($query);

	$query = "
		DELETE FROM " . $db->prefix . "_relation
		where
		user_id_friend=" . $user_id . " and
		type=" . $type . " and
		relation_create_datetime < " . $datetime
	;

	$result = $db->Execute($query);
}//EO deletePendingRelations();


/*
* deletePendingInviteed
* Tom Calthrop 7th April 2004
*/
function deletePendingInvitees ($user_id) {

	global $date, $db;

	$datetime = date(mktime()-(86400*21));
	$datetime = $db->DBDate($datetime);

	$query = "
		DELETE FROM " . $db->prefix . "_user_invited
		where
		user_id=" . $user_id . " and
		invite_create_datetime < " . $datetime
	;

	$result = $db->Execute($query);
}//EO deletePendingInviteed();
?>
