<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'User/Blog.class.php');
require_once($c_node['class_dir'] . 'Wiki/Wiki.php');

//append language setup
require_once($languageArrayPath . 'arr_user_publish.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


if (isset($_REQUEST['blog_id'])) {
	$blog_id = $_REQUEST['blog_id'];
}

$user_id = $me['user_id'];


//setup Image
$image->thumb = "t1";


//setup blog
$blog = new Blog($user_id, $db, $date);
$blog->image = $image;


//wiki setup
$wiki =& new Text_Wiki();
$wiki->rulePath = $c_node['class_dir'] . "Wiki/Rule/";
$wiki->setRuleConf('image', 'base', $c_node['base_path'] . "user/" . $user_id . "/");

//stop WIKI style links in the Blog
$wiki->disableRule('wikilink');


//get images for default image selections
$output_images = $image->getImages('user', $user_id, 't2');


if (isset($_POST['data'])) {//post data received
    $data = $_POST['data'];

	$data['blog_body'] = stripslashes($data['blog_body']);
	$data['blog_body_display'] = $wiki->transform($data['blog_body'], 'Xhtml');

	$data['blog_synopsis'] = stripslashes(htmlspecialchars($data['blog_synopsis']));

	$data['blog_title'] = stripslashes(htmlspecialchars($data['blog_title']));

	if (isset($_POST['preview_blog'])) {
		$data['blog_body'] = htmlspecialchars($data['blog_body']);

		$output_blog = $data;

		$display = "preview_blog";
	}
	elseif (isset($_POST['edit_blog_again'])) {
		$output_blog = $data;

		$display = "add_blog";

	}
	elseif (isset($_POST['insert_blog'])) {

		$insert = $blog->insertBlog($data);

		if ($insert[0][0] == "success") {
			header("Location: my_blog.php?" . SID);
			exit;
		}
		else {
		    $error = $insert;

			$output_blog = $data;

			$display = "add_blog";
		}
	}
	elseif (isset($_POST['update_blog'])) {

		$update = $blog->updateBlog($data);

		if ($update[0][0] == "success") {
			header("Location: my_blog.php?blog_id=" . $data['blog_id'] . "&amp;" . SID);
			exit;
		}
		else {
		    $error = $update;

			$output_blog = $data;

			$display = "add_blog";
		}
	}

}
elseif (isset($_POST['edit_blog'])) {
		$blog->blog_id = $blog_id;
		$output_blog = $blog->getBlog();

		$display = "add_blog";

}
elseif (isset($_REQUEST['add_blog'])) {

		$display = "add_blog";

}
elseif (isset($_REQUEST['delete_blog'])) {
		$delete = $blog->deleteBlogs(array($blog_id));

		if ($delete[0][0] == "success") {
			$success = $delete;
		}
		else {
		    $error = $delete;
		}

		$output_blogs = $blog->getMyBlogs();
		$display = "list_blogs";

}
elseif (isset($blog_id)) {//if we have a blog id we retrieve it
    $blog->blog_id = $blog_id;
	$output_blog = $blog->getBlog();
	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');

	$display = "view_blog";
}
else {
	$output_blogs = $blog->getMyBlogs();

	if (isset($output_blogs)) {
	    $user->setStatistic($c_node['user_statistic_type_id']['total_blogs'], count($output_blogs));
	}

	$display = "list_blogs";
}

$output_user['language_ids'] = $me['language_ids'];


//move vars to template
if (isset($output_user)) {
	$body->set('user', $output_user);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($output_blog)) {
	$body->set('blog', $output_blog);
}

if (isset($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (isset($output_images)) {
	$body->set('images', $output_images);
}

$body->set('user_levels', $c_node['user_level_id']);

include "inc/footer.inc.php";

?>
