<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_user_priv.lang.php');
require_once($languageArrayPath . 'arr_group_type.lang.php');
require_once($languageArrayPath . 'arr_user_online_status.lang.php');


//we add the new members
if (isset($_POST['invite']) && isset($_POST['group_invite'])) {
	$invited = insertMembers($group_id, $_POST['group_invite'], $c_node['user_level_id']['pending']);
}


if (isset($_REQUEST['invite_members'])) {
	$sn_arr = $_SESSION['s_social_network'];
	$non_member_friends = getNonMemberFriends($group_id, $sn_arr);

	$display = "invite_members";
}
else {
	$output_members = $group->getMembership($group_id);
	$output_friends = getFriends($group_id);

	if (isset($output_members)) {
	    $group->setStatistic($c_node['group_statistic_type_id']['total_members'], count($output_members));
	}
}


//move to template
if (isset($non_member_friends)) {
	$body->set('non_member_friends', $non_member_friends);
}

if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_friends)) {
	$body->set('friends', $output_friends);
}

if (isset($output_members)) {
	$body->set('members', $output_members);
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('group_types', $c_node['group_type']);

$template_pageLink = $lang['txt_membership'];
include "inc/footer.inc.php";





/*
* getFriends
* Tom Calthrop 8th April 2004
*/
function getFriends ($group_id) {

	global $db, $image, $user, $me, $date, $log;

	//get friends
	$query = "
		SELECT u.user_id, u.user_nic, u.user_firstname, u.user_hometown,
		u.user_summary, u.user_ms_messenger, u.user_yahoo_messenger,
		user_icq, u.user_create_datetime, u.user_image_id, u.active_time
		FROM " . $db->prefix . "_user u
		LEFT JOIN " . $db->prefix . "_relation r ON r.user_id_friend=u.user_id
		LEFT JOIN " . $db->prefix . "_group_member gm ON gm.user_id=r.user_id_friend
		WHERE
		r.user_id=" . $me['user_id'] . " and
		gm.group_id=" . $group_id
	;

	//echo $query . "<br><br>";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			$temp1['user_create_datetime'] = $date->formatDate($temp1['user_create_datetime']);

			$temp1['online_status'] = $user->getStatus($temp1['active_time']);

			//get default image
			if (isset($temp1['user_image_id'])) {
				$temp1['image'] = $image->getImage($temp1['user_image_id'], 't1', 'user', $temp1['user_id']);
			}

			//get aquaintances for each friend
				$query1 = "
					SELECT r.user_id_friend as user_id, u.user_nic, r.node_id, u.user_create_datetime
					FROM " . $db->prefix . "_relation r
					LEFT JOIN " . $db->prefix . "_user u ON r.user_id_friend=u.user_id
					LEFT JOIN " . $db->prefix . "_group_member gm ON gm.user_id=r.user_id_friend
					WHERE
					r.user_id =" . $result->fields['user_id'] . " and
					gm.group_id=" . $group_id
				;

				$result1 = $db->Execute($query1);

				if (!$result1) {
					$error[]  = array('error', 1, $db->ErrorMsg());
				}
				else {

					$temp2 = array();

					while (!$result1->EOF) {
						array_push($temp2, $result1->fields);
						$result1->MoveNext();
					}
					$temp1['acquaintances'] = $temp2;
				}




			array_push($temp, $temp1);

			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
} //EO getFriends();




/*
* getNonMemberFriends
* Tom Calthrop 8th April 2004
*/
function getNonMemberFriends ($group_id, $sn_arr) {

	global $db, $image, $user, $me, $date, $log;

	//get the ids from my social network
	$sn_ids = "";
	foreach($sn_arr as $key => $i):
		if (isset($i['user_id'])) {
		    $sn_ids .= $i['user_id'] . ",";
		}

		if (isset($i['acquaintance'])) {
			foreach($i['acquaintance'] as $key => $r):
				$sn_ids .= $r['user_id'] . ",";
			endforeach;
		}
	endforeach;

	$sn_ids = substr($sn_ids, 0, strlen($sn_ids)-1);

	//get the group members that are not in $ids
	$query = "
		SELECT gm.user_id
		FROM " . $db->prefix . "_group_member gm
		WHERE
		gm.user_id in (" . $sn_ids . ") and
		gm.user_id!=" . $me['user_id'] . " and
		gm.group_id=" . $group_id
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$gp_member_ids = "";
		$temp = array();

		while (!$result->EOF) {
			$gp_member_ids .= $result->fields['user_id'] . ",";
			$result->MoveNext();
		}

		$gp_member_ids = substr($gp_member_ids, 0, strlen($gp_member_ids)-1);

		if (empty($gp_member_ids)) {
		    $gp_member_ids = 0;
		}
	}

	//get the friends who are not in the group
	$query = "
		SELECT u.user_id, u.user_surname, u.user_firstname, u.user_hometown,
		u.user_create_datetime, u.user_image_id
		FROM " . $db->prefix . "_user u
		WHERE
		u.user_id in (" . $sn_ids . ") and
		u.user_id not in (" . $gp_member_ids . ")"
	;
	//echo $query . "<br><br>";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			$temp1['user_create_datetime'] = $date->formatDate($temp1['user_create_datetime']);

			//get default image
			if (isset($temp1['user_image_id'])) {
				$temp1['image'] = $image->getImage($temp1['user_image_id'], 't1', 'user', $temp1['user_id']);
			}

			array_push($temp, $temp1);

			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
} //EO getNonMemberFriends();




/*
* insertMembers
* Tom Calthrop 8th April 2004
*/
function insertMembers ($group_id, $ins_arr, $level_id) {

	global $db, $me, $error;

	$rownums = count ($ins_arr);

	$datetime = date("Y-m-d H:i:s");
	$datetime = $db->DBDate($datetime);

	for ($i=0; $i < $rownums; $i++) {
		$query = "
			INSERT INTO " . $db->prefix . "_group_member (
			group_id, level_id, member_create_datetime, user_id , node_id
			) VALUES (
			" . $group_id . ",
			" . $level_id . ",
			" . $datetime . ",
			" . $ins_arr[$i] . ",
			" . $me['node_id'] . "
			)"
		;
		//echo $query . "<br><br>";;
		$result = $db->Execute($query);

		if (!isset($result)) {
			$state[]  = array('error', 1, $db->ErrorMsg());
		}
		else {
			$result->Close();
		}

	}

	return true;


} //EO insertMembers;
?>
