<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

if (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}

if (isset($_REQUEST['page_id'])) {
	$page_id = $_REQUEST['page_id'];
}

if (isset($_REQUEST['history_library_id'])) {
	$history_library_id = $_REQUEST['history_library_id'];
}

$core = "group";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'Library/Library.class.php');
require_once($c_node['class_dir'] . 'Wiki/Wiki.php');


//library setup
$library = new Library();
$library->type = "group";
$library->db = $db;
$library->group_id = $group_id;
$library->date = $date;
$library->image = $image;

//wiki setup
$wiki =& new Text_Wiki();
$wiki->rulePath = $c_node['class_dir'] . "Wiki/Rule/";
$wiki->setRuleConf('wikilink', 'view_url', 'g_library.php?group_id=' . $group_id . '&page=');
$wiki->setRuleConf('wikilink', 'new_url', 'g_library_edit.php?group_id=' . $group_id . '&page=');
$wiki->setRuleConf('image', 'base', $c_node['base_path'] . "group/" . $group_id . "/");


//if we are not a member we turn off the ability to make new links
if ($output_group_member_level['user_level_id'] < $c_node['user_level_id']['member']) {
    $wiki->setRuleConf('wikilink', 'new_url', '#'); // turn off the new ability to create new pages
	$wiki->setRuleConf('wikilink', 'new_text', ''); // turn off the new ability to create new pages
}


// set an array of pages that exist in the library
$pages = $library->getPages();
$wiki->setRuleConf('wikilink', 'pages', $pages);


//setup image
$image->thumb = "t2";



if (isset($_POST['search'])) {
	$search = trim($_POST['search_text']);
	$output_library_search_results = $library->searchLibrary($search);

	$display = "search";
}
elseif (isset($_REQUEST['contents'])) {

	$output_contents = $library->getContents();

	$display = "contents";

}
elseif (isset($history_library_id)) {
	$output_history = $library->getHistory($history_library_id);

	$display = "history";
}
elseif (isset($page_id)) {
	$output_library = $library->getPageID($page_id);

	//find out if this is the newest article
	$newest_doc = $library->getPageName($output_library['library_page_name']);

	if ($output_library['library_id'] == $newest_doc['library_id']) {
	    $newest = true;
	}

}
elseif (isset($page)) {
	$output_library = $library->getPageName($page);
	$newest = true;
}
else {
	$output_library = $library->getPageDefault();
	$newest = true;
}




if (isset($output_library['library_id'])) {

	$library_id = $output_library['library_id'];
	
	$library->node_id = $me['node_id'];
	$library->user_id = $me['user_id'];
	$library->library_page_name = $output_library['library_page_name'];
	
	//update bookmarks
	if (isset($_REQUEST['watch'])) {
		$library->updateBookmark('watch');
	}
	elseif (isset($_REQUEST['recommend'])) {
		$library->updateBookmark('recommend');
	}
	elseif (isset($_REQUEST['unwatch'])) {
		$library->updateBookmark('unwatch');
	}
	elseif (isset($_REQUEST['unrecommend'])) {
		$library->updateBookmark('unrecommend');
	}
	
	//movement
	$output_library['bookmarks'] = $library->getBookmarks();


	if (isset($output_library['forum_subject_id'])) {
	   $output_forum = getForum($output_library['forum_subject_id']);
	}

	if (isset($output_library['user_id'])) {
	    $output_author = $user->userDetails($output_library['user_id']);
		$output_author['user_create_datetime'] = $date->formatDate($output_author['user_create_datetime']);
	}

	//Parser library
	$output_library['library_body'] = $wiki->transform($output_library['library_body'], 'Xhtml');

	if (isset($output_library['library_image_id'])) {
		$output_library['image'] = $image->getImage($output_library['library_image_id'], 't1');
	}
}


//move to template
if (isset($output_contents)) {
	$body->set('contents', $output_contents);
}

if (isset($output_history)) {
	$body->set('history', $output_history);
}

if (isset($newest)) {
	$body->set('newest', $newest);
}

if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_library)) {
	$body->set('library', $output_library);
}

if (isset($output_author)) {
	$body->set('author', $output_author);
}

if (isset($output_library_search_results)) {
	$body->set('library_search_results', $output_library_search_results);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($search)) {
	$body->set('search', $search);
}

if (isset($output_forum)) {
	$body->set('forum', $output_forum);
}


if (isset($output_library['library_title'])) {
	$template_pageLink = $lang['txt_library'];
	$template_pageLinkNote = $output_library['library_title'];
}

include "inc/footer.inc.php";


/*
* getForum
* if we have an attached discussion we get the id's
* Tom Calthrop 15th April 2004
*/
function getForum ($subject_id) {

	global $db, $log;

	$query = "
		SELECT s.subject_id, s.topic_id
		FROM " . $db->prefix . "_forum_subject s
		WHERE
		s.subject_id=" . $subject_id
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = $result->fields;

		return $temp;
	}
} //EO getForum();
?>
