<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";


if (isset($_REQUEST['image_id'])) {
    $image_id = $_REQUEST['image_id'];
}


if (isset($_POST['insert_image'])) {

	$image->imagepath = $c_node['base_path'] . "group/" . $group_id;

	$upload = $image->uploadImage($_FILES['image']);

	// Handles the result if errors found
	if (empty($upload)) {
		$insert = $image->insertImage('group', $group_id, $data['image_title']);

		if ($insert[0][0] == "success") {
		    $success = $insert;
			$display = "saved";
		}
		else {
		    $error = $insert;
			$display = "add";
		}

	}
	else {
		$error = $upload;
		$display = "add";
	}
}
elseif (isset($_POST['delete_image'])) {
	$image->imagepath = $c_node['base_path'] . "group/" . $group_id;
	$remove_image = $image->getImage($data['image_id'], '', 'group', $group_id);
	$delete = $image->deleteImageFile($remove_image['image_filename'], $remove_image['image_mime']);
	$delete = $image->deleteImage('group', $data['image_id']);

	if ($delete[0][0] == "success") {
		$success = $delete;
	}
	else {
	    $error = $delete;
	}

	$display = "saved";
}
elseif (isset($_POST['update_image'])) {

	$output_image = $data;

	if (isset($_FILES['image']) && $_FILES['image']['size'] > 0) {
	    //update the image
		$image->imagepath = $c_node['base_path'] . "group/" . $group_id;
		$upload = $image->uploadImage($_FILES['image']);

		if (empty($upload)) {
			//update the DB record
			$update = $image->updateImage('group', $data['image_id'], $data['image_title'], $me['user_id']);

			if ($update[0][0] == "success") {
			    $success = $update;
				$display = "saved";
			}
			else {
			    $error = $update;
				$display = "edit";
			}

			//delete the old image
			$delete = $image->deleteImageFile($data['image_filename'], $data['image_mime']);


		}
		else {
			$error = $upload;
			$display = "add";
		}


	}
	else {
		//just update title
		$update = $image->updateImage('group', $data['image_id'], $data['image_title'], $me['user_id']);

		if ($update[0][0] == "success") {
		    $success = $update;
			$display = "saved";
		}
		else {
		    $error = $update;
			$display = "edit";
		}
	}
}
elseif (isset($_POST['set_default']) && isset($_POST['data']['default_image_id'])) {
	$update = $image->updateDefaultImage ('group', $group_id, $_POST['data']['default_image_id'], $me['user_id']);

	if ($update[0][0] == "success") {
		    $success = $update;
			$display = "saved";
		}
		else {
		    $error = $update;
			$display = "edit";
		}

	$output_group['group_image_id'] = $_POST['data']['default_image_id'];
}

// we will edit this image
if (isset($image_id)) {
	$output_image = $image->getImage($image_id, '', 'group', $group_id);
	$output_image['image_t1'] = "group/" . $group_id . "/" . $output_image['image_filename'] . "_t1." . $output_image['image_mime'];
	$output_image['image_t2'] = "group/" . $group_id . "/" . $output_image['image_filename'] . "_t2." . $output_image['image_mime'];
	$display = "edit";
}
elseif (isset($_REQUEST['add_image'])) {
	$display = "add";
}


$output_images = $image->getImages('group', $group_id, 't2');


//storage
$output_storage = $image->getTotalBytesUsed('group', $group_id);

if ($output_group['group_image_allocation'] < 1) {
    $output_storage['max_space'] = $c_node['max_group_space'];
}
else {
	$output_storage['max_space'] = $output_group['group_image_allocation'];
}





//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($output_images)) {
	$body->set('images', $output_images);
}

if (isset($output_storage)) {
	$body->set('storage', $output_storage);
}

if (isset($output_image)) {
	$body->set('image', $output_image);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($data)) {
	$body->set('data', $data);
}

include "inc/footer.inc.php";

?>
