<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "event";
include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_event_type.lang.php');
require_once($languageArrayPath . 'arr_level.php');
require_once($languageArrayPath . 'arr_event_publish.lang.php');
require_once($languageArrayPath . 'arr_activity_user_status.lang.php');


//setup event
$event->thumb = 't1';


if (isset($_REQUEST['view_event'])) {
	$event->event_id = $event_id;
	$output_event = $event->getEvent();
	$output_activities = $event->getActivities();

	if (isset($output_event['forum_subject_id'])) {
		$output_subject = getSubject($output_event['forum_subject_id']);
	}

	$display = "view_event";

}
elseif (isset($_POST['edit_event'])) {
	$event->event_id = $event_id;
	$output_event = $event->getEvent();

	$display = "edit_event";

}
elseif (isset($_REQUEST['add_event'])) {

	$display = "add_event";

}
elseif (isset($_POST['insert_event'])) {
	$insert = $event->insertEvent($data, $me['user_id']);

	if(!empty($data['event_frequency']) & $data['event_frequency']>1)
	{
		$output_event = $event->getLatestEvent();
		$display = "edit_event_repeat";
	}
	else
	{
		header("Location: e_events.php?list_events=1&amp;".SID);
		exit;

	}

}
elseif (isset($_POST['event_repeat'])) {

	$insert = $event->setEventRepeat($data, $me['user_id']);

	if ($insert[0][0] == "success") {
	    $success = $insert;
		$output_events = $event->getEvents('user', $me['user_id']);
		$display = "list_events";
	}
	else {
	    $error = $insert;
		$display = "edit_event_repeat";
	}



}
elseif (isset($_POST['update_event'])) {

	$update = $event->updateEvent($data, $me['user_id']);

	if ($update[0][0] == "success") {
	    $success = $update;
		$event->event_id = $data['event_id'];
		$output_event = $event->getEvent();
		$output_activities = $event->getActivities();

		if(!empty($data['event_frequency']) & $data['event_frequency']>1)
			$display = "edit_event_repeat";
		else
			$display = "view_event";
	}
	else {
	    $error = $update;
		$output_event = $data;
		$display = "edit_event";
	}

}
elseif (isset($_POST['delete_event'])) {
	$delete = $event->deleteEvent($event_id);

	if ($delete[0][0] == "success") {
	    $success = $delete;
	}
	else {
	    $error = $delete;
	}

	$output_events = $event->getEvents('user', $me['user_id']);

	$display = "list_events";

}
elseif (isset($_REQUEST['view_activity'])) {
	$event->event_id = $event_id;
	$output_event = $event->getEvent();
	$output_activity = $event->getActivity($activity_id);
	$output_activity_users = $event->getActivityApplicants($activity_id);

	$display = "view_activity";

}
elseif (isset($_POST['edit_activity'])) {
	$event->event_id = $event_id;
	$output_event = array('event_id' => $event_id);
	$output_activity = $event->getActivity($activity_id);

	$display = "edit_activity";

}
elseif (isset($_REQUEST['add_activity'])) {
	$output_event = array ('event_id' => $event_id);
	$display = "add_activity";

}
elseif (isset($_POST['insert_activity'])) {
	$insert = $event->insertActivity($data, $me['user_id']);

	if ($insert[0][0] == "success") {
	    $success = $insert;
	}
	else {
	    $error = $insert;
	}

	$event->event_id = $data['event_id'];
	$output_event = $event->getEvent();
	$output_activities = $event->getActivities();

	$display = "view_event";
}
elseif (isset($_POST['update_activity'])) {

	$update = $event->updateActivity($data, $me['user_id']);

	if ($update[0][0] == "success") {
	    $success = $update;
		$event->event_id = $event_id;
		$output_event = $event->getEvent();
		$output_activity = $event->getActivity($activity_id);

		$display = "view_activity";

	}
	else {
	    $error = $update;
		$output_activity = $data;
		$display = "edit_activity";
	}

}
elseif (isset($_POST['delete_activity'])) {
	$delete = $event->deleteActivity($activity_id);

	if ($delete[0][0] == "success") {
	    $success = $delete;
	}
	else {
	    $error = $delete;
	}

	$event->event_id = $data['event_id'];
	$output_event = $event->getEvent();
	$output_activities = $event->getActivities();

	$display = "view_event";

}
elseif (isset($_POST['update_user_activity']) && isset($_POST['activity_user_id'])) {
	$update = $event->updateActivityApplicants($activity_id, $_POST['activity_user_id'], $_POST['activity_user_status']);

	if ($update[0][0] == "success") {
	    $success = $update;
	}
	else {
	    $error = $update;
	}

	$event->event_id = $event_id;
	$output_event = $event->getEvent();
	$output_activity = $event->getActivity($activity_id);
	$output_activity_users = $event->getActivityApplicants($activity_id);

	$display = "view_activity";

}
elseif (isset($group_id) && $group_id > 0) {
	//list event
	$output_events = $event->getEvents('group', $group_id);

	$display = "list_group_events";
}
else {
	//list event
	$output_events = $event->getEvents('user', $me['user_id']);

	$display = "list_events";
}


//find out if we are a node admin to approve event. Get user_level and pass to template
$user_id = $me['user_id'];
$user->user_id = $user_id;
$output_user = $user->userDetails();


//we cannot delete an event if confirmed activities exist
if (isset($output_activities)) {
	if ($event->confirmNoActivityUsersConfirmed($output_activities, $c_node['activity_user_status']['confirmed'])) {
	    $output_show_event_delete = true;
	}
}

//we cannot delete an activity if confirmed activities users exist
if (isset($output_activity)) {
	if (isset($output_activity_users)) {
		if ($event->confirmNoActivityUsersConfirmed($output_activity_users, $c_node['activity_user_status']['confirmed'])) {
		    $output_show_activity_delete = true;
		}
	}
	else {
		$output_show_activity_delete = true;
	}
}


//get images
if ($group_id > 0) {
    $output_images = $image->getImages('group', $group_id, 't2');
	$output_group = $group->groupDetails();
	$output_subjects = subjectList($group_id);
}
else {
	$output_images = $image->getImages('user', $me['user_id'], 't2');
}





//move to template
if (isset($output_user)) {
   $body->set('user', $output_user);
}

if (isset($output_event)) {
   $body->set('event', $output_event);
}

if (isset($display)) {
   $body->set('display', $display);
}

if (isset($output_images)) {
	$body->set('images', $output_images);
}

if (isset($output_show_event_delete)) {
	$body->set('show_event_delete', $output_show_event_delete);
}

if (isset($output_show_activity_delete)) {
	$body->set('show_activity_delete', $output_show_activity_delete);
}

if (isset($output_event['event_start_datetime'])) {
   $body->set('start_datedropdown', $date->dateDropdown($output_event['event_start_datetime'], 1, 'start', 10, 20));
}
else {
   $body->set('start_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'start', 10, 20));
}

if (isset($output_event['event_end_datetime'])) {
   $body->set('end_datedropdown', $date->dateDropdown($output_event['event_end_datetime'], 1, 'end', 10, 20));
}
else {
   $body->set('end_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'end', 10, 20));
}

if (isset($output_event['event_start_day'])) {
   if($output_event['event_frequency']==3)
	   $event_start_daytime = date("Y-m-d", mktime(0,0,0, 1, $output_event['event_start_day'], 1999));
   else
	   $event_start_daytime = date("Y-m-d", mktime(0,0,0, $output_event['event_start_month'], $output_event['event_start_day'], 1999));
   $body->set('start_monthlydropdown', $date->dateDropdown($event_start_daytime, 1, 'event_start', 10, 20, $output_event['event_frequency']));
}
else {
   $body->set('start_monthlydropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'event_start', 10, 20));
}

if (isset($output_event['event_end_day'])) {
   if($output_event['event_frequency']==3)
	   $event_end_daytime = date("Y-m-d", mktime(0,0,0, 1, $output_event['event_end_day'], 1999));
   else
	   $event_end_daytime = date("Y-m-d", mktime(0,0,0, $output_event['event_end_month'], $output_event['event_end_day'], 1999));

   $body->set('end_monthlydropdown', $date->dateDropdown($event_end_daytime, 1, 'event_end', 10, 20, $output_event['event_frequency']));
}
else {
   $body->set('end_monthlydropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'event_end', 10, 20));
}

if (isset($output_activities)) {
	$body->set('activities', $output_activities);
}

if (isset($output_activity)) {
	$body->set('activity', $output_activity);
}

if (isset($output_activity_users)) {
	$body->set('activity_users', $output_activity_users);
}

if (isset($output_activity['activity_start_datetime'])) {
   $body->set('start_datedropdown', $date->dateDropdown($output_activity['activity_start_datetime'], 1, 'start', 10, 20));
}
elseif (!isset($output_event['event_start_datetime'])) {
   $body->set('start_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'start', 10, 20));
}

if (isset($output_activity['activity_end_datetime'])) {
   $body->set('end_datedropdown', $date->dateDropdown($output_activity['activity_end_datetime'], 1, 'end', 10, 20));
}
else if (!isset($output_event['event_end_datetime'])){
   $body->set('end_datedropdown', $date->dateDropdown(date("Y-m-d H:00:00"), 1, 'end', 10, 20));
}

if (isset($c_node['activity_user_status']['confirmed'])) {
	$body->set('confirmed_id', $c_node['activity_user_status']['confirmed']);
}

if (isset($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (isset($output_subject)) {
	$body->set('subject', $output_subject);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

$body->set('user_levels', $c_node['user_level_id']);


include "inc/footer.inc.php";




/*
* SUBJECT LIST
* tom calthrop
* 15th May 2004
*/
function subjectList ($group_id) {

	global $db, $log;

	$query = "
		SELECT s.subject_title, s.subject_id
		FROM " . $db->prefix . "_forum_subject s, " . $db->prefix . "_forum_topic t, " . $db->prefix . "_forum_section se
		where
		s.topic_id=t.topic_id and
		t.section_id=se.section_id and
		se.group_id=" . $group_id . "
		order by s.subject_title"
	;
	//echo $query;

	$result = $db->Execute($query);

	if (!$result) {
		$state[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
}



/*
* getSubject
* tom calthrop
* 15th May 2004
*/
function getSubject ($subject_id) {

	global $db, $log;

	$query = "
		SELECT s.subject_title, s.subject_id, s.topic_id
		FROM " . $db->prefix . "_forum_subject s
		where
		s.subject_id=" . $subject_id
	;

	//echo $query;

	$result = $db->Execute($query);

	if (!$result) {
		$state[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = $result->fields;
		$result->Close();
		return $temp;
	}
}//EO getSubject();
?>
