<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class Blog {
	// Instance variables
	var $user_id;                        // User id
	var $db;                             // get db connect
	var $date;                           // get date for date formatting
	
	
	// Set the user id and $db connection in the constructor for simplicity
	function Blog($user_id, $db, $date, $node_id = null) {
		$this->user_id = $user_id;
		$this->db = $db;
		$this->date = $date;
		
		if (isset($node_id)) {
		    $this->node_id = $node_id;
		}
	}



	/*
	* getBlog
	* tom calthrop
	* 22nd May 2004
	*/
	function getBlog () {
		if (isset($this->blog_id)) {
			$query = "
				SELECT b.*
				FROM " . $this->db->prefix . "_blog b
				where
				b.blog_id=" . $this->blog_id
				;
		}
		else {
			$query = "
				SELECT b.*
				FROM " . $this->db->prefix . "_blog b
				where "
			;

			if (isset($this->item_publish)) {
				$query .= "b.blog_publish=" . $this->blog_publish . " and ";
			}

			$query .= "
				b.user_id=" . $this->user_id . "
				order by b.blog_create_datetime desc"
			;

		}
		
		$result = $this->db->SelectLimit($query, 1); //returns last 1 rows
		
		if (isset($result->fields)) {
		
			$temp = $result->fields;
			$this->blog_id = $temp['blog_id'];
			$temp['blog_create_datetime'] = $this->date->formatDate($temp['blog_create_datetime']);

			$result->Close();

			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
	} //EO getBlog();



	/*
	* updateBlog
	* tom calthrop
	* 22nd May 2004
	*/
	function updateBlog ($data) {

		if(empty($data['blog_title'])) {
			$state[] =  array('error', 11);
		}

		if(empty($data['blog_synopsis'])) {
			$state[] =  array('error', 21);
		}

		if(empty($data['blog_body'])) {
			$state[] =  array('error', 12);
		}

		if (empty($state)) {

			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);

			//stops sql errors when backslashes are removed - \"
			$data['blog_title'] = str_replace("'", "\'", $data['blog_title']);
			$data['blog_synopsis'] = str_replace("'", "\'", $data['blog_synopsis']);
			$data['blog_body'] = str_replace("'", "\'", $data['blog_body']);

			$query = "
				UPDATE " . $this->db->prefix . "_blog set
				blog_title = '" . $data['blog_title'] . "',
				blog_synopsis = '" . $data['blog_synopsis'] . "',
				blog_body = '" . $data['blog_body'] . "',
				blog_publish = " . $data['blog_publish'] . ", 
				language_id = " . $data['language_id'] . ", 
				genre_id = " . $data['genre_id'] . ",
				blog_image_id = " . $data['blog_image_id'] . ",
				blog_edit_datetime = " . $datetime . ",
				user_id_edit = " . $this->user_id . "
				WHERE
				blog_id = " . $data['blog_id']
			;
			//echo $query . "<br><br>";

			$result = $this->db->Execute($query);

			if (!$result) {
				$state[] =  array('error', 1, $this->db->ErrorMsg());
			}

			if (!isset($state)) {
			    $state[]  = array('success', 3);
			}
		}

		return $state;

	} //EO updateBlog();


	/*
	* insertBlog
	* tom calthrop
	* 22nd May 2004
	*/
	function insertBlog ($data) {

		if(empty($data['blog_title'])) {
			$state[] =  array('error', 11);
		}

		if(empty($data['blog_synopsis'])) {
			$state[] =  array('error', 21);
		}

		if(empty($data['blog_body'])) {
			$state[] =  array('error', 12);
		}

		if (!isset($state)) {
			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);

			//stops sql errors when backslashes are removed - \"
			$data['blog_title'] = str_replace("'", "\'", $data['blog_title']);
			$data['blog_synopsis'] = str_replace("'", "\'", $data['blog_synopsis']);
			$data['blog_body'] = str_replace("'", "\'", $data['blog_body']);

			if (isset($data['blog_image_id']) && $data['blog_image_id'] > 0) {
			    $blog_image_id = $data['blog_image_id'];
			}
			else {
				$blog_image_id = "null";
			}

			$query = "
				INSERT INTO " . $this->db->prefix . "_blog (
				blog_title, blog_synopsis, blog_body,
				blog_publish, language_id, blog_image_id, blog_create_datetime, user_id,
				genre_id
				) values (
				'" . $data['blog_title'] . "',
				'" . $data['blog_synopsis'] . "',
				'" . $data['blog_body'] . "',
				" . $data['blog_publish'] . ", 
				" . $data['language_id'] . ", 
				" . $blog_image_id . ",
				" . $datetime . ",
				" . $this->user_id . ",
				" . $data['genre_id'] . "
				)"
			;
			//echo $query . "<br><br>";

			$result = $this->db->Execute($query);

			if (!$result) {
				$state[] =  array('error', 1, $this->db->ErrorMsg());
			}

			if (!isset($state)) {
			    $state[]  = array('success', 2);
			}
		}

		return $state;

	} //EO insertBlog();




	/*
	* getMyBlogs
	* tom calthrop
	* 22nd May 2004
	*/
	function getMyBlogs () {
		$query = "
			SELECT b.blog_id, b.blog_title, b.blog_synopsis, b.blog_create_datetime,
			blog_total_views , genre_id
			FROM " . $this->db->prefix . "_blog b
			where
			b.user_id=" . $this->user_id
		;

		if (isset($this->blog_publish)) {
			$query .= " and b.blog_publish<=" . $this->blog_publish;
		}

		$query .= " order by b.blog_create_datetime desc";

		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit); //returns last X rows
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['blog_create_datetime'] = $this->date->formatDate($temp1['blog_create_datetime']);

				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	} //EO getMyBlogs();



	/*
	* getBlogsByGenre
	* tom calthrop
	* 22nd May 2004
	*/
	function getBlogs() {
		$query = "
			SELECT b.blog_id, b.blog_title, b.blog_synopsis, b.blog_create_datetime,
			b.user_id, u.user_nic, b.blog_image_id, b.blog_total_views
			FROM " . $this->db->prefix . "_blog b, " . $this->db->prefix . "_user u
			where
			b.user_id=u.user_id"
		;

		if (isset($this->genre_id)) {
		    $query .= " and b.genre_id=" . $this->genre_id;
		}

		if (isset($this->blog_publish)) {
			$query .= " and b.blog_publish<=" . $this->blog_publish;
		}

		if (isset($this->user_id)) {
			$query .= " and b.user_id != " . $this->user_id;
		}

		if (isset($this->before_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->before_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= " and b.blog_create_datetime <= " . $datetime;
		}

		if (isset($this->after_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->after_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= " and b.blog_create_datetime >= " . $datetime;
		}

		if (isset($this->order_by)) {
		    $query .= " order by b." . $this->order_by;
		}
		else {
			$query .= " order by b.blog_create_datetime desc";
		}

		if (isset($this->limit)) {
		    $query .= " limit " . $this->limit;
		}
		
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['blog_create_datetime'] = $this->date->formatDate($temp1['blog_create_datetime']);

				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	} //EO getBlogsByGenre();





	/*
	* deleteBlogs
	* tom calthrop
	* 22nd May 2004
	*/
	function deleteBlogs($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_blog
				WHERE
				blog_id = " . $del_arr[$i]
			;

			$result = $this->db->Execute($query);

			if (!$result) {
				$state[]  = array('error', 1, $this->db->ErrorMsg());
			}
		}

		if (!isset($state)) {
		    $state[]  = array('success', 4);
		}

		return $state;
	}//EO deleteBlogs();



	/*
	* updateTotalViews
	* tom calthrop
	* 22nd May 2004
	*/
	function updateTotalViews($total) {

		$total++;

		$query = "
			UPDATE " . $this->db->prefix . "_blog set
			blog_total_views=" . $total . "
			WHERE
			blog_id = " . $this->blog_id
		;
		//echo $query . "<br><br>";

		$result = $this->db->Execute($query);

	} //EO updateTotalViews();




	/*
	* searchItems
	* Tom Calthrop 7th April 2004
	*/
	function searchBlogs ($search) {
		$query = "
			SELECT b.blog_id, b.blog_title, b.blog_synopsis, b.blog_create_datetime,
			b.user_id, u.user_nic, b.blog_image_id, b.blog_total_views
			FROM " . $this->db->prefix . "_blog b, " . $this->db->prefix . "_user u
			where
			b.user_id=u.user_id and
			b.blog_publish=" . $this->publish . " and
			(
			b.blog_title like '%" . $search . "%' or
			b.blog_body like '%" . $search . "%'
			)
			order by b.blog_create_datetime desc"
		;

		//echo $query . "<br><br>";
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['blog_create_datetime'] = $this->date->formatDate($temp1['blog_create_datetime']);

				//format search results
				$temp1['blog_synopsis'] = searchTextFormat($search, $temp1['blog_synopsis']);
				$temp1['blog_title'] = searchTextFormat($search, $temp1['blog_title']);

				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	} //EO searchItems();
	
	
	/*
	* updateBookmark
	* bookmark this item or recommend this item
	* Tom Calthrop 23rd Nov 2004
	*/
	function updateBookmark($bookmark_type) {
	
		if ($bookmark_type == "watch") {
		    $query = "
				INSERT INTO " . $this->db->prefix . "_blog_bookmark 
				(user_id, blog_id, node_id, bookmark_type) VALUES (
				" . $this->user_id . ", 
				" . $this->blog_id . ", 
				" . $this->node_id . ", 
				1)"
			;
		}
		elseif ($bookmark_type == "recommend") {
		    $query = "
				INSERT INTO " . $this->db->prefix . "_blog_bookmark 
				(user_id, blog_id, node_id, bookmark_type) VALUES (
				" . $this->user_id . ", 
				" . $this->blog_id . ", 
				" . $this->node_id . ", 
				2)"
			;
		}
		elseif ($bookmark_type == "unwatch") {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_blog_bookmark 
				WHERE 
				user_id=" . $this->user_id . " and 
				blog_id=" . $this->blog_id . " and 
				node_id=" . $this->node_id . " and 
				bookmark_type=1"
			;
		}
		elseif ($bookmark_type == "unrecommend") {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_blog_bookmark 
				WHERE 
				user_id=" . $this->user_id . " and 
				blog_id=" . $this->blog_id . " and 
				node_id=" . $this->node_id . " and 
				bookmark_type=2"
			;
		}
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			$result->Close();
		}
	} //EO updateBookmark();
	
	
	/*
	* GET BOOKMARKS
	* Tom Calthrop 23rd Nov 2004
	*/
	function getBookmarks () {
	
		$query = "
			SELECT bookmark_type  
			FROM " . $this->db->prefix . "_blog_bookmark
			WHERE
			blog_id=" . $this->blog_id . " and
			user_id=" . $this->user_id . " and
			node_id=" . $this->node_id
		;
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			while (!$result->EOF) {
				if ($result->fields['bookmark_type'] == 1) {
				    $temp['watch'] = 1;
				}
				
				if ($result->fields['bookmark_type'] == 2) {
				    $temp['recommend'] = 1;
				}

				$result->MoveNext();
			}
		
			$result->Close();
			
			if (isset($temp)) {
			    return $temp;
			}
			
		}
	} //EO getBookmarks();
}

?>
