<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Poll {

	var $poll_id, $db, $query, $result, $temp;

	function Poll($poll_id = null) {
		$this->poll_id = $poll_id;
	}

	/*
	* POLL DETAILS
	* tom calthrop
	* 24th Feb 2004
	*/
	function getPoll() {

		$query = "
			SELECT p.*
			FROM " . $this->db->prefix . "_poll p
			where
			p.poll_id=" . $this->poll_id
		;

		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
		
			$temp = $result->fields;

			$temp['display_poll_start_datetime'] = $this->date->formatDate($temp['poll_start_datetime']);
			$temp['display_poll_end_datetime'] = $this->date->formatDate($temp['poll_end_datetime']);

			$temp['options'] = $this->getOptions();
			$temp['total_votes'] = $this->total_votes;

		
			//get percentages
			foreach($temp['options'] as $key => $i):
				$temp['options'][$key]['percent'] = 0;
	
				if ($i['votes'] > 0) {
				    $percent = round((100/$this->total_votes)* $i['votes']);
					$temp['options'][$key]['percent'] = $percent;
				}
			endforeach;
			
			$result->Close();
			
			return $temp;
		}
		else {
			$this->log[] = array('error', 1, $this->db->ErrorMsg());
		}
	}

	/*
	* POLL OPTIONS LIST
	* tom calthrop
	* 24th Feb 2004
	*/
	function getOptions() {
		$total_votes = 0;

		$query = "
			SELECT po.*
			FROM " . $this->db->prefix . "_poll_option po
			where
			po.poll_id=" . $this->poll_id
		;
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
		
			$temp = array();

			while (!$result->EOF) {
				$temp1 =  $result->fields;
				$temp1['votes'] = $this->answerSummary($temp1['option_id']);
				$total_votes = $total_votes + $temp1['votes'];
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();

			$this->total_votes = $total_votes;
			return $temp;
		}
		else {
			$this->log[] = array('error', 1, $this->db->ErrorMsg());
		}
	}


	/*
	* POLL ANSWER DETAILS
	* tom calthrop
	* 24th Feb 2004
	*/
	function answerSummary($option_id) {
		$query = "
			SELECT count(pa.answer_id) as total
			FROM " . $this->db->prefix . "_poll_answer pa
			WHERE
			current_answer=1 and
			option_id=" . $option_id
		;
		
		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
	
		if (isset($result->fields)) {
		
			$temp = $result->fields;
		}
		$result->Close();
		return $temp['total'];
	}




	/*
	* CURRENT VOTE FOR A USER
	* tom calthrop
	* 24th Feb 2004
	*/
	function pollUserCurrentVote($user_id) {

		//display a poll
		$query = "
			SELECT pa.*
			FROM " . $this->db->prefix . "_poll_answer pa
			where
			pa.user_id=" . $user_id . " and
			pa.poll_id=" . $this->poll_id . " and
			pa.current_answer=1
			order by pa.answer_create_datetime"
		;
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
			$temp = $result->fields;
			$result->Close();
			
			return $temp;
		}

	}


	/*
	* POLL LIST (used for drop downs on forum subject)
	* tom calthrop
	* 25th Jan 2004
	*/
	function getPolls() {
		$query = "
			SELECT p.*
			FROM " . $this->db->prefix . "_poll p
			where
			p.user_id=" . $this->user_id . "
			order by p.poll_question"
		;

		
		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
	
		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['display_poll_start_datetime'] = $this->date->formatDate($temp1['poll_start_datetime']);
				$temp1['display_poll_end_datetime'] = $this->date->formatDate($temp1['poll_end_datetime']);

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}





	/*
	* updateEvent
	* Tom Calthrop 2nd May 2004
	*/
	function updatePoll($data) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$poll_start_datetime = $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00";

		$poll_end_datetime = $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00";

		if (isset($data['poll_anon'])) {
			$poll_anon = $data['poll_anon'];
		}
		else {
			$poll_anon = "null";
		}

		if (isset($data['vote_required'])) {
			$vote_required = $data['vote_required'];
		}
		else {
			$vote_required = "null";
		}

		$query = "
			UPDATE " . $this->db->prefix . "_poll SET
			poll_question='" . $data['poll_question'] . "',
			poll_start_datetime='" . $poll_start_datetime . "',
			poll_end_datetime ='" . $poll_end_datetime . "',
			poll_anon=" . $poll_anon . ",
			poll_edit_datetime=" . $datetime . ",
			user_id_edit=" . $this->user_id . ",
			vote_required=" . $vote_required . "
			WHERE poll_id=" . $this->poll_id
		;

		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
	
		if (isset($result->fields)) {
			$state[]  = array('success', 3);
			$result->Close();
		}

		return $state;

	}




	/*
	* insertPoll
	* Tom Calthrop 11th April 2004
	*/
	function insertPoll ($data) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$poll_start_datetime = $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00";

		$poll_end_datetime = $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00";

		if (isset($data['poll_anon'])) {
			$poll_anon = $data['poll_anon'];
		}
		else {
			$poll_anon = "null";
		}

		if (isset($data['vote_required'])) {
			$vote_required = $data['vote_required'];
		}
		else {
			$vote_required = "null";
		}

		$query = "
			INSERT INTO " . $this->db->prefix . "_poll
			(poll_question, poll_start_datetime, poll_end_datetime, poll_anon,
			poll_create_datetime, user_id, vote_required
			) VALUES (
			'" . $data['poll_question'] . "',
			'" . $poll_start_datetime . "',
			'" . $poll_end_datetime . "',
			" . $poll_anon . ",
			" . $datetime . ",
			" . $this->user_id . ",
			" . $vote_required . "
			)"
		;
		//echo $query . "<br>";

		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
	
		if (isset($result->fields)) {
		
			$state[]  = array('success', 2);

			$result->Close();
		}

		return $state;
	}//insertPoll



	/*
	* deletePoll
	* Tom Calthrop 11th April 2004
	*/
	function deletePoll () {

		$query = "
			DELETE FROM " . $this->db->prefix . "_poll
			WHERE event_id=" .  $this->poll_id
		;

		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
	
		if (isset($result->fields)) {
		
			$state[]  = array('success', 4);
			$result->Close();

			//delete options

		}
		return $state;
	}//EO deletePoll


	/*
	* insertOption
	* Tom Calthrop 11th April 2004
	*/
	function insertOption($option_body) {
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			INSERT INTO " . $this->db->prefix . "_poll_option
			(poll_id, option_body, option_create_datetime, user_id)
			VALUES (
			" . $this->poll_id . ",
			'" . $option_body . "',
			" . $datetime . ",
			" . $this->user_id . "
			)"
		;
		
		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
		
	}//EO insertOption();



	/*
	* updateOption
	* Tom Calthrop 11th April 2004
	*/
	function updateOption($option_id, $option_body) {
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			UPDATE " . $this->db->prefix . "_poll_option SET
			option_body='" . $option_body . "',
			option_edit_datetime=" . $datetime . ",
			user_id=" . $this->user_id . "
			WHERE
			option_id=" . $option_id
		;
		
		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
	
		if (isset($result->fields)) {
		
			$state[]  = array('success', 3);
			$result->Close();
		}

		return $state;
	}//EO updateOption();




	/*
	* deleteOption
	* Tom Calthrop 11th April 2004
	*/
	function deleteOption($option_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_poll_option
			WHERE
			option_id=" . $option_id
		;
		
		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
	
		if (isset($result->fields)) {
		
			$state[]  = array('success', 4);
			$result->Close();
		}

		return $state;
	}//EO deleteOption();


	/*
	* getPollUsage
	* tom calthrop
	* 11th May 2004
	*/
	function getPollUsage() {
		//forum Subject polls attached
		$query = "
			SELECT s.subject_id, s.subject_title, t.topic_id, se.group_id
			FROM " . $this->db->prefix . "_forum_subject s
			RIGHT JOIN br_forum_topic t ON s.topic_id=t.topic_id
			RIGHT JOIN br_forum_section se ON se.section_id=t.section_id
			where
			s.poll_id=" . $this->poll_id . "
			order by s.subject_title"
		;

		$result = $this->db->Execute($query) or die($error[]  = array('error', 1, $this->db->ErrorMsg()));
	
		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}//EO getPollUsage()





	/*
	* pollUserVoteHistory
	* tom calthrop
	* 13th May 2004
	*/
	function pollUserVoteHistory($user_id) {//unused

		//display a poll
		$query = "
			SELECT pa.answer_create_datetime, o.option_body
			FROM " . $this->db->prefix . "_poll_answer pa, " . $this->db->prefix . "_poll_option o
			where
			pa.option_id = o.option_id and
			pa.user_id=" . $user_id . " and
			pa.poll_id=" . $this->poll_id . "
			order by pa.answer_create_datetime"
		;
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['answer_create_datetime'] = $this->date->formatDate($temp1['answer_create_datetime'],1);

				array_push($temp, $temp1);
				$result->MoveNext();
			}
			$result->Close();
			
			return $temp;
		}
		
	}//EO pollUserVoteHistory();

}
?>
