<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");

require_once($language_path_core . 'inc/html_edit.lang.inc.php');


if (isset($_POST['set_current_revision_id'])) {
	// we update the default page in the set table
	$rec = array();
	$rec['current_revision_id'] = $_POST['current_revision_id'];
	
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_library_page 
		WHERE 
		page_id=" . $_POST['page_id']
	;

	$result = $db->Execute($query);

	if (isset($result->fields)) {
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
	
	header("Location: index.php?amn=lbr_page&page_id=" . $_POST['page_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['update_page'])) {
	$page_permissions = 0;
			
	if (!empty($_POST['permission']['page'])) {
		foreach ($_POST['permission']['page'] as $key => $i):
			$page_permissions = $page_permissions + $i;
		endforeach;
	}	
			
	$rec = array();
	$rec['page_title'] = strip_tags($_POST['page_title']);
	$rec['page_synopsis'] = strip_tags($_POST['page_synopsis']);
	$rec['page_permission'] = $page_permissions;
	
	if (!empty($_POST['file_id'])) {
		$rec['file_id'] = $_POST['file_id'];
	}
			
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_library_page 
		WHERE 
		page_id=" . $_POST['page_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
	
	header("Location: index.php?amn=lbr_page&page_id=" . $_POST['page_id'] . "&" . strip_tags(SID));
	exit;
	
}
elseif (isset($_POST['insert_page'])) {
	
	if (!empty($_POST['page_name']) && !empty($_POST['set_id'])) {
		
		$page_permissions = 0;
			
		if (!empty($_POST['permission']['page'])) {
			foreach ($_POST['permission']['page'] as $key => $i):
				$page_permissions = $page_permissions + $i;
			endforeach;
		}	
			
		$rec = array();
		$rec['page_title'] = strip_tags($_POST['page_title']);
		$rec['page_synopsis'] = strip_tags($_POST['page_synopsis']);
		$rec['set_id'] = $_POST['set_id'];
		$rec['page_name'] = $_POST['page_name'];
		$rec['page_permission'] = $page_permissions;
				
		$table = $db->prefix . "_library_page";
		
		$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $db->Execute($query);
				
		if (isset($result)) {
			$page_id = $db->Insert_ID();
		}
		
		if (isset($page_id)) { // we insert the first revision
			$rev_rec = array();

			require_once('components/core/class/Kses/kses.php');
		
			$rev_rec['revision_body'] = kses_parse($_POST['revision_body'], 'max');
			$rev_rec['user_id'] = $_SESSION['user_id'];
			$rev_rec['revision_create_datetime'] = time();
			$rev_rec['page_id'] = $page_id;
			
			$table = $db->prefix . "_library_revision";
	
			$query = $db->GetInsertSQL($table, $rev_rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			if (isset($result)) {
				$revision_id = $db->Insert_ID();
			}
		}
		
		// when we have the revision we update the page with the current revision
		if (isset($revision_id)) {
			//current_revision_id 
			$page_rec = array();
			$page_rec['current_revision_id'] = $revision_id;
			
			$query = "
				SELECT * 
				FROM " . $db->prefix . "_library_page 
				WHERE 
				page_id=" . $page_id
			;
	
			$page_result = $db->Execute($query);
	
			if (isset($page_result->fields)) {
				$query = $db->GetUpdateSQL($page_result, $page_rec, false, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			}
		}
		
		if (isset($page_id)) {
			header("Location: index.php?amn=lbr_page&page_id=" . $page_id . "&" . strip_tags(SID));
			exit;
		}
	}
}


if (!empty($output_page)) {
	$body->set('page', $output_page);
	$body->set('display', 'page_edit');
	
	// get available images
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$file->thumbs = $core_config['file']['image']['thumb'];
	
	$images = $file->selFiles("images", "t2");
	$body->set("images", $images);
	
	// get revisions
	$output_revisions = $library->selRevisions($output_page['page_id']);
	$body->set("revisions", $output_revisions);
}
elseif (isset($_REQUEST['page_name'])) {

	$_REQUEST['page_name'] = trim($_REQUEST['page_name']);
	
	$output_page['page_name'] = $_REQUEST['page_name'];
	$output_page['set_id'] = $_REQUEST['set_id'];
	$output_page['page_permission'] = null;

	$body->set('page', $output_page);
	$body->set('display', 'page_create');

	// get available images
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->module_id = $core_config['module_id']['library'];
	$file->item_id = $output_set['set_id'];
	$file->core_config_module = $core_config['module'];
	$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$file->thumbs = $core_config['file']['image']['thumb'];

	$images = $file->selFiles("images", "t2");
	$body->set("images", $images);
}
else {
	header("Location: index.php?amn=lbr_overview&" . strip_tags(SID));
	exit;
}


$body->set("library_config", $library_config);
$body->set("module_prefix", $core_config['module'][$core_config['module_id']['library']]['prefix']);

?>
