<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");

require_once($language_path_core . 'inc/html_edit.lang.inc.php');


if (isset($_POST['insert_revision'])) {
	// we check wiki page names
	$library->checkInterLinkNames($_POST['revision_body']);
	
	if (empty($GLOBALS['am_error_log'])) {
		$rec = array();
		
		require_once('components/core/class/Kses/kses.php');
		
		$rec['revision_body'] = kses_parse($_POST['revision_body'], 'max');
		
		$rec['revision_note'] = strip_tags($_POST['revision_note']);
		$rec['user_id'] = $_SESSION['user_id'];
		$rec['revision_create_datetime'] = time();
		$rec['page_id'] = $_POST['page_id'];
		
		$table = $db->prefix . "_library_revision";
			
		if (empty($GLOBALS['am_error_log'])) {
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			
			$result = $db->Execute($query);
						
			if (isset($result)) {
				$revision_id = $db->Insert_ID();
			}
						
			if (isset($revision_id)) {
				// we update the current_revision_id
				$rec = array();
				$rec['current_revision_id'] = $revision_id;
			
				$query = "
					SELECT * 
					FROM " . $db->prefix . "_library_page 
					WHERE 
					page_id=" . $_POST['page_id']
				;
				
				$result = $db->Execute($query);
				
				if (isset($result->fields)) {
					$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
					$result = $db->Execute($query);
				}
			}
			
			header("Location: index.php?amn=lbr_page&page_id=" . $_POST['page_id'] . "&" . strip_tags(SID));
			exit;
		}
		else {
			$output_revision = $_POST;
			$output_revision['revision_body'] = stripslashes($output_revision['revision_body']);
			
			$body->set('revision', $output_revision);
		}
	}
	else { // a wiki page was misnamed
		$output_revision = $_POST;
		$output_revision['revision_body'] = stripslashes($output_revision['revision_body']);
		
		$body->set('revision', $output_revision);
	}
	
}
elseif (isset($_POST['preview_revision'])) {
	$output_revision = $_POST;
	
	require_once('components/core/class/Kses/kses.php');
	
	$output_revision['display_revision_body'] = kses_parse($output_revision['revision_body'], 'max');
	
	$output_revision['revision_body'] = stripslashes($output_revision['revision_body']);
	$output_revision['display_revision_body'] = stripslashes($output_revision['display_revision_body']);
	
	if ($core_config['xhtml_markup']['format']['nl2br'] == 1) {
		$output_revision['display_revision_body'] = nl2br($output_revision['display_revision_body']);
	}
	
	$body->set('revision', $output_revision);
}
elseif (isset($_REQUEST['revision_id'])) {
	$output_revision = $library->selRevision($_REQUEST['revision_id']);
	$body->set('revision', $output_revision);
}

if (!empty($output_page)) {
	$body->set('page', $output_page);
	$body->set('display', 'page_edit');
}
else {
	header("Location: index.php?amn=lbr_overview&" . strip_tags(SID));
	exit;
}

// pull out css custom items
$output_custom_elements = parseCustomElements($output_set['set_css']);

if (!empty($output_custom_elements)) {
	$body->set("custom_stylesheet_elements", $output_custom_elements);
}


// get available images
require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = $core_config['module_id']['library'];
$file->item_id = $output_set['set_id'];
$file->core_config_module = $core_config['module'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumbs = $core_config['file']['image']['thumb'];

$output_images = $file->selFiles("images", "t2");

if (!empty($output_images)) {
	$body->set("images", $output_images);
}

$output_files = $file->selFiles(null);

if (!empty($output_files)) {
	$body->set("files", $output_files);
}

// get pages
$output_pages = $library->selPages($output_set['set_id']);

if (!empty($output_pages)) {
	$body->set("pages", $output_pages);
}



$body->set("library_config", $library_config);
$body->set("module_prefix", $core_config['module'][$core_config['module_id']['library']]['prefix']);

?>
