<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");


// SETUP WIKI ------------------------------------------------------------
require_once('components/core/class/Wiki/Wiki.php');
require_once ('components/core/class/Wiki/Wiki/Parse.php');
require_once ('components/core/class/Wiki/Wiki/Render.php');
$wiki = new Text_Wiki();

if (isset($_SESSION['user_id'])) {
	if ($user->selUserPreference($_SESSION['user_id'], $core_config['user']['preference']['use_new_window'])) {
		$wiki->setRenderConf('xhtml', 'url', 'target', '_blank');
	}
}


// SETUP COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['library']);
$comment->wiki = $wiki;
$comment->module_id = $core_config['module_id']['library'];


// SETUP TAGS ------------------------------------------------------------
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db);


// FORMAT LIBRARY ENTRY -------------------------------------------------------
if (!empty($output_page) && !empty($output_revision)) {
	
	//wikify body
	$wiki_path = "index.php?amn=lbr_page&set_id=" . $output_set['set_id'] . "&page_name=";
	$wiki_image_base = "get_file.php?file=";
	$wiki_new_path = "index.php?amn=lbr_page_edit&set_id=" . $output_set['set_id'] . "&page_name=";
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	
	// set an array of pages that exist in the library
	$pages = $library->selPages($output_page['set_id']);
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);
	$output_revision['revision_body_display'] = $wiki->transform($output_revision['revision_body'], 'Xhtml');
	
	
	$body->set('revision', $output_revision);
	$body->set('set', $output_set);
	
	// get author
	$output_identity = $user->selUserIdentity($output_revision['user_id']);
	$body->set('identity', $output_identity);
	
	// get identities
	if (!empty($output_participants)) {
		// get their ids
		if (!empty($output_participants)) {
			foreach ($output_participants as $key => $i):
				$user->identity_ids[] = $i['identity_id'];
			endforeach;
			
			$user->identity_ids = array_unique($user->identity_ids);
			
			if (!empty($user->identity_ids)) {
				$output_identities = $user->selUserIdentities();
				
				// we place the identities against the participants
				if (!empty($output_identities)) {
					foreach ($output_participants as $keyp => $p):
						foreach ($output_identities as $keyi => $i):
							if ($p['identity_id'] == $i['identity_id']) {
								$output_participants[$keyp]['identity'] = $i;
								break;
							}
						endforeach;
					endforeach;
				}
				
				$body->set('participants', $output_participants);
			}
		}
	}
	
	// get latest revisions
	$library->limit = 6;
	$output_revisions = $library->selRevisions($output_page['page_id']);
	$body->set('revisions', $output_revisions);
	
	
	if (!empty($_SESSION['md5'])) {
		// FAVOURITES -----------------------------------------
		require_once('components/core/class/Bookmark.class.php');
		$bookmark = new Bookmark($db, $core_config['module_id']['library']);
		$bookmark->item_id = $output_set['set_id'];
		$bookmark->user_id = $_SESSION['user_id'];	
		
		// bookmarks
		if (isset($_POST['mark'])) {
			// 0=unset, 1=set, 2=set and track
			$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
			$bookmark->inner_item_id = $output_page['page_id'];
			
			if ($_POST['mark'] == 2) {
				$bookmark->insertBookmark(1);
			}
			elseif ($_POST['mark'] == 1) {
				$bookmark->insertBookmark();
			}
			else {
				$bookmark->deleteBookmark();
			}
		}
		elseif (isset($_POST['recommend'])) {
			// 0=unset, 1=set
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			$bookmark->inner_item_id = $output_page['page_id'];
			
			if ($_POST['recommend'] == 1) {
				$bookmark->insertBookmark();
			}
			else {
				$bookmark->deleteBookmark();
			}
		}
		
		
		// GET BOOKMARK --------------------------------------------------
		if (isset($bookmark)) {
			$bookmark->item_id = $output_set['set_id'];
			$bookmark->inner_item_id = $output_page['page_id'];
			$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
			if ($bookmark->selBookmark()) {
				$bookmark->updateBookmark();
				$output_page['bookmark']['watch'] = 1;
			}
			
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			if ($bookmark->selBookmark()) {
				$bookmark->updateBookmark();
				$output_page['bookmark']['recommend'] = 1;
			}
		}
		
		
		// get my bookmarked favourites for this set
		$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
		unset($bookmark->inner_item_id);
		$output_bookmarks = $bookmark->selBookmarks(1);
		
		if (!empty($output_bookmarks)) {
			// we get item_id's and we get the sets from that
			foreach ($output_bookmarks as $key => $i):
				$library->page_ids[] = $i['inner_item_id'];
			endforeach;
			
			unset ($library->file);
			
			if (!empty($library->page_ids)) {
				$output_my_bookmarks = $library->selPages(null, 1);
			}
			
			$body->set('my_bookmarks', $output_my_bookmarks);
		}
		
		
		// GET RATINGS -----------------------------------------------------
		require_once('components/core/class/Rate.class.php');
		$rate = new Rate($db, $core_config['module_id']['library']);
		$rate->item_id = $output_set['set_id'];
		$rate->user_id = $_SESSION['user_id'];	
		
		if (isset($_POST['relevent'])) {
			// 0=unset, 1=set
			$rate->rate_type = $core_config['rate']['type']['relevent'];
			$rate->inner_item_id = $output_page['page_id'];
			
			$rate->deleteRating();
			
			if ($_POST['relevent'] == 1) {
				$rate->insertRating(1);
			}
			else {
				$rate->insertRating(0);
			}
		}
		elseif (isset($_POST['accurate'])) {
			// 0=unset, 1=set
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$rate->inner_item_id = $output_page['page_id'];
			
			$rate->deleteRating();
			
			if ($_POST['accurate'] == 1) {
				$rate->insertRating(1);
			}
			else {
				$rate->insertRating(0);
			}
		}
		
		// select my ratings on this page
		$rate->rate_type = $core_config['rate']['type']['relevent'];
		$output_rating_relevent = $rate->selRating();
		
		if (isset($output_rating_relevent)) {
			if (isset($output_rating_relevent[0]['rate_value'])) {
				$output_page['rate']['relevent']['value'] = $output_rating_relevent[0]['rate_value'];
			}
		}
		
		$rate->rate_type = $core_config['rate']['type']['accurate'];
		$output_rating_accurate = $rate->selRating();
		
		if (isset($output_rating_accurate)) {
			if (isset($output_rating_accurate[0]['rate_value'])) {
				$output_page['rate']['accurate']['value'] = $output_rating_accurate[0]['rate_value'];
			}
		}
		
		unset($rate->user_id);
		
		// statistics
		if (isset($output_rating_relevent)) {
			$rate->rate_type = $core_config['rate']['type']['relevent'];
			$output_page['rate']['relevent']['total'] = $rate->countRating();
			$output_page['rate']['relevent']['positive'] = $rate->countRating(1);
			
			if (!empty($output_page['rate']['relevent']['total'])) {
				$percentage = round((100 / $output_page['rate']['relevent']['total']) * $output_page['rate']['relevent']['positive']);
			}
			else {
				$percentage = "0";
			}
			
			$lang['txt_relevent_summary'] = str_replace("SYS_KEYWORD_PERCENTAGE", $percentage, $lang['txt_relevent_summary']);
		}
		
		if (isset($output_rating_accurate)) {
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$output_page['rate']['accurate']['total'] = $rate->countRating();
			$output_page['rate']['accurate']['positive'] = $rate->countRating(1);
			
			if (!empty($output_page['rate']['accurate']['total'])) {
				$percentage = round((100 / $output_page['rate']['accurate']['total']) * $output_page['rate']['accurate']['positive']);
			}
			else {
				$percentage = "0";
			}
			
			$lang['txt_accurate_summary'] = str_replace("SYS_KEYWORD_PERCENTAGE", $percentage, $lang['txt_accurate_summary']);
		}
		
		
		
		// select tags
		require_once('components/core/class/Tag.class.php');
		$tag = new Tag($db, $core_config['module_id']['library'], $core_config['tag']['module']['library']);
		$tag->item_id = $output_set['set_id'];
		$tag->inner_item_id = $output_page['page_id'];
		$tag->user_id = $_SESSION['user_id'];	
		
		if (isset($_POST['insert_tag'])) {
			if (empty($_POST['tag_id'])) { // we insert
				$tag->insertTag($_POST['tag_body']);
			}
			elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
				$tag->deleteTag($_POST['tag_id']);
			}
			else { // we update tag
				$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
			}
		}
		elseif (isset($_POST['delete_tag'])) {
			$tag->deleteTag($_POST['tag_id']);
		}
		elseif (isset($_REQUEST['edit_tag'])) {
			$output_tag = $tag->selTag($_REQUEST['edit_tag']);
		
			if (!empty($output_tag)) {
			$body->set('tag', $output_tag);
			}
		}
		
		$output_tags = $tag->selTags();				
		
		if (!empty($output_tags)) {
			$body->set('tags', $output_tags);
		}
	}
	
		
	$body->set('page', $output_page);
	
	
	
	// SET AND GET COMMENTS ----------------------------------------------
	if (isset($_POST['insert_comment'])) {
		$comment->user_id = $_SESSION['user_id'];
		$comment->item_id = $output_set['set_id'];
		$comment->inner_item_id = $output_page['page_id'];
		$comment->item_user_id = $output_revision['user_id'];
		$comment->inner_item_revision = $output_revision['revision_id'];
		$comment->insertComment($_POST);
		
		// insert statistics ------------------------------
		require_once('components/core/class/Statistic.class.php');
		$statistic = new Statistic($db, $library_config['statistic']);
		$statistic->module_id = $core_config['module_id']['library'];
		$statistic->user_id = $_SESSION['user_id'];
		
		// insert library statistic - wiki-set comments
		$statistic->statistic_type_id = $library_config['statistic']['total_set_comment'];
		$statistic->item_id = $output_set['set_id'];
		$statistic->setStatistic($comment->countComments());
		
		unset($statistic->module_id, $comment->item_id, $comment->inner_item_id);
		
		// insert user statistic - total comments
		$statistic->item_id = $_SESSION['user_id'];
		$statistic->statistic_type_id = $core_config['statistic']['user']['total_comments'];
		$statistic->setStatistic($comment->countComments());
		
		
		
	}
	if (isset($_POST['preview_comment'])) {
		$output_comment = $_POST;
		$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
		$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
		$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
		
		$body->set('comment', $output_comment);
		$body->set('display', 'preview_comment');
	}
	elseif (isset($_POST['edit_comment_again'])) {
		$output_comment = $_POST;
		$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
		$body->set('comment', $output_comment);
	}
	
	unset ($comment->user_id);
	
	$comment->item_id = $output_set['set_id'];
	$comment->inner_item_revision = $output_revision['revision_id'];
	
	$output_comments = $comment->selComments($output_page['page_id']);
	
	$body->set('comments', $output_comments);
	
	
	if (!empty($_SESSION['md5'])) {
		// GET AND SET RELATIONSHIP -----------------------------------------------
		if (isset($output_participation)) {
			require_once ("components/core/class/Tie.class.php");
			$tie = new Tie($db, $core_config);
			$tie->module_id = $core_config['module_id']['library'];
			$tie->item_id = $output_set['set_id'];
			
			$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity['identity_id']);
			
			if (empty($output_relationship) && !empty($_REQUEST['respect'])) {
				
				$tie->user_id = $_SESSION['user_id'];
				
				$data['identity_id'] = $output_participation['identity_id'];
				$data['identity_id_relation'] = $output_identity['identity_id'];
				
				$tie->insertRelation($data);
				
				$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity['identity_id']);
			}		
			
			
			if (!empty($output_relationship)) {
				if ($tie->isMutual($output_identity['identity_id'], $output_participation['identity_id'])) {
					$output_relationship['mutual'] = 1;
				}
				
				$body->set('relationship', $output_relationship);
			}
		}
	}
}
else {
	header("Location: index.php?amn=lbr_overview&" . strip_tags(SID));
	exit;
}


?>