<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// Permission check
if ($_SESSION['user_mod_permission'] & $core_config['resource']['module']['grp']['maint']) {

	$menu_section = "group";
	
	include_once ("config/grp.config.php");
	include_once ("inc/grp_initiate.inc.php");
	
	// update group
	if (isset($_POST['update_group'])) {
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_group
			WHERE 
			group_id=" . $_POST['maint_group_id']
		;
		
		$result = $db->Execute($query);
	
		if (isset($result->fields)) {
	
			$rec = array();
			$rec['status_id'] = $_POST['status_id'];

			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}

		// update allocation
		$query = "
			SELECT file_allocation 
			FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $_POST['maint_group_id'] . " AND
			module_id=" . $core_config['module_id']['group']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
	
			$rec = array();
			$rec['file_allocation'] = $_POST['file_allocation']*1000;

			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
	}

	
	// list groups
	$output_groups = $group->selGroups();

	if (!empty($output_groups)) {
		$body->set('groups', $output_groups);
	}

	if (isset($_POST['maint_group_id'])) {
		// GET PROJECT
		$group->group_id = $_POST['maint_group_id'];
		$output_group = $group->selGroup();
		$participation->item_id = $output_group['group_id'];
	}
	elseif (isset($_REQUEST['group_id'])) {
		// GET PROJECT
		$group->group_id = $_REQUEST['group_id'];
		$output_group = $group->selGroup();
	}

	if (!empty($output_group)) {
		// get arbiter
		require_once ("components/core/class/File.class.php");
		$file = new File($db, $core_config['file']);
		
		if (isset($core_config['module'])) {
			$file->core_config_module = $core_config['module'];
		}
		
		$file->module_id = 0; // core
		
		$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
		$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
		$user->file = $file;

		$output_owner = $participation->selParticipation($output_group['user_id']);
		$output_identity = $user->selUserIdentity(null, $output_owner['identity_id']);
		$body->set('identity', $output_identity);
		
		// ALLOCATIONS
		$output_group['file_allocation'] = "0";
		
		$query = "
			SELECT file_allocation 
			FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $output_group['group_id'] . " AND
			module_id=" . $core_config['module_id']['group']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			$output_group['file_allocation'] = $result->fields['file_allocation']/1000;
		}

		$body->set('group', $output_group);
	}
	else { // get statistics
		$output_statistics = array();

		$query = "
			SELECT group_type, count(group_type) as group_count
			FROM " . $db->prefix . "_group
			GROUP BY group_type"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$output_statistics['group_type'][] = $result->fields;
				
				$result->MoveNext();
			}
		}
		$query = "
			SELECT status_id, count(status_id) as status_count
			FROM " . $db->prefix . "_group
			GROUP BY status_id"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$output_statistics['status'][] = $result->fields;
				
				$result->MoveNext();
			}
		}
				
		if (!empty($output_statistics)) {
			$body->set('statistics', $output_statistics);
		}
	}

	
}
else {
	header("Location: index.php?amn=" . $_SESSION['user_homepage'] . "&" . strip_tags(SID));
	exit;
}
?>
