<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>


<div class="col_left1">
	<?php if (isset($event_feedbacks)) { ?>
	<div class="box">
		<div class="box_top">
			<div class="content">
				<?php echo $lang['hdr_feedback']; ?><br />
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
				<?php echo $lang['txt_feedback_intro']; ?>
				</p>
					<table width="100%">
					<?php foreach($event_feedbacks as $f): ?>
					<tr>
						<td width="75"><a href="index.php?amn=evt_item&amp;event_id=<?php echo $f['event_id']; ?>&amp;feedback=1"><?php echo $this->date->formatDate($f['event_end_datetime']); ?>:</a></td>
						<td><?php echo $f['event_title']; ?></td>
					</tr>
					<?php endforeach; ?>
					</table>
				<p>
				<i><?php echo $lang['txt_feedback_ending']; ?></i>
				</p>
			</div>
		</div>
	</div>
	<?php } ?>
	
	<div class="box">
		<div class="box_top">
			<div class="content">
				<img src="<?php echo $template_path_core;?>img/help.png" style="cursor:help;float:left;"  title="<?php echo $lang['txt_help'];?>" hspace="2" alt="" border="0" onClick="javascript:launchPopupWindow('components/core/help.php?help=evt_index#portable');" />
			
				<?php echo $lang['hdr_who_is_going']; ?><br />
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php if (isset($portable_network)) { ?>
				<table width="100%">
				
				<?php foreach($portable_network as $p):?>
				<tr>
					<td>
						<b><?php echo $p['identity']['identity_nic']; ?></b>
					</td>
					<td>
						<a href="index.php?amn=evt_item&amp;event_id=<?php echo $p['event_id']; ?>"><?php echo $p['event_title']; ?></a>
					</td>
					<td>
						<?php echo $this->date->formatDate($p['event_start_datetime']); ?>
					</td>
				</tr>
				<?php endforeach; ?>
				</table>
				<?php
				}
				else {
				echo $lang['err_portable_network'];
				}
				?>
			</div>
		</div>
	</div>
	
	<div class="box">
		<div class="box_top">
			<div class="content">
				<img src="<?php echo $template_path_core;?>img/help.png" style="cursor:help;float:left;"  title="<?php echo $lang['txt_help'];?>" hspace="2" alt="" border="0" onClick="javascript:launchPopupWindow('components/core/help.php?help=core_bookmark');" />
			
				<?php echo $lang['hdr_favourites']; ?><br />
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				
				<?php if (isset($bookmark)) { ?>
				<p>
					<b><?php echo $lang['txt_bookmarked']; ?></b><br />
				</p>
				<p>
				<?php foreach($bookmark as $b): ?>
					<a href="index.php?amn=evt_item&amp;event_id=<?php echo $b['item_id']; ?>"><?php echo $this->date->formatDate($b['event']['event_start_datetime']); ?></a>: <?php echo $b['event']['event_title']; ?><br />
				<?php endforeach; ?>
				</p>
				<?php } else { ?>
					<p>
					<?php 
					$lang['err_no_bookmarks'] = str_replace('SYS_KEYWORD_ICON', "<img src='" . $template_path_core . "img/mark.png' />", $lang['err_no_bookmarks']);
					echo $lang['err_no_bookmarks'];?><br />
					</p>
				<?php } ?>
				<?php if (isset($recommended)) { ?>
				<p>
					<b><?php echo $lang['txt_recommended']; ?></b><br />
				</p>
				<p>
				<?php foreach($recommended as $r): ?>
				<?php echo $r['identity_nic']?>: <a href="index.php?amn=evt_item&amp;event_id=<?php echo $r['item_id']?>"><?php echo $r['event_title']; ?></a><br />
				<?php endforeach; ?>
				</p>
				<?php } ?>
			</div>
		</div>
	</div>
</div>

<div class="col_right1">
	<div class="box">
		<div class="box_top">
			<div class="content">
				<img src="<?php echo $template_path_core;?>img/help.png" style="cursor:help;float:left;"  title="<?php echo $lang['txt_help'];?>" hspace="2" alt="" border="0" onClick="javascript:launchPopupWindow('components/core/help.php?help=evt_index#my_schedule');" />
			
				<?php echo $lang['hdr_my_schedule']; ?><br />
			</div>
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table cellspacing="0" cellpadding="2" border="0">
				
					<?php if (isset($events)) { ?>
						<?php foreach($events as $e): ?>
							<tr>
								<td width="35" rowspan="3">
									<img src="get_file.php?file=<?php if (isset($e['file']['file_md5_name_view'])) echo $e['file']['file_md5_name_view']; ?>" />
								</td>
								<td valign="top" colspan="2">
									<b><a href="index.php?amn=evt_item&amp;event_id=<?php echo $e['event_id']; ?>"><?php echo $this->date->formatDate($e['event_start_datetime'], 4); ?></a>: <?php echo $e['event_title']; ?></b><br />
								</td>
							</tr>
							<tr>
								<td valign="top" colspan="2">
								<?php echo $e['event_synopsis']; ?>
								</td>
							</tr>
							<tr>
								<td valign="top">
									<?php echo $this->date->formatDate($e['event_start_datetime']); ?><br />
								</td>
								<td valign="top">
									<?php if ($e['event_duration'] >= 24) { ?>
									<?php echo intval($e['event_duration']/24) ?> <?php echo $lang['txt_days']; ?><br />
									<?php } else { ?>
									<?php echo $e['event_duration']; ?> <?php echo $lang['txt_hours']; ?><br />
									<?php } ?>
								</td>
							</tr>
							<tr>
								<td colspan="3">
									<br />		
								</td>
							</tr>
						<?php endforeach; ?>
					<?php
					}
					else {
					?>
					<?php echo $lang['err_no_schedule'];?><br />
					<?php } ?>
				</table>
			</div>
		</div>
	</div>
</div>