<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// Permission check
if ($_SESSION['user_mod_permission'] & $core_config['resource']['module']['blg']['maint']) {

	$menu_section = "blog";
	
	include_once ("config/blg.config.php");
	include_once ("inc/blg_initiate.inc.php");
	
	// update blog
	if (isset($_POST['update_blog'])) {
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_blog
			WHERE 
			blog_id=" . $_POST['maint_blog_id']
		;
		
		$result = $db->Execute($query);
	
		if (isset($result->fields)) {
	
			$rec = array();
			$rec['status_id'] = $_POST['status_id'];

			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}

		// update allocation
		$query = "
			SELECT file_allocation 
			FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $_POST['maint_blog_id'] . " AND
			module_id=" . $core_config['module_id']['blog']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
	
			$rec = array();
			$rec['file_allocation'] = $_POST['file_allocation']*1000;

			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
	}

	
	// list blogs
	$output_blogs = $blog->selBlogs();

	if (!empty($output_blogs)) {
		$body->set('blogs', $output_blogs);
	}

	if (isset($_POST['maint_blog_id'])) {
		// GET BLOG
		$output_blog = $blog->selBlog($_POST['maint_blog_id']);
		$participation->item_id = $output_blog['blog_id'];
	}
	elseif (isset($_REQUEST['blog_id'])) {
		// GET BLOG
		$output_blog = $blog->selBlog($_REQUEST['blog_id']);
	}

	if (!empty($output_blog)) {
		// get arbiter
		require_once ("components/core/class/File.class.php");
		$file = new File($db, $core_config['file']);
		
		if (isset($core_config['module'])) {
			$file->core_config_module = $core_config['module'];
		}
		
		$file->module_id = 0; // core
		
		$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
		$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
		$user->file = $file;

		$output_owner = $participation->selParticipation($output_blog['user_id']);
		$output_identity = $user->selUserIdentity(null, $output_owner['identity_id']);
		$body->set('identity', $output_identity);
		
		// ALLOCATIONS
		$output_blog['file_allocation'] = "0";
		
		$query = "
			SELECT file_allocation 
			FROM " . $db->prefix . "_file_allocation 
			WHERE 
			item_id=". $output_blog['blog_id'] . " AND
			module_id=" . $core_config['module_id']['blog']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			$output_blog['file_allocation'] = $result->fields['file_allocation']/1000;
		}

		$body->set('blog', $output_blog);
	}
	else { // get statistics
		$output_statistics = array();

		$query = "
			SELECT blog_type, count(blog_type) as blog_count
			FROM " . $db->prefix . "_blog
			GROUP BY blog_type"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$output_statistics['blog_type'][] = $result->fields;
				
				$result->MoveNext();
			}
		}
		$query = "
			SELECT status_id, count(status_id) as status_count
			FROM " . $db->prefix . "_blog
			GROUP BY status_id"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$output_statistics['status'][] = $result->fields;
				
				$result->MoveNext();
			}
		}
				
		if (!empty($output_statistics)) {
			$body->set('statistics', $output_statistics);
		}
	}

	
}
else {
	header("Location: index.php?amn=" . $_SESSION['user_homepage'] . "&" . strip_tags(SID));
	exit;
}
?>
