<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");


require_once ("components/core/class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = $core_config['module_id']['blog'];
$file->core_config_module = $core_config['module'];
$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
$blog->file = $file;

// get the latest entries
$blog->limit = 16;
$output_entries = $blog->selEntries(null);

if (!empty($output_entries)) {
	$body->set('entries', $output_entries);
}

// get latest blogs
$blog->limit = 4;
$blog->order_by = "blog_create_datetime desc";
$output_blogs = $blog->selBlogs();

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

unset ($blog->order_by, $blog->limit);


// participation in blogs
if (isset($_SESSION['user_id'])) {
	require_once('components/core/class/Participation.class.php');
	$participation = new Participation($db, $core_config);
	$participation->module_id = $core_config['module_id']['blog'];
	$participation->status_id = $core_config['participation']['status']['active'];
	
	$output_participation = $participation->selParticipants(null, null, $_SESSION['user_id']);
	
	if (!empty($output_participation)) {
		// we get item_id's and we get the sets from that
		foreach ($output_participation as $key => $i):
			$blog->blog_ids[] = $i['item_id'];
		endforeach;
		
		
		if (!empty($blog->blog_ids)) {
			$output_my_blogs = $blog->selBlogs();
		}

		if (!empty($output_my_blogs)) {
			$body->set('my_blogs', $output_my_blogs);
		}
	}

	// FAVOURITES -----------------------------------------
	require_once('components/core/class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $core_config['module_id']['blog']);
	
	// get my bookmarked favourites
	$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
	$output_bookmarks = $bookmark->selBookmarks(1);
	
	if (!empty($output_bookmarks)) {
		// we get item_id's and we get the sets from that
		foreach ($output_bookmarks as $key => $i):
			$blog->blog_ids[] = $i['item_id'];
		endforeach;
		
		unset ($blog->file);
		
		if (!empty($blog->blog_ids)) {
			$output_my_bookmarks = $blog->selBlogs();
		}
		
		if (!empty($output_my_bookmarks)) {
			$body->set('my_bookmarks', $output_my_bookmarks);
		}
	}
	
	// REVISIONS FROM RESPECTED NETWORK
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

	// get latest revisions from our respected network
	$query = "
		SELECT i.identity_id, i.identity_nic, i.file_id, e.entry_id, e.entry_create_datetime,
		e.entry_title, e.blog_id
		FROM " . $db->prefix . "_user_identity i, " . $db->prefix . "_relation r, " . $db->prefix . "_blog_entry e  
		WHERE 
		r.user_id=" . $_SESSION['user_id'] . " AND
		r.identity_id_relation=i.identity_id AND
		e.user_id=i.user_id 
		order by e.entry_create_datetime desc"
	;

	$result = $db->SelectLimit($query, 6);

	if (isset($result->fields)) {
		$output_respected_published_entries = array();

		while (!$result->EOF) {
			$temp = $result->fields;

			if (isset($temp['file_id'])) {
				if (isset($file->thumb)) {
					$temp['image'] = $file->selFile($temp['file_id'], $file->thumb);
				}
				else {
					$temp['image'] = $file->selFile($temp['file_id'], "t2");
				}
			
			}
			else {
				$temp['image']['file_title'] = "";
				$temp['image']['file_md5_name_view'] = '0-' . $file->no_image;
				$temp['image']['type'] = "image/png";
				$temp['image']['directory'] = "";
			}

			array_push($output_respected_published_entries, $temp);

			$result->MoveNext();
		}
		
		if (!empty($output_respected_published_entries)) {
			$body->set('respected_published_entries', $output_respected_published_entries);
		}
	}

	// COMMENTS FROM RESPECTED NETWORK
	$query = "
		SELECT i.identity_id, i.identity_nic, i.file_id, c.comment_id, c.comment_create_datetime,
		c.comment_body, c.item_id, c.module_id, c.inner_item_id 
		FROM " . $db->prefix . "_user_identity i, " . $db->prefix . "_relation r, " . $db->prefix . "_comment c
		WHERE
		r.user_id=" . $_SESSION['user_id'] . " AND
		r.identity_id_relation=i.identity_id AND
		c.user_id=i.user_id AND
		c.module_id=" . $core_config['module_id']['blog'] . "
		ORDER BY c.comment_create_datetime desc"
	;
	
	$result = $db->SelectLimit($query, 6);

	if (isset($result->fields)) {
		$output_respected_published_comments = array();

		while (!$result->EOF) {
			$temp = $result->fields;

			if (isset($temp['file_id'])) {
				if (isset($file->thumb)) {
					$temp['image'] = $file->selFile($temp['file_id'], $file->thumb);
				}
				else {
					$temp['image'] = $file->selFile($temp['file_id'], "t2");
				}
			
			}
			else {
				$temp['image']['file_title'] = "";
				$temp['image']['file_md5_name_view'] = '0-' . $file->no_image;
				$temp['image']['type'] = "image/png";
				$temp['image']['directory'] = "";
			}

			array_push($output_respected_published_comments, $temp);

			$result->MoveNext();
		}
		
		if (!empty($output_respected_published_comments)) {
			$body->set('respected_published_comments', $output_respected_published_comments);
		}
	}
}

?>
