<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

require_once(dirname(__FILE__)."/../../env.php");
require_once($_MODELS_DIR."/ApplicationDescriptor.php");
require_once($_MODELS_DIR."/Branch.php");
require_once($_MODELS_DIR."/dto/BranchJSONDTO.php");
require_once($_MODELS_DIR . "/AttributesMask.php");

/** JSON Data Transfert Object. Send a JSON representation of an
 * ApplicationDescriptor with filtered attributes.
 */
class ApplicationDescriptorJSONDTO {

	private function __construct() {}

	/** Get JSON representation of an ApplicationDescriptor.
	 * @param ApplicationDescriptor $appDesc ApplicationDescriptor to translate.
	 * @param int $iAttrMask Bit mask of attributes to include in the
	 * JSON representation. See AttributesMask class.
	 * @return String The JSON representation.
	 */
	public static function toJSON($appDesc, $iAttrMask) {
		$json = "{";
		$bFirstElement = true;
		$dto = array();
		if ($iAttrMask & AttributesMask::ATTR_NAME) {
			if ($bFirstElement) {
				$bFirstElement = false;
			} else {
				$json .= ",";
			}
			$name = json_encode(utf8_encode($appDesc->getName()));
			$json .= '"name":' . $name . '';
		}
		if ($iAttrMask & AttributesMask::ATTR_IDENTIFIER) {
			if ($bFirstElement) {
				$bFirstElement = false;
			} else {
				$json .= ",";
			}
			$id = json_encode(utf8_encode($appDesc->getIdentifier()));
			$json .= '"id":' . $id . '';
		}
		if ($iAttrMask & AttributesMask::ATTR_DESCRIPTION) {
			if ($bFirstElement) {
				$bFirstElement = false;
			} else {
				$json .= ",";
			}
			$description = json_encode(utf8_encode($appDesc->getDescription()));
			$json .= '"description":' . $description . '';
		}
		if ($iAttrMask & AttributesMask::ATTR_WEBSITE) {
			if ($bFirstElement) {
				$bFirstElement = false;
			} else {
				$json .= ",";
			}
			$site = json_encode(utf8_encode($appDesc->getWebsite()));
			$json .= '"website":' . $site . '';
		}
		if ($iAttrMask & AttributesMask::ATTR_BRANCHES) {
			if ($bFirstElement) {
				$bFirstElement = false;
			} else {
				$json .= ",";
			}
			$json .= '"branches":[';
			$bFirstElement2 = true;
			foreach ($appDesc->getBranches() as $branch) {
				if ($bFirstElement2) {
					$bFirstElement2 = false;
				} else {
					$json .= ",";
				}
				$json .= BranchJSONDTO::toJSON($branch);
			}
			$json .= ']';
		}
		$json .= "}";
		return $json;
	}
}

?>