/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick 2.0

ListModel {
    function resolveUrl(source)
    {
        if (typeof(source) === "undefined")
            return ""
        return Qt.resolvedUrl(source)
    }

    ListElement {
        displayName: "Introduction to Creating UIs in Qt Design Studio"
        thumbnail: "images/intro_to_creating_uis.png"
        url: "https://youtu.be/MKa_NWiw4o8"
        showTutorial: true
        tagData: "Overview, Workflow, Qt Bridge"
        description: "Delve into the history of Qt, explore the Qt Bridge for Figma workflow, and get empowered to construct HMIs directly within Qt Design Studio."
    }

    ListElement {
        displayName: "Using Figma Bridge"
        thumbnail: "images/using_figma_bridge.png"
        url: "https://youtu.be/jxmZxZSBj0Y"
        showTutorial: true
        tagData: "Tutorial, Figma"
        description: "Learn how to set up your Figma Design for the Qt Bridge, enabling a smooth transition of your designs into interactive components."
    }

    ListElement {
        displayName: "Special Figma Bridge Cases"
        thumbnail: "images/special_figma_bridge_cases.png"
        url: "https://youtu.be/UkdxeHF3j5M"
        showTutorial: true
        tagData: "Tutorial, Figma"
        description: "Learn how to utilize Figma Variants effectively for Qt Design Studio, optimizing the creation and management of interactive design components."
    }

    ListElement {
        displayName: "3D Integrations"
        thumbnail: "images/3d_integrations.png"
        url: "https://youtu.be/o8r27UB_4rY"
        showTutorial: true
        tagData: "Tutorial, 3D"
        description: "Learn how to export your 3D models from your authoring tool and import the results into Qt Design Studio."
    }

    ListElement {
        displayName: "Running Your Application"
        thumbnail: "images/running_your_app.png"
        url: "https://youtu.be/-15GNYBmO7A"
        showTutorial: true
        tagData: "Tutorial, Previewing, Boot to Qt, DEV/DES"
        description: "Learn how to run your app in the desktop environment, preview separate components seamlessly on your desktop, validate your designs with target hardware, and export your design to Qt Creator."
    }

    ListElement {
        displayName: "Effect Composer"
        thumbnail: "images/effect_composer.png"
        url: "https://youtu.be/SWW1pPz3NYA"
        showTutorial: true
        tagData: "Effect Composer"
        description: "This video introduces the Effect Composer."
    }

    ListElement {
        displayName: "Connection Editor Demo"
        thumbnail: "images/blog_43.png"
        url: "https://youtu.be/8xZXFU8goQQ?si=qYfJRWAixTOVi9mE"
        showTutorial: true
        tagData: "Demo, Connections, Expressions"
        description: "A short introduction video to building connections with conditional statements using the Connection Editor and expression building."
    }

    ListElement {
        displayName: "Qt Design Studio 4"
        thumbnail: "images/qds_4.png"
        url: "https://youtu.be/OceRZKoqw_0"
        showTutorial: true
        tagData: "Overview"
        description: "This video introduces Qt Design Studio 4."
    }

    ListElement {
        displayName: "Welcome to Qt Design Studio!"
        thumbnail: "images/welcome_to_qds.png"
        url: "https://youtu.be/Iy-ivgAWBX8"
        showTutorial: true
        tagData: "Overview"
        description: "Get familiar with the Welcome page in Qt Design Studio."
    }

    ListElement {
        displayName: "What is Qt Design Studio?"
        thumbnail: "images/what_is_qds.png"
        url: "https://youtu.be/lb4Dr_ms5gc"
        showTutorial: true
        tagData: "Overview, Workflow, DEV/DES"
        description: "Learn what Qt Design Studio is and how it supports the designer-developer collaboration."
    }

    ListElement {
        displayName: "What is QML?"
        thumbnail: "images/what_is_qml.png"
        url: "https://youtu.be/4U7j-B1mq00"
        showTutorial: true
        tagData: "QML"
        description: "Learn what QML is on a general level."
    }

    ListElement {
        displayName: "How to create a new project"
        thumbnail: "images/creating_a_project.png"
        url: "https://youtu.be/nfwPYJadcTU"
        showTutorial: true
        tagData: "Tutorial"
        description: "Learn how to create a new project."
    }

    ListElement {
        displayName: "Creating Controls from Figma Design"
        thumbnail: "images/figmaControls_tutorial.png"
        url: "https://youtu.be/DQi3ojkGi3g"
        showTutorial: true
        tagData: "Demo, Figma, Controls, QtWS22"
        description: "Learn how to setup a project consisting of a set of template files, based on Figma variant sets, which contain the design and constraints required to generate a set of fully working Qt Quick Controls."
    }

    ListElement {
        displayName: "Qt Design Studio Walkthrough"
        thumbnail: "images/qtds_walkthrough_tutorial.png"
        url: "https://youtu.be/jXe5Tkx3EZo"
        showTutorial: true
        tagData: "Walkthrough, UI/UX"
        description: "An introduction to exporting a Figma design to Qt Design Studio, managing transitions and animations, and generating front-end QML."
    }

    ListElement {
        displayName: "Enhance your UX to Engineering workflow"
        thumbnail: "images/enchance_ux_tutorial.png"
        url: "https://youtu.be/HUaaOhzMwUE"
        showTutorial: true
        tagData: "Tutorial, UI/UX, Engineering, DEV/DES"
        description: "Learn how to integrate Qt Design Studio into your UX and Engineering workflow to close the gap in your design and development cycles."
    }

    ListElement {
        displayName: "Automagically turn your design into code"
        thumbnail: "images/devDesBridge_tutorial.png"
        url: "https://youtu.be/JLc7N6182N8"
        showTutorial: true
        tagData: "Tutorial, Qt Bridge, Figma, DEV/DES"
        description: "Learn how to turn your Figma design into functional QML code using the Figma bridge."
    }

    ListElement {
        displayName: "Using Custom Shaders, Materials, and Effects"
        thumbnail: "images/gettingStarted_shaders.png"
        url: "https://youtu.be/bMXeeQw6BYs"
        showTutorial: true
        tagData: "Tutorial, Shaders, Materials, Effects"
        description: "This video introduces the Qt Quick 3D Custom Shader Utilities, Materials, and Effects."
    }

    ListElement {
        displayName: "Using Qt Quick 3D Components"
        thumbnail: "images/gettingStarted_3dComponents.png"
        url: "https://youtu.be/u3kZJjlk3CY"
        showTutorial: true
        tagData: "Tutorial, 3D"
        description: "This video focuses on how to import and use the Qt Quick 3D Components in your scenes."
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: UI Navigation"
        thumbnail: "images/Qt_QT_nav.png"
        url: "https://youtu.be/RfEYO-5Mw6s"
        showTutorial: true
        tagData: "QuickTip, UI Navigation"
        description: "QuickTip on navigating the user interface."
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Text Element"
        thumbnail: "images/Qt_QT_textElement.png"
        url: "https://youtu.be/yOUdg1o2KJM"
        showTutorial: true
        tagData: "QuickTip, Text Element"
        description: "QuickTip on using Text Elements."
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Animated Image"
        thumbnail: "images/Qt_QT_animatedImage.png"
        url: "https://youtu.be/DVWd_xMMgvg"
        showTutorial: true
        tagData: "QuickTip, Animated Image"
        description: "QuickTip on using Animated Image."
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Slider Control"
        thumbnail: "images/Qt_QT_sliderControl.png"
        url: "https://youtu.be/Ed8WS03C-Vk"
        showTutorial: true
        tagData: "QuickTip, Controls"
        description: "QuickTip showing how to create a Slider Control."
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Bindings"
        thumbnail: "images/Qt_QT_bindings.png"
        url: "https://youtu.be/UfvA04CIXv0"
        showTutorial: true
        tagData: "QuickTip, Bindings"
        description: "QuickTip showing how to use QML bindings."
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Interactive 3D"
        thumbnail: "images/Qt_QT_interactive3d.png"
        url: "https://youtu.be/w1yhDl93YI0"
        showTutorial: true
        tagData: "QuickTip, 3D"
        description: "QuickTip on using Qt Quick 3D."
    }
}
