/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.compiler;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilerOptions;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chromium.devtools.compiler.DevToolsCodingConvention;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Runner {
    protected final Flags flags = new Flags();
    private final PrintStream err;
    private boolean isConfigValid;

    public Runner(String[] stringArray, PrintStream printStream) {
        this.err = printStream;
        List<String> list = this.processArgs(stringArray);
        CmdLineParser cmdLineParser = new CmdLineParser(this.flags);
        this.isConfigValid = true;
        try {
            cmdLineParser.parseArgument(list.toArray(new String[0]));
            if (this.flags.compilerArgsFile == null) {
                this.isConfigValid = false;
            }
        }
        catch (CmdLineException cmdLineException) {
            printStream.println(cmdLineException.getMessage());
            this.isConfigValid = false;
        }
        if (!this.isConfigValid) {
            cmdLineParser.printUsage(printStream);
        }
    }

    private List<String> processArgs(String[] stringArray) {
        Pattern pattern = Pattern.compile("(--[a-zA-Z_]+)=(.*)");
        Pattern pattern2 = Pattern.compile("^['\"](.*)['\"]$");
        ArrayList<String> arrayList = Lists.newArrayList();
        for (String string : stringArray) {
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                arrayList.add(matcher.group(1));
                String string2 = matcher.group(2);
                Matcher matcher2 = pattern2.matcher(string2);
                if (matcher2.matches()) {
                    arrayList.add(matcher2.group(1));
                    continue;
                }
                arrayList.add(string2);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean shouldRunCompiler() {
        return this.isConfigValid;
    }

    protected void logError(String string, Exception exception) {
        String string2 = String.valueOf(string);
        this.err.println(string2.length() != 0 ? "ERROR: ".concat(string2) : new String("ERROR: "));
        if (exception != null) {
            exception.printStackTrace(this.err);
        }
    }

    private void run() {
        List<CompilerInstanceDescriptor> list = this.getDescriptors();
        if (list == null) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(list.size(), Runtime.getRuntime().availableProcessors() / 2 + 1));
        try {
            this.runWithExecutor(list, executorService);
        }
        finally {
            executorService.shutdown();
        }
    }

    private void runWithExecutor(List<CompilerInstanceDescriptor> list, ExecutorService executorService) {
        Object object;
        Object exception;
        ArrayList<Future<CompilerRunner>> arrayList = new ArrayList<Future<CompilerRunner>>(list.size());
        for (CompilerInstanceDescriptor object3 : list) {
            try {
                exception = new ByteArrayOutputStream(512);
                PrintStream printStream = new PrintStream((OutputStream)exception, false, "UTF-8");
                object = new LocalCommandLineRunner(object3.commandLine.split(" +"), System.out, printStream);
                CompilerRunner compilerRunner = new CompilerRunner(object3, (ByteArrayOutputStream)exception, (LocalCommandLineRunner)object);
                arrayList.add(executorService.submit(compilerRunner));
            }
            catch (Exception exception2) {
                String string = String.valueOf(exception2.getMessage());
                System.err.println(string.length() != 0 ? "ERROR - ".concat(string) : new String("ERROR - "));
                exception2.printStackTrace(System.err);
            }
        }
        for (Future future : arrayList) {
            try {
                exception = (CompilerRunner)future.get();
                int n = ((CompilerRunner)exception).result;
                if (n != 0) {
                    System.err.println(new StringBuilder(36).append("ERROR: Compiler returned ").append(n).toString());
                }
                ((CompilerRunner)exception).errStream.flush();
                object = ((CompilerRunner)exception).descriptor.moduleName;
                System.err.println(new StringBuilder(19 + String.valueOf(object).length()).append("@@ START_MODULE:").append((String)object).append(" @@").toString());
                System.err.println(((CompilerRunner)exception).errStream.toString("UTF-8"));
                System.err.println("@@ END_MODULE @@");
            }
            catch (Exception exception3) {
                String string = String.valueOf(exception3.getMessage());
                System.err.println(string.length() != 0 ? "ERROR - ".concat(string) : new String("ERROR - "));
                exception3.printStackTrace(System.err);
            }
        }
        System.exit(0);
    }

    private List<CompilerInstanceDescriptor> getDescriptors() {
        ArrayList<CompilerInstanceDescriptor> arrayList = new ArrayList<CompilerInstanceDescriptor>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.flags.compilerArgsFile), "UTF-8"));){
            int n = 0;
            while (true) {
                ++n;
                String string = bufferedReader.readLine();
                if (string == null) {
                    break;
                }
                if (string.length() == 0) continue;
                String[] stringArray = string.split(" +", 2);
                if (stringArray.length != 2) {
                    this.logError(String.format("Line %d does not contain module name and compiler arguments", n), null);
                    continue;
                }
                arrayList.add(new CompilerInstanceDescriptor(stringArray[0], stringArray[1]));
            }
        }
        catch (IOException iOException) {
            this.logError("Failed to read compiler arguments file", iOException);
            return null;
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        Runner runner = new Runner(stringArray, System.err);
        if (runner.shouldRunCompiler()) {
            runner.run();
        } else {
            System.exit(-1);
        }
    }

    private static class CompilerInstanceDescriptor {
        private final String moduleName;
        private final String commandLine;

        public CompilerInstanceDescriptor(String string, String string2) {
            this.moduleName = string;
            this.commandLine = string2;
        }
    }

    private static class Flags {
        @Option(name="--compiler-args-file", usage="Full path to file containing compiler arguments (one line per instance)")
        private String compilerArgsFile = null;

        private Flags() {
        }
    }

    private static class CompilerRunner
    implements Callable<CompilerRunner> {
        private final CompilerInstanceDescriptor descriptor;
        private final ByteArrayOutputStream errStream;
        private int result;
        private final LocalCommandLineRunner runner;

        public CompilerRunner(CompilerInstanceDescriptor compilerInstanceDescriptor, ByteArrayOutputStream byteArrayOutputStream, LocalCommandLineRunner localCommandLineRunner) {
            this.descriptor = compilerInstanceDescriptor;
            this.errStream = byteArrayOutputStream;
            this.runner = localCommandLineRunner;
        }

        @Override
        public CompilerRunner call() throws Exception {
            if (!this.runner.shouldRunCompiler()) {
                this.result = -1;
            }
            this.result = this.runner.execute();
            return this;
        }
    }

    private static class LocalCommandLineRunner
    extends CommandLineRunner {
        protected LocalCommandLineRunner(String[] stringArray, PrintStream printStream, PrintStream printStream2) {
            super(stringArray, printStream, printStream2);
        }

        @Override
        protected CompilerOptions createOptions() {
            CompilerOptions compilerOptions = super.createOptions();
            compilerOptions.setIdeMode(true);
            compilerOptions.setReportMissingOverride(CheckLevel.ERROR);
            return compilerOptions;
        }

        @Override
        protected void setRunOptions(CompilerOptions compilerOptions) throws AbstractCommandLineRunner.FlagUsageException, IOException {
            super.setRunOptions(compilerOptions);
            compilerOptions.setCodingConvention(new DevToolsCodingConvention());
        }

        int execute() {
            int n = 0;
            int n2 = 1;
            try {
                for (int i = 0; i < n2 && n == 0; ++i) {
                    n = this.doRun();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                n = -2;
            }
            return n;
        }
    }
}

