/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;

public abstract class AbstractAccessControlNameCheck
extends AbstractNameCheck {
    private boolean applyToPublic = true;
    private boolean applyToProtected = true;
    private boolean applyToPackage = true;
    private boolean applyToPrivate = true;

    public AbstractAccessControlNameCheck(String format) {
        super(format);
    }

    @Override
    protected boolean mustCheckName(DetailAST ast) {
        return this.shouldCheckInScope(ast);
    }

    protected boolean shouldCheckInScope(DetailAST modifiers) {
        if (modifiers == null) {
            return this.applyToPackage;
        }
        boolean isPublic = modifiers.branchContains(62);
        boolean isProtected = modifiers.branchContains(63);
        boolean isPrivate = modifiers.branchContains(61);
        boolean isPackage = !isPublic && !isProtected && !isPrivate;
        return this.applyToPublic && isPublic || this.applyToProtected && isProtected || this.applyToPackage && isPackage || this.applyToPrivate && isPrivate;
    }

    public void setApplyToPublic(boolean applyTo) {
        this.applyToPublic = applyTo;
    }

    public boolean getApplyToPublic() {
        return this.applyToPublic;
    }

    public void setApplyToProtected(boolean applyTo) {
        this.applyToProtected = applyTo;
    }

    public boolean getApplyToProtected() {
        return this.applyToProtected;
    }

    public void setApplyToPackage(boolean applyTo) {
        this.applyToPackage = applyTo;
    }

    public boolean getApplyToPackage() {
        return this.applyToPackage;
    }

    public void setApplyToPrivate(boolean applyTo) {
        this.applyToPrivate = applyTo;
    }

    public boolean getApplyToPrivate() {
        return this.applyToPrivate;
    }
}

