/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class FullIdent {
    private final StringBuffer buffer = new StringBuffer();
    private int lineNo;
    private int colNo;

    private FullIdent() {
    }

    public String getText() {
        return this.buffer.toString();
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.colNo;
    }

    private void append(String text) {
        this.buffer.append(text);
    }

    private void append(DetailAST ast) {
        this.buffer.append(ast.getText());
        if (this.lineNo == 0) {
            this.lineNo = ast.getLineNo();
        } else if (ast.getLineNo() > 0) {
            this.lineNo = Math.min(this.lineNo, ast.getLineNo());
        }
        if (this.colNo == 0) {
            this.colNo = ast.getColumnNo();
        } else if (ast.getColumnNo() > 0) {
            this.colNo = Math.min(this.colNo, ast.getColumnNo());
        }
    }

    public static FullIdent createFullIdent(DetailAST ast) {
        FullIdent fi = new FullIdent();
        FullIdent.extractFullIdent(fi, ast);
        return fi;
    }

    public static FullIdent createFullIdentBelow(DetailAST ast) {
        return FullIdent.createFullIdent(ast.getFirstChild());
    }

    private static void extractFullIdent(FullIdent full, DetailAST ast) {
        if (ast == null) {
            return;
        }
        if (ast.getType() == 59) {
            FullIdent.extractFullIdent(full, ast.getFirstChild());
            full.append(".");
            FullIdent.extractFullIdent(full, ast.getFirstChild().getNextSibling());
        } else {
            full.append(ast);
        }
    }

    public String toString() {
        return this.getText() + "[" + this.getLineNo() + "x" + this.getColumnNo() + "]";
    }
}

