/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.Set;

public class IllegalTokenTextCheck
extends AbstractFormatCheck {
    public static final String MSG_KEY = "illegal.token.text";
    private String message = "";

    public IllegalTokenTextCheck() {
        super("$^");
    }

    @Override
    public void beginTree(DetailAST rootAST) {
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[0];
    }

    @Override
    public int[] getAcceptableTokens() {
        Set<String> tokenNames = this.getTokenNames();
        int[] result = new int[tokenNames.size()];
        int i = 0;
        for (String name : tokenNames) {
            result[i] = TokenTypes.getTokenId(name);
            ++i;
        }
        return result;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String text = ast.getText();
        if (this.getRegexp().matcher(text).find()) {
            String message = this.getMessage();
            if ("".equals(message)) {
                message = MSG_KEY;
            }
            this.log(ast.getLineNo(), ast.getColumnNo(), message, this.getFormat());
        }
    }

    public void setMessage(String message) {
        this.message = null == message ? "" : message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setIgnoreCase(boolean caseInsensitive) {
        if (caseInsensitive) {
            this.setCompileFlags(2);
        }
    }
}

