/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef BUDDYEDITOR_H
#define BUDDYEDITOR_H

#include "buddyeditor_global.h"

#include <connectionedit_p.h>
#include <QtCore/QPointer>
#include <QtCore/QSet>

QT_BEGIN_NAMESPACE

class QDesignerFormWindowInterface;

class QLabel;

namespace qdesigner_internal {

class QT_BUDDYEDITOR_EXPORT BuddyEditor : public ConnectionEdit
{
    Q_OBJECT

public:
    BuddyEditor(QDesignerFormWindowInterface *form, QWidget *parent);

    QDesignerFormWindowInterface *formWindow() const;
    void setBackground(QWidget *background) Q_DECL_OVERRIDE;
    virtual void deleteSelected();

public slots:
    virtual void updateBackground();
    void widgetRemoved(QWidget *w) Q_DECL_OVERRIDE;
    void autoBuddy();

protected:
    QWidget *widgetAt(const QPoint &pos) const Q_DECL_OVERRIDE;
    Connection *createConnection(QWidget *source, QWidget *destination) Q_DECL_OVERRIDE;
    void endConnection(QWidget *target, const QPoint &pos) Q_DECL_OVERRIDE;
    void createContextMenu(QMenu &menu) Q_DECL_OVERRIDE;

private:
    QWidget *findBuddy(QLabel *l, const QWidgetList &existingBuddies) const;

    QPointer<QDesignerFormWindowInterface> m_formWindow;
    bool m_updating;
};

}  // namespace qdesigner_internal

QT_END_NAMESPACE

#endif
