/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.EnumMap;

public final class MethodCountCheck
extends Check {
    private static final int DEFAULT_MAX_METHODS = 100;
    private int mMaxPrivate = 100;
    private int mMaxPackage = 100;
    private int mMaxProtected = 100;
    private int mMaxPublic = 100;
    private int mMaxTotal = 100;
    private final FastStack<MethodCounter> mCounters = new FastStack();

    public int[] getDefaultTokens() {
        return new int[]{14, 157, 156, 15, 9};
    }

    public void visitToken(DetailAST aAST) {
        if (14 == aAST.getType() || 15 == aAST.getType() || 157 == aAST.getType() || 156 == aAST.getType()) {
            this.mCounters.push(new MethodCounter(15 == aAST.getType()));
        } else if (9 == aAST.getType()) {
            this.raiseCounter(aAST);
        }
    }

    public void leaveToken(DetailAST aAST) {
        if (14 == aAST.getType() || 15 == aAST.getType() || 157 == aAST.getType() || 156 == aAST.getType()) {
            MethodCounter counter = this.mCounters.pop();
            this.checkCounters(counter, aAST);
        }
    }

    private void raiseCounter(DetailAST aMethod) {
        MethodCounter actualCounter = this.mCounters.peek();
        DetailAST temp = aMethod.findFirstToken(5);
        Scope scope = ScopeUtils.getScopeFromMods(temp);
        actualCounter.increment(scope);
    }

    private void checkCounters(MethodCounter aCounter, DetailAST aAst) {
        this.checkMax(this.mMaxPrivate, aCounter.value(Scope.PRIVATE), "too.many.privateMethods", aAst);
        this.checkMax(this.mMaxPackage, aCounter.value(Scope.PACKAGE), "too.many.packageMethods", aAst);
        this.checkMax(this.mMaxProtected, aCounter.value(Scope.PROTECTED), "too.many.protectedMethods", aAst);
        this.checkMax(this.mMaxPublic, aCounter.value(Scope.PUBLIC), "too.many.publicMethods", aAst);
        this.checkMax(this.mMaxTotal, aCounter.getTotal(), "too.many.methods", aAst);
    }

    private void checkMax(int aMax, int aValue, String aMsg, DetailAST aAst) {
        if (aMax < aValue) {
            this.log(aAst.getLineNo(), aMsg, aValue, aMax);
        }
    }

    public void setMaxPrivate(int aValue) {
        this.mMaxPrivate = aValue;
    }

    public void setMaxPackage(int aValue) {
        this.mMaxPackage = aValue;
    }

    public void setMaxProtected(int aValue) {
        this.mMaxProtected = aValue;
    }

    public void setMaxPublic(int aValue) {
        this.mMaxPublic = aValue;
    }

    public void setMaxTotal(int aValue) {
        this.mMaxTotal = aValue;
    }

    private static class MethodCounter {
        private final EnumMap<Scope, Integer> mCounts = new EnumMap(Scope.class);
        private final boolean mInInterface;
        private int mTotal;

        MethodCounter(boolean aInInterface) {
            this.mInInterface = aInInterface;
        }

        void increment(Scope aScope) {
            ++this.mTotal;
            if (this.mInInterface) {
                this.mCounts.put(Scope.PUBLIC, 1 + this.value(Scope.PUBLIC));
            } else {
                this.mCounts.put(aScope, 1 + this.value(aScope));
            }
        }

        int value(Scope aScope) {
            Integer value = this.mCounts.get((Object)aScope);
            return null == value ? 0 : value;
        }

        int getTotal() {
            return this.mTotal;
        }
    }
}

