/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the QtWebEngine module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPLv3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or later as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file. Please review the following information to
** ensure the GNU General Public License version 2.0 requirements will be
** met: http://www.gnu.org/licenses/gpl-2.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QQUICKWEBENGINEHISTORY_P_P_H
#define QQUICKWEBENGINEHISTORY_P_P_H

namespace QtWebEngineCore {
class WebContentsAdapter;
}

QT_BEGIN_NAMESPACE
class QQuickWebEngineHistoryListModel;
class QQuickWebEngineViewPrivate;

class QQuickWebEngineHistoryListModelPrivate {
public:
    QQuickWebEngineHistoryListModelPrivate(QQuickWebEngineViewPrivate*);
    virtual ~QQuickWebEngineHistoryListModelPrivate();

    virtual int count() const;
    virtual int index(int) const;
    virtual int offsetForIndex(int) const;

    QtWebEngineCore::WebContentsAdapter *adapter() const;

    QQuickWebEngineViewPrivate *view;
};

class QQuickWebEngineBackHistoryListModelPrivate : public QQuickWebEngineHistoryListModelPrivate {
public:
    QQuickWebEngineBackHistoryListModelPrivate(QQuickWebEngineViewPrivate*);

    int count() const override;
    int index(int) const override;
    int offsetForIndex(int) const override;
};

class QQuickWebEngineForwardHistoryListModelPrivate : public QQuickWebEngineHistoryListModelPrivate {
public:
    QQuickWebEngineForwardHistoryListModelPrivate(QQuickWebEngineViewPrivate*);

    int count() const override;
    int index(int) const override;
    int offsetForIndex(int) const override;
};

class QQuickWebEngineHistoryPrivate {
public:
    QQuickWebEngineHistoryPrivate(QQuickWebEngineViewPrivate*);
    ~QQuickWebEngineHistoryPrivate();

    QQuickWebEngineViewPrivate *m_view;
    mutable QScopedPointer<QQuickWebEngineHistoryListModel> m_navigationModel;
    mutable QScopedPointer<QQuickWebEngineHistoryListModel> m_backNavigationModel;
    mutable QScopedPointer<QQuickWebEngineHistoryListModel> m_forwardNavigationModel;
};

QT_END_NAMESPACE

#endif // QQUICKWEBENGINEHISTORY_P_P_H
