/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavadocUtils {
    private JavadocUtils() {
    }

    public static JavadocTags getJavadocTags(TextBlock aCmt, JavadocTagType aTagType) {
        String[] text = aCmt.getText();
        ArrayList<JavadocTag> tags = Lists.newArrayList();
        ArrayList<InvalidJavadocTag> invalidTags = Lists.newArrayList();
        Pattern blockTagPattern = Utils.getPattern("/\\*{2,}\\s*@(\\p{Alpha}+)\\s");
        for (int i = 0; i < text.length; ++i) {
            String s = text[i];
            Matcher blockTagMatcher = blockTagPattern.matcher(s);
            if ((aTagType.equals((Object)JavadocTagType.ALL) || aTagType.equals((Object)JavadocTagType.BLOCK)) && blockTagMatcher.find()) {
                String tagName = blockTagMatcher.group(1);
                String content = s.substring(blockTagMatcher.end(1));
                if (content.endsWith("*/")) {
                    content = content.substring(0, content.length() - 2);
                }
                int line = aCmt.getStartLineNo() + i;
                int col = blockTagMatcher.start(1) - 1;
                if (i == 0) {
                    col += aCmt.getStartColNo();
                }
                if (JavadocTagInfo.isValidName(tagName)) {
                    tags.add(new JavadocTag(line, col, tagName, content.trim()));
                } else {
                    invalidTags.add(new InvalidJavadocTag(line, col, tagName));
                }
            } else if (aTagType.equals((Object)JavadocTagType.ALL) || aTagType.equals((Object)JavadocTagType.INLINE)) {
                int commentOffset;
                String commentContents;
                Pattern commentPattern = Utils.getPattern("^\\s*(?:/\\*{2,}|\\*+)\\s*(.*)");
                Matcher commentMatcher = commentPattern.matcher(s);
                if (!commentMatcher.find()) {
                    commentContents = s;
                    commentOffset = 0;
                } else {
                    commentContents = commentMatcher.group(1);
                    commentOffset = commentMatcher.start(1) - 1;
                }
                Pattern tagPattern = Utils.getPattern(".*?\\{@(\\p{Alpha}+)\\s+(.*?)\\}");
                Matcher tagMatcher = tagPattern.matcher(commentContents);
                while (tagMatcher.find()) {
                    if (tagMatcher.groupCount() != 2) continue;
                    String tagName = tagMatcher.group(1);
                    String tagValue = tagMatcher.group(2).trim();
                    int line = aCmt.getStartLineNo() + i;
                    int col = commentOffset + (tagMatcher.start(1) - 1);
                    if (i == 0) {
                        col += aCmt.getStartColNo();
                    }
                    if (JavadocTagInfo.isValidName(tagName)) {
                        tags.add(new JavadocTag(line, col, tagName, tagValue));
                        continue;
                    }
                    invalidTags.add(new InvalidJavadocTag(line, col, tagName));
                }
            }
            blockTagPattern = Utils.getPattern("^\\s*\\**\\s*@(\\p{Alpha}+)\\s");
        }
        return new JavadocTags(tags, invalidTags);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavadocTagType {
        BLOCK,
        INLINE,
        ALL;

    }
}

