/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.Assignment;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.FunctionCall;
import com.google.javascript.rhino.head.ast.ObjectProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.ContextTrackingState;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;
import org.chromium.devtools.jsdoc.checks.TypeRecord;

public final class ProtoFollowsExtendsChecker
extends ContextTrackingChecker {
    private static final String PROTO_PROPERTY_NAME = "__proto__";
    private static final Set<String> IGNORED_SUPER_TYPES = new HashSet<String>();
    private final Set<TypeRecord> typesWithAssignedProto = new HashSet<TypeRecord>();
    private final Set<FunctionRecord> functionsMissingSuperCall = new HashSet<FunctionRecord>();

    @Override
    protected void enterNode(AstNode astNode) {
        switch (astNode.getType()) {
            case 90: {
                this.handleAssignment((Assignment)astNode);
                break;
            }
            case 103: {
                this.handleColonNode((ObjectProperty)astNode);
                break;
            }
            case 109: {
                this.enterFunction();
                break;
            }
            case 38: {
                this.handleCall((FunctionCall)astNode);
                break;
            }
        }
    }

    private void handleCall(FunctionCall functionCall) {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null || !functionRecord.isConstructor || !this.functionsMissingSuperCall.contains(functionRecord)) {
            return;
        }
        String string = this.validSuperConstructorName(functionCall);
        if (string == null) {
            return;
        }
        TypeRecord typeRecord = this.getState().typeRecordsByTypeName.get(functionRecord.name);
        if (typeRecord == null) {
            return;
        }
        TypeRecord.InheritanceEntry inheritanceEntry = typeRecord.getFirstExtendedType();
        if (inheritanceEntry == null || !inheritanceEntry.superTypeName.equals(string)) {
            return;
        }
        this.functionsMissingSuperCall.remove(functionRecord);
    }

    private String validSuperConstructorName(FunctionCall functionCall) {
        String string = this.getContext().getNodeText(functionCall.getTarget());
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        if (!"call".equals(string2) && !"apply".equals(string2)) {
            return null;
        }
        List<AstNode> list = functionCall.getArguments();
        if (list.isEmpty() || !"this".equals(this.getContext().getNodeText(list.get(0)))) {
            return null;
        }
        return string.substring(0, n);
    }

    @Override
    protected void leaveNode(AstNode astNode) {
        if (astNode.getType() == 136) {
            this.checkFinished();
            return;
        }
        if (astNode.getType() == 109) {
            this.leaveFunction();
            return;
        }
    }

    private void enterFunction() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        TypeRecord.InheritanceEntry inheritanceEntry = this.getExtendedTypeToCheck(functionRecord);
        if (inheritanceEntry == null) {
            return;
        }
        if (!IGNORED_SUPER_TYPES.contains(inheritanceEntry.superTypeName)) {
            this.functionsMissingSuperCall.add(functionRecord);
        }
    }

    private void leaveFunction() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (!this.functionsMissingSuperCall.contains(functionRecord)) {
            return;
        }
        TypeRecord.InheritanceEntry inheritanceEntry = this.getExtendedTypeToCheck(functionRecord);
        if (inheritanceEntry == null) {
            return;
        }
        this.reportErrorAtNodeStart(AstUtil.getFunctionNameNode(functionRecord.functionNode), String.format("Type %s extends %s but does not properly invoke its constructor", functionRecord.name, inheritanceEntry.superTypeName));
    }

    private TypeRecord.InheritanceEntry getExtendedTypeToCheck(FunctionRecord functionRecord) {
        if (!functionRecord.isConstructor || functionRecord.name == null) {
            return null;
        }
        TypeRecord typeRecord = this.getState().typeRecordsByTypeName.get(functionRecord.name);
        if (typeRecord == null || typeRecord.isInterface) {
            return null;
        }
        return typeRecord.getFirstExtendedType();
    }

    private void checkFinished() {
        for (TypeRecord typeRecord : this.getState().getTypeRecordsByTypeName().values()) {
            TypeRecord.InheritanceEntry inheritanceEntry;
            if (typeRecord.isInterface || this.typesWithAssignedProto.contains(typeRecord) || (inheritanceEntry = typeRecord.getFirstExtendedType()) == null) continue;
            this.getContext().reportErrorInNode(inheritanceEntry.jsDocNode, inheritanceEntry.offsetInJsDocText, String.format("No __proto__ assigned for type %s having @extends", typeRecord.typeName));
        }
    }

    private void handleColonNode(ObjectProperty objectProperty) {
        String string;
        ContextTrackingState contextTrackingState = this.getState();
        TypeRecord typeRecord = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord == null) {
            return;
        }
        String string2 = contextTrackingState.getNodeText(objectProperty.getLeft());
        if (!PROTO_PROPERTY_NAME.equals(string2)) {
            return;
        }
        TypeRecord typeRecord2 = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord2 == null) {
            return;
        }
        this.typesWithAssignedProto.add(typeRecord2);
        String string3 = contextTrackingState.getNodeText(objectProperty.getRight());
        boolean bl = "null".equals(string3);
        if (!bl && !AstUtil.isPrototypeName(string3)) {
            this.reportErrorAtNodeStart(objectProperty.getRight(), "__proto__ value is not a prototype");
            return;
        }
        String string4 = string = bl ? "null" : AstUtil.getTypeNameFromPrototype(string3);
        if (typeRecord.isInterface) {
            this.reportErrorAtNodeStart(objectProperty.getLeft(), String.format("__proto__ defined for interface %s", typeRecord.typeName));
            return;
        }
        if (!bl && typeRecord.extendedTypes.isEmpty()) {
            this.reportErrorAtNodeStart(objectProperty.getRight(), String.format("No @extends annotation for %s extending %s", typeRecord.typeName, string));
            return;
        }
        if (bl) {
            return;
        }
        TypeRecord.InheritanceEntry inheritanceEntry = typeRecord.getFirstExtendedType();
        String string5 = inheritanceEntry.superTypeName;
        if (!string.equals(string5)) {
            this.reportErrorAtNodeStart(objectProperty.getRight(), String.format("Supertype does not match %s declared in @extends for %s (line %d)", string5, typeRecord.typeName, contextTrackingState.getContext().getPosition((AstNode)inheritanceEntry.jsDocNode, (int)inheritanceEntry.offsetInJsDocText).line));
        }
    }

    private void handleAssignment(Assignment assignment) {
        String string = this.getState().getNodeText(AstUtil.getAssignedTypeNameNode(assignment));
        if (string == null) {
            return;
        }
        if (!AstUtil.isPrototypeName(string)) {
            return;
        }
        AstNode astNode = assignment.getRight();
        if (astNode.getType() == 66) {
            return;
        }
        ContextTrackingState contextTrackingState = this.getState();
        TypeRecord typeRecord = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord == null) {
            return;
        }
        if (!typeRecord.extendedTypes.isEmpty()) {
            this.reportErrorAtNodeStart(astNode, String.format("@extends found for type %s but its prototype is not an object containing __proto__", AstUtil.getTypeNameFromPrototype(string)));
        }
    }

    static {
        IGNORED_SUPER_TYPES.add("WebInspector.Object");
    }
}

